/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.ConverterRegistry;
import com.thoughtworks.xstream.core.Caching;
import com.thoughtworks.xstream.core.util.Cloneables;
import com.thoughtworks.xstream.core.util.PrioritizedList;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultConverterLookup
implements ConverterLookup,
ConverterRegistry,
Caching {
    private final PrioritizedList converters = new PrioritizedList();
    private transient Map typeToConverterMap;
    private Map serializationMap = null;

    public DefaultConverterLookup() {
        this(new HashMap());
    }

    public DefaultConverterLookup(Map map2) {
        this.typeToConverterMap = map2;
        this.typeToConverterMap.clear();
    }

    public DefaultConverterLookup(Mapper mapper) {
        this();
    }

    public Converter lookupConverterForType(Class type2) {
        Converter cachedConverter;
        Converter converter = cachedConverter = type2 != null ? (Converter)this.typeToConverterMap.get(type2.getName()) : null;
        if (cachedConverter != null) {
            return cachedConverter;
        }
        LinkedHashMap<String, String> errors = new LinkedHashMap<String, String>();
        Iterator iterator2 = this.converters.iterator();
        while (iterator2.hasNext()) {
            Converter converter2 = (Converter)iterator2.next();
            try {
                if (!converter2.canConvert(type2)) continue;
                if (type2 != null) {
                    this.typeToConverterMap.put(type2.getName(), converter2);
                }
                return converter2;
            }
            catch (RuntimeException e) {
                errors.put(converter2.getClass().getName(), e.getMessage());
            }
            catch (LinkageError e) {
                errors.put(converter2.getClass().getName(), e.getMessage());
            }
        }
        ConversionException exception = new ConversionException(errors.isEmpty() ? "No converter specified" : "No converter available");
        exception.add("type", type2 != null ? type2.getName() : "null");
        iterator2 = errors.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            exception.add("converter", entry.getKey().toString());
            exception.add("message", entry.getValue().toString());
        }
        throw exception;
    }

    public void registerConverter(Converter converter, int priority) {
        this.typeToConverterMap.clear();
        this.converters.add(converter, priority);
    }

    public void flushCache() {
        this.typeToConverterMap.clear();
        Iterator iterator2 = this.converters.iterator();
        while (iterator2.hasNext()) {
            Converter converter = (Converter)iterator2.next();
            if (!(converter instanceof Caching)) continue;
            ((Caching)((Object)converter)).flushCache();
        }
    }

    private Object writeReplace() {
        this.serializationMap = (Map)Cloneables.cloneIfPossible(this.typeToConverterMap);
        this.serializationMap.clear();
        return this;
    }

    private Object readResolve() {
        this.typeToConverterMap = this.serializationMap == null ? new HashMap() : this.serializationMap;
        this.serializationMap = null;
        return this;
    }
}

