/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow;

public class SurfaceScaleUtils {
    private static final float EPSILON = 1.1920929E-7f;

    private static boolean isZero(float f) {
        return Math.abs(f) < 1.1920929E-7f;
    }

    public static int scale(int n, float f) {
        return (int)((float)n * f + 0.5f);
    }

    public static int scaleInv(int n, float f) {
        return (int)((float)n / f + 0.5f);
    }

    public static int[] scale(int[] nArray, int[] nArray2, float[] fArray) {
        nArray[0] = (int)((float)nArray2[0] * fArray[0] + 0.5f);
        nArray[1] = (int)((float)nArray2[1] * fArray[1] + 0.5f);
        return nArray;
    }

    public static int[] scaleInv(int[] nArray, int[] nArray2, float[] fArray) {
        nArray[0] = (int)((float)nArray2[0] / fArray[0] + 0.5f);
        nArray[1] = (int)((float)nArray2[1] / fArray[1] + 0.5f);
        return nArray;
    }

    public static float clampPixelScale(float f, float f2, float f3) {
        if (SurfaceScaleUtils.isZero(f - 1.0f)) {
            return 1.0f;
        }
        if (SurfaceScaleUtils.isZero(f - 0.0f) || f > f3 || SurfaceScaleUtils.isZero(f - f3)) {
            return f3;
        }
        if (f < f2 || SurfaceScaleUtils.isZero(f - f2)) {
            return f2;
        }
        return f;
    }

    public static float[] clampPixelScale(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        fArray[0] = SurfaceScaleUtils.clampPixelScale(fArray2[0], fArray3[0], fArray4[0]);
        fArray[1] = SurfaceScaleUtils.clampPixelScale(fArray2[1], fArray3[1], fArray4[1]);
        return fArray;
    }

    public static boolean setNewPixelScale(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, String string2) {
        boolean bl;
        float f = SurfaceScaleUtils.clampPixelScale(fArray3[0], fArray4[0], fArray5[0]);
        float f2 = SurfaceScaleUtils.clampPixelScale(fArray3[1], fArray4[1], fArray5[1]);
        boolean bl2 = bl = f != fArray2[0] || f2 != fArray2[1];
        if (null != string2) {
            System.err.println(string2 + ".setNewPixelScale: pre[" + fArray2[0] + ", " + fArray2[1] + "], req[" + fArray3[0] + ", " + fArray3[1] + "], min[" + fArray4[0] + ", " + fArray4[1] + "], max[" + fArray5[0] + ", " + fArray5[1] + "] -> result[" + f + ", " + f2 + "], changed " + bl);
        }
        fArray[0] = f;
        fArray[1] = f2;
        return bl;
    }
}

