/*
 * Decompiled with CFR 0.152.
 */
package joptsimple;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import joptsimple.HelpFormatter;
import joptsimple.OptionDescriptor;
import joptsimple.ParserRules;
import joptsimple.internal.Classes;
import joptsimple.internal.Messages;
import joptsimple.internal.Rows;
import joptsimple.internal.Strings;

public class BuiltinHelpFormatter
implements HelpFormatter {
    private final Rows nonOptionRows;
    private final Rows optionRows;

    BuiltinHelpFormatter() {
        this(80, 2);
    }

    public BuiltinHelpFormatter(int desiredOverallWidth, int desiredColumnSeparatorWidth) {
        this.nonOptionRows = new Rows(desiredOverallWidth * 2, 0);
        this.optionRows = new Rows(desiredOverallWidth, desiredColumnSeparatorWidth);
    }

    @Override
    public String format(Map<String, ? extends OptionDescriptor> options) {
        this.optionRows.reset();
        this.nonOptionRows.reset();
        Comparator<OptionDescriptor> comparator = new Comparator<OptionDescriptor>(){

            @Override
            public int compare(OptionDescriptor first2, OptionDescriptor second2) {
                return first2.options().iterator().next().compareTo(second2.options().iterator().next());
            }
        };
        TreeSet<OptionDescriptor> sorted2 = new TreeSet<OptionDescriptor>(comparator);
        sorted2.addAll(options.values());
        this.addRows(sorted2);
        return this.formattedHelpOutput();
    }

    protected void addOptionRow(String single2) {
        this.addOptionRow(single2, "");
    }

    protected void addOptionRow(String left, String right) {
        this.optionRows.add(left, right);
    }

    protected void addNonOptionRow(String single2) {
        this.nonOptionRows.add(single2, "");
    }

    protected void fitRowsToWidth() {
        this.nonOptionRows.fitToWidth();
        this.optionRows.fitToWidth();
    }

    protected String nonOptionOutput() {
        return this.nonOptionRows.render();
    }

    protected String optionOutput() {
        return this.optionRows.render();
    }

    protected String formattedHelpOutput() {
        StringBuilder formatted = new StringBuilder();
        String nonOptionDisplay = this.nonOptionOutput();
        if (!Strings.isNullOrEmpty(nonOptionDisplay)) {
            formatted.append(nonOptionDisplay).append(Strings.LINE_SEPARATOR);
        }
        formatted.append(this.optionOutput());
        return formatted.toString();
    }

    protected void addRows(Collection<? extends OptionDescriptor> options) {
        this.addNonOptionsDescription(options);
        if (options.isEmpty()) {
            this.addOptionRow(this.message("no.options.specified", new Object[0]));
        } else {
            this.addHeaders(options);
            this.addOptions(options);
        }
        this.fitRowsToWidth();
    }

    protected void addNonOptionsDescription(Collection<? extends OptionDescriptor> options) {
        OptionDescriptor nonOptions = this.findAndRemoveNonOptionsSpec(options);
        if (this.shouldShowNonOptionArgumentDisplay(nonOptions)) {
            this.addNonOptionRow(this.message("non.option.arguments.header", new Object[0]));
            this.addNonOptionRow(this.createNonOptionArgumentsDisplay(nonOptions));
        }
    }

    protected boolean shouldShowNonOptionArgumentDisplay(OptionDescriptor nonOptionDescriptor) {
        return !Strings.isNullOrEmpty(nonOptionDescriptor.description()) || !Strings.isNullOrEmpty(nonOptionDescriptor.argumentTypeIndicator()) || !Strings.isNullOrEmpty(nonOptionDescriptor.argumentDescription());
    }

    protected String createNonOptionArgumentsDisplay(OptionDescriptor nonOptionDescriptor) {
        StringBuilder buffer = new StringBuilder();
        this.maybeAppendOptionInfo(buffer, nonOptionDescriptor);
        this.maybeAppendNonOptionsDescription(buffer, nonOptionDescriptor);
        return buffer.toString();
    }

    protected void maybeAppendNonOptionsDescription(StringBuilder buffer, OptionDescriptor nonOptions) {
        buffer.append(buffer.length() > 0 && !Strings.isNullOrEmpty(nonOptions.description()) ? " -- " : "").append(nonOptions.description());
    }

    protected OptionDescriptor findAndRemoveNonOptionsSpec(Collection<? extends OptionDescriptor> options) {
        Iterator<? extends OptionDescriptor> it = options.iterator();
        while (it.hasNext()) {
            OptionDescriptor next2 = it.next();
            if (!next2.representsNonOptions()) continue;
            it.remove();
            return next2;
        }
        throw new AssertionError((Object)"no non-options argument spec");
    }

    protected void addHeaders(Collection<? extends OptionDescriptor> options) {
        if (this.hasRequiredOption(options)) {
            this.addOptionRow(this.message("option.header.with.required.indicator", new Object[0]), this.message("description.header", new Object[0]));
            this.addOptionRow(this.message("option.divider.with.required.indicator", new Object[0]), this.message("description.divider", new Object[0]));
        } else {
            this.addOptionRow(this.message("option.header", new Object[0]), this.message("description.header", new Object[0]));
            this.addOptionRow(this.message("option.divider", new Object[0]), this.message("description.divider", new Object[0]));
        }
    }

    protected final boolean hasRequiredOption(Collection<? extends OptionDescriptor> options) {
        for (OptionDescriptor optionDescriptor : options) {
            if (!optionDescriptor.isRequired()) continue;
            return true;
        }
        return false;
    }

    protected void addOptions(Collection<? extends OptionDescriptor> options) {
        for (OptionDescriptor optionDescriptor : options) {
            if (optionDescriptor.representsNonOptions()) continue;
            this.addOptionRow(this.createOptionDisplay(optionDescriptor), this.createDescriptionDisplay(optionDescriptor));
        }
    }

    protected String createOptionDisplay(OptionDescriptor descriptor2) {
        StringBuilder buffer = new StringBuilder(descriptor2.isRequired() ? "* " : "");
        Iterator<String> i = descriptor2.options().iterator();
        while (i.hasNext()) {
            String option = i.next();
            buffer.append(this.optionLeader(option));
            buffer.append(option);
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        this.maybeAppendOptionInfo(buffer, descriptor2);
        return buffer.toString();
    }

    protected String optionLeader(String option) {
        return option.length() > 1 ? "--" : ParserRules.HYPHEN;
    }

    protected void maybeAppendOptionInfo(StringBuilder buffer, OptionDescriptor descriptor2) {
        String indicator = this.extractTypeIndicator(descriptor2);
        String description2 = descriptor2.argumentDescription();
        if (descriptor2.acceptsArguments() || !Strings.isNullOrEmpty(description2) || descriptor2.representsNonOptions()) {
            this.appendOptionHelp(buffer, indicator, description2, descriptor2.requiresArgument());
        }
    }

    protected String extractTypeIndicator(OptionDescriptor descriptor2) {
        String indicator = descriptor2.argumentTypeIndicator();
        if (!Strings.isNullOrEmpty(indicator) && !String.class.getName().equals(indicator)) {
            return Classes.shortNameOf(indicator);
        }
        return "String";
    }

    protected void appendOptionHelp(StringBuilder buffer, String typeIndicator, String description2, boolean required) {
        if (required) {
            this.appendTypeIndicator(buffer, typeIndicator, description2, '<', '>');
        } else {
            this.appendTypeIndicator(buffer, typeIndicator, description2, '[', ']');
        }
    }

    protected void appendTypeIndicator(StringBuilder buffer, String typeIndicator, String description2, char start, char end) {
        buffer.append(' ').append(start);
        if (typeIndicator != null) {
            buffer.append(typeIndicator);
        }
        if (!Strings.isNullOrEmpty(description2)) {
            if (typeIndicator != null) {
                buffer.append(": ");
            }
            buffer.append(description2);
        }
        buffer.append(end);
    }

    protected String createDescriptionDisplay(OptionDescriptor descriptor2) {
        List<?> defaultValues = descriptor2.defaultValues();
        if (defaultValues.isEmpty()) {
            return descriptor2.description();
        }
        String defaultValuesDisplay = this.createDefaultValuesDisplay(defaultValues);
        return (descriptor2.description() + ' ' + Strings.surround(this.message("default.value.header", new Object[0]) + ' ' + defaultValuesDisplay, '(', ')')).trim();
    }

    protected String createDefaultValuesDisplay(List<?> defaultValues) {
        return defaultValues.size() == 1 ? defaultValues.get(0).toString() : defaultValues.toString();
    }

    protected String message(String keySuffix, Object ... args2) {
        return Messages.message(Locale.getDefault(), "joptsimple.HelpFormatterMessages", BuiltinHelpFormatter.class, keySuffix, args2);
    }
}

