/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.io.InputStream;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectJavaClassFinderKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClassFinderKt;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.builtins.BuiltInSerializerProtocol;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.builtins.BuiltInsResourceLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectKotlinClassFinder
implements KotlinClassFinder {
    @NotNull
    private final ClassLoader classLoader;
    @NotNull
    private final BuiltInsResourceLoader builtInsResourceLoader;

    public ReflectKotlinClassFinder(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter(classLoader, "classLoader");
        this.classLoader = classLoader;
        this.builtInsResourceLoader = new BuiltInsResourceLoader();
    }

    private final KotlinClassFinder.Result findKotlinClass(String fqName2) {
        KotlinClassFinder.Result.KotlinClass kotlinClass2;
        Class<?> clazz = ReflectJavaClassFinderKt.tryLoadClass(this.classLoader, fqName2);
        if (clazz == null) {
            kotlinClass2 = null;
        } else {
            Object object = clazz;
            boolean bl = false;
            boolean bl2 = false;
            Class<?> it = object;
            boolean bl3 = false;
            ReflectKotlinClass reflectKotlinClass = ReflectKotlinClass.Factory.create(it);
            if (reflectKotlinClass == null) {
                kotlinClass2 = null;
            } else {
                object = reflectKotlinClass;
                bl = false;
                bl2 = false;
                KotlinJvmBinaryClass p0 = (KotlinJvmBinaryClass)object;
                kotlinClass2 = new KotlinClassFinder.Result.KotlinClass(p0, null, 2, null);
            }
        }
        return kotlinClass2;
    }

    @Override
    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return this.findKotlinClass(ReflectKotlinClassFinderKt.access$toRuntimeFqName(classId));
    }

    @Override
    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull JavaClass javaClass) {
        String string2;
        Intrinsics.checkNotNullParameter(javaClass, "javaClass");
        FqName fqName2 = javaClass.getFqName();
        String string3 = string2 = fqName2 == null ? null : fqName2.asString();
        if (string2 == null) {
            return null;
        }
        String string4 = string2;
        return this.findKotlinClass(string4);
    }

    @Override
    @Nullable
    public InputStream findBuiltInsData(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        if (!packageFqName.startsWith(StandardNames.BUILT_INS_PACKAGE_NAME)) {
            return null;
        }
        return this.builtInsResourceLoader.loadResource(BuiltInSerializerProtocol.INSTANCE.getBuiltInsFilePath(packageFqName));
    }
}

