/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.api;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum CinematicState {
    UNKNOWN(-1),
    LOADING(0),
    ACTIVE(10);

    private static final Map<Integer, CinematicState> stateValueMap;
    private final int state;

    private CinematicState(int state) {
        this.state = state;
    }

    public static CinematicState of(int state) {
        return stateValueMap.getOrDefault(state, UNKNOWN);
    }

    public int getState() {
        return this.state;
    }

    static {
        stateValueMap = Arrays.stream(CinematicState.values()).collect(Collectors.toMap(gs -> gs.state, Function.identity()));
    }
}

