/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.game;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import net.runelite.client.RuneLiteProperties;
import net.runelite.http.api.RuneLiteAPI;
import net.runelite.http.api.item.ItemPrice;
import net.runelite.http.api.item.ItemStats;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemClient {
    private static final Logger log = LoggerFactory.getLogger(ItemClient.class);
    private final OkHttpClient client;
    private final HttpUrl apiBase;
    private final HttpUrl staticBase;

    @Inject
    private ItemClient(OkHttpClient client, @Named(value="runelite.api.base") HttpUrl apiBase, @Named(value="runelite.static.base") HttpUrl staticBase) {
        this.client = client;
        this.apiBase = apiBase;
        this.staticBase = staticBase;
    }

    public ItemPrice[] getPrices() throws IOException {
        ItemPrice[] itemPriceArray;
        block9: {
            String resourceName = "/items.json";
            InputStream inputStream2 = this.getClass().getResourceAsStream(resourceName);
            InputStream inputStream3 = inputStream2;
            try {
                if (inputStream2 == null) {
                    throw new IOException("Resource not found: " + resourceName);
                }
                itemPriceArray = new Gson().fromJson((Reader)new InputStreamReader(inputStream2, StandardCharsets.UTF_8), ItemPrice[].class);
                if (inputStream3 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream3 != null) {
                        try {
                            inputStream3.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException ex) {
                    throw new IOException(ex);
                }
            }
            inputStream3.close();
        }
        return itemPriceArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<Integer, ItemStats> getStats() throws IOException {
        HttpUrl.Builder urlBuilder = this.staticBase.newBuilder().addPathSegment("item").addPathSegment("stats.ids.min.json");
        HttpUrl url = urlBuilder.build();
        if (RuneLiteProperties.DEBUG_MODE.booleanValue()) {
            log.debug("Built URI: {}", (Object)url);
        }
        Request request = new Request.Builder().url(url).build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                log.warn("Error looking up item stats: {}", (Object)response);
                Map<Integer, ItemStats> map2 = null;
                return map2;
            }
            InputStream in = response.body().byteStream();
            Type typeToken = new TypeToken<Map<Integer, ItemStats>>(){}.getType();
            Map map3 = (Map)RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), typeToken);
            return map3;
        }
        catch (JsonParseException ex) {
            throw new IOException(ex);
        }
    }
}

