/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.game.npcoverlay;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.lang.reflect.Field;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.outline.ModelOutlineRenderer;

public class NpcEnchantmentOverlay
extends Overlay {
    private final Client client;
    private final ModelOutlineRenderer modelOutlineRenderer;
    private static final int EFFECT_ATTACK_SPEED = 0;
    private static final int EFFECT_ACCURACY = 1;
    private static final int EFFECT_DAMAGE = 2;
    private static final int EFFECT_DEFENCE = 3;
    private static final int EFFECT_HP = 4;
    private static final int EFFECT_THORNS = 5;
    private static final int EFFECT_DOUBLE_SLAYER = 6;
    private static final int EFFECT_DOUBLE_DROPS = 7;
    private static final int EFFECT_UNLIMITED_TP = 8;
    private static final int EFFECT_HARVEST_SPEED = 9;
    private static final int EFFECT_NOTED = 10;
    private static final int EFFECT_XP = 11;
    private static final int EFFECT_FREEZE = 12;
    private static final int EFFECT_BURN = 13;

    @Inject
    public NpcEnchantmentOverlay(Client client, ModelOutlineRenderer modelOutlineRenderer) {
        this.client = client;
        this.modelOutlineRenderer = modelOutlineRenderer;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        try {
            NPC[] npcs = this.client.getCachedNPCs();
            if (npcs == null) {
                return null;
            }
            Map<Integer, Map<Integer, Integer>> allEnchantments = this.getNpcEnchantments();
            if (allEnchantments == null || allEnchantments.isEmpty()) {
                return null;
            }
            for (NPC npc : npcs) {
                Map<Integer, Integer> enchantments;
                int serverNpcIndex;
                if (npc == null || (serverNpcIndex = this.getNpcServerIndex(npc)) == -1 || (enchantments = allEnchantments.get(serverNpcIndex)) == null || enchantments.isEmpty()) continue;
                Map.Entry<Integer, Integer> entry = enchantments.entrySet().iterator().next();
                int effectId = entry.getKey();
                Color outlineColor = this.getColorForEffect(effectId);
                this.modelOutlineRenderer.drawOutline(npc, 4, outlineColor, 2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private int getNpcServerIndex(NPC npc) {
        try {
            Field field = npc.getClass().getField("npcIndex");
            Object value = field.get(npc);
            return value != null ? (Integer)value : -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private Map<Integer, Map<Integer, Integer>> getNpcEnchantments() {
        try {
            Class<?> clientClass = Class.forName("com.client.Client");
            Object instance = clientClass.getField("instance").get(null);
            if (instance == null) {
                return null;
            }
            Field field = clientClass.getDeclaredField("npcEnchantData");
            field.setAccessible(true);
            return (Map)field.get(instance);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Color getColorForEffect(int effectId) {
        switch (effectId) {
            case 0: {
                return new Color(0x6699FF);
            }
            case 1: {
                return new Color(0x99FF99);
            }
            case 2: {
                return new Color(0x99FF99);
            }
            case 3: {
                return new Color(0x888888);
            }
            case 4: {
                return new Color(0x888888);
            }
            case 5: {
                return new Color(0x888888);
            }
            case 6: {
                return new Color(0x55FFFF);
            }
            case 7: {
                return new Color(16771191);
            }
            case 8: {
                return new Color(0xAA33FF);
            }
            case 9: {
                return new Color(0xCCFFAA);
            }
            case 10: {
                return new Color(0x33CC66);
            }
            case 11: {
                return new Color(0x33CC66);
            }
            case 12: {
                return new Color(13175);
            }
            case 13: {
                return new Color(0x992200);
            }
        }
        return Color.WHITE;
    }
}

