/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.calculator.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.runelite.client.plugins.calculator.CalculatorPlugin;
import net.runelite.client.plugins.calculator.ui.CalculatorButton;
import net.runelite.client.plugins.calculator.ui.CalculatorPluginPanel;
import net.runelite.client.plugins.calculator.ui.DisplayField;
import net.runelite.client.util.ImageUtil;
import org.apache.commons.lang3.StringUtils;

public class CalculatorPanel
extends JPanel {
    private static final ImageIcon PLUS_MINUS_ICON;
    private static final Insets INSETS_LEFT_BORDER;
    private static final Insets INSETS_RIGHT_BORDER;
    private static final Insets INSETS;
    private final CalculatorPluginPanel panel;
    private final DisplayField displayField;
    private final GridBagConstraints c;

    protected CalculatorPanel(CalculatorPluginPanel panel) {
        this.panel = panel;
        this.displayField = panel.getDisplayField();
        this.setLayout(new GridBagLayout());
        this.c = new GridBagConstraints();
        this.c.fill = 2;
        this.c.gridx = 0;
        this.c.gridy = 0;
        CalculatorButton plusMinus = new CalculatorButton(PLUS_MINUS_ICON);
        this.addButton("+");
        this.addButton("7");
        this.addButton("8");
        this.addButton("9");
        this.addButton("-");
        this.addButton("4");
        this.addButton("5");
        this.addButton("6");
        this.addButton("*");
        this.addButton("1");
        this.addButton("2");
        this.addButton("3");
        this.addButton("/");
        this.addButton("0");
        this.addComp(plusMinus);
        this.addButton("=");
        this.addButton("C");
        this.c.gridwidth = 3;
        this.addButton("Clear History");
        plusMinus.addActionListener(e -> {
            if (this.displayField.isFinished()) {
                this.displayField.reset();
                if (this.displayField.getPreviousResult() != null) {
                    this.displayField.setNum1(this.displayField.getPreviousResult());
                } else {
                    this.displayField.setNum1(0);
                }
                this.displayField.setNum1(this.displayField.getNum1() * -1);
                this.displayField.setFinished(false);
            } else if (this.displayField.getCalculatorAction() == null) {
                this.displayField.setNum1(this.displayField.getNum1() * -1);
            } else {
                Integer num2 = this.displayField.getNum2();
                if (num2 == null) {
                    num2 = 0;
                }
                this.displayField.setNum2(num2 * -1);
            }
            this.displayField.update();
        });
    }

    private void addButton(String key) {
        CalculatorButton btn = new CalculatorButton(key);
        btn.addActionListener(e -> {
            String text = btn.getText();
            if (text.equals("=")) {
                this.displayField.calculateResult();
                if (this.displayField.getResult() == null) {
                    return;
                }
                this.panel.getHistoryPanel().addHistoryItem(this.displayField.getText() + " =", this.displayField.getResult().toString());
            } else {
                if (text.equals("C")) {
                    this.displayField.clear();
                    return;
                }
                if (text.equals("Clear History")) {
                    this.panel.getHistoryPanel().clearHistory();
                    return;
                }
                if (StringUtils.isNumeric(text)) {
                    int num = Integer.parseInt(text);
                    if (this.displayField.isFinished()) {
                        this.displayField.reset();
                        this.displayField.setNum1(num);
                        this.displayField.setFinished(false);
                    } else if (this.displayField.getCalculatorAction() == null) {
                        Integer num1 = this.displayField.getNum1();
                        if (num1 == 0) {
                            if (this.displayField.num1IsNegativeZero()) {
                                num *= -1;
                            }
                            this.displayField.setNum1(num);
                        } else if (num1 < 0) {
                            this.displayField.setNum1(num1 * 10 - num);
                        } else {
                            this.displayField.setNum1(num1 * 10 + num);
                        }
                    } else {
                        Integer num2 = this.displayField.getNum2();
                        if (num2 == null || num2 == 0) {
                            if (this.displayField.num2IsNegativeZero()) {
                                num *= -1;
                            }
                            this.displayField.setNum2(num);
                        } else if (num2 < 0) {
                            this.displayField.setNum2(num2 * 10 - num);
                        } else {
                            this.displayField.setNum2(num2 * 10 + num);
                        }
                    }
                } else {
                    if (this.displayField.isFinished() && this.displayField.getPreviousResult() != null) {
                        this.displayField.reset();
                        this.displayField.setNum1(this.displayField.getPreviousResult());
                        this.displayField.setFinished(false);
                        this.displayField.update();
                    }
                    if (this.displayField.getNum1() != null) {
                        switch (text) {
                            case "+": {
                                this.displayField.setCalculatorAction(DisplayField.Action.ADDITION);
                                break;
                            }
                            case "-": {
                                this.displayField.setCalculatorAction(DisplayField.Action.SUBTRACTION);
                                break;
                            }
                            case "*": {
                                this.displayField.setCalculatorAction(DisplayField.Action.MULTIPLICATION);
                                break;
                            }
                            case "/": {
                                this.displayField.setCalculatorAction(DisplayField.Action.DIVISION);
                            }
                        }
                    }
                    this.displayField.setNum2(null);
                }
            }
            this.displayField.update();
        });
        this.addComp(btn);
    }

    private void addComp(Component component) {
        switch (this.c.gridx) {
            case 0: {
                this.c.insets = INSETS_LEFT_BORDER;
                break;
            }
            case 3: {
                this.c.insets = INSETS_RIGHT_BORDER;
                break;
            }
            default: {
                this.c.insets = INSETS;
            }
        }
        if (this.c.gridwidth == 3) {
            this.c.insets = INSETS_RIGHT_BORDER;
        }
        this.add(component, this.c);
        ++this.c.gridx;
        this.c.gridx %= 4;
        this.c.gridy = this.c.gridx == 0 ? (this.c.gridy = this.c.gridy + 1) : this.c.gridy;
    }

    static {
        INSETS_LEFT_BORDER = new Insets(1, 0, 1, 1);
        INSETS_RIGHT_BORDER = new Insets(1, 1, 1, 0);
        INSETS = new Insets(1, 1, 1, 1);
        BufferedImage plusMinusIcon = ImageUtil.resizeImage(ImageUtil.getResourceStreamFromClass(CalculatorPlugin.class, "plus_minus_icon.png"), 25, 25);
        PLUS_MINUS_ICON = new ImageIcon(plusMinusIcon);
    }
}

