/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.donator;

import com.google.inject.Inject;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Named;
import net.runelite.api.Client;
import net.runelite.client.RuneLite;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.donator.DonatorConfig;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Donator", description="Enables the Donator store icon", tags={"donator", "store", "donate"})
public class DonatorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DonatorPlugin.class);
    @javax.inject.Inject
    private DonatorConfig config;
    @javax.inject.Inject
    private OverlayManager overlayManager;
    @javax.inject.Inject
    private Client client;
    @javax.inject.Inject
    private ClientUI clientUi;
    @javax.inject.Inject
    private ClientToolbar clientToolbar;
    @javax.inject.Inject
    private DrawManager drawManager;
    @javax.inject.Inject
    private ScheduledExecutorService executor;
    @Inject
    @Named(value="runelite.store")
    private String openStore;
    @javax.inject.Inject
    private KeyManager keyManager;
    private BufferedImage reportButton;
    private NavigationButton titleBarButton;
    private String kickPlayerName;

    @Provides
    DonatorConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(DonatorConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        RuneLite.SCREENSHOT_DIR.mkdirs();
        BufferedImage iconImage = ImageUtil.loadImageResource(this.getClass(), "5.png");
        this.titleBarButton = NavigationButton.builder().tooltip("Open Store").icon(iconImage).onClick(() -> LinkBrowser.browse(this.openStore)).build();
        this.clientToolbar.addNavigation(this.titleBarButton);
    }

    @Override
    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.titleBarButton);
        this.kickPlayerName = null;
    }

    BufferedImage getReportButton() {
        return this.reportButton;
    }
}

