/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.feed;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import net.runelite.api.events.FeedRecieved;
import net.runelite.client.Notifier;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.feed.FeedConfig;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import net.runelite.http.api.feed.FeedItem;
import net.runelite.http.api.feed.FeedItemType;
import net.runelite.http.api.feed.FeedResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class FeedPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(FeedPanel.class);
    private static final ImageIcon RUNELITE_ICON;
    private static final ImageIcon OSRS_ICON;
    private final ItemManager itemManager;
    private static final Color TWEET_BACKGROUND;
    private static final Color OSRS_NEWS_BACKGROUND;
    private static final Color BLOG_POST_BACKGROUND;
    private static final int MAX_CONTENT_LINES = 3;
    private static final int CONTENT_WIDTH = 148;
    private static final int TIME_WIDTH = 20;
    private static List<FeedItem> currentFeedItems;
    @Inject
    private Notifier notifier;
    private static final Comparator<FeedItem> FEED_ITEM_COMPARATOR;
    private final FeedConfig config;
    public Supplier<FeedResult> feedSupplier;

    @Inject
    FeedPanel(ItemManager itemManager, FeedConfig config, Supplier<FeedResult> feedSupplier) {
        this.itemManager = itemManager;
        this.config = config;
        this.feedSupplier = feedSupplier;
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new GridLayout(0, 1, 0, 4));
    }

    void rebuildFeed() {
        if (!currentFeedItems.isEmpty()) {
            currentFeedItems.removeIf(currentFeedItem -> currentFeedItem.getTimestamp() + TimeUnit.MINUTES.toMillis(2L) < System.currentTimeMillis());
        }
        if (currentFeedItems.isEmpty()) {
            this.reDrawFeed();
            return;
        }
        SwingUtilities.invokeLater(() -> {
            this.reDrawFeed();
            currentFeedItems.stream().filter(f -> f.getType() != FeedItemType.GROOT || this.config.includeGrootSpawns()).filter(f -> f.getType() != FeedItemType.DONOR_BOSS || this.config.includeDonorSpawns()).filter(f -> f.getType() != FeedItemType.VOTE_BOSS || this.config.includeVoteSpawns()).filter(f -> f.getType() != FeedItemType.WILDY_BOSS || this.config.includeWildySpawns()).filter(f -> f.getType() != FeedItemType.HESPORI_BOSS || this.config.includeHesporiSpawns()).filter(f -> f.getType() != FeedItemType.SHOOTING_STAR || this.config.includeStarSpawns()).filter(f -> f.getType() != FeedItemType.SEASONAL || this.config.includeSeasonalSpawns()).sorted(FEED_ITEM_COMPARATOR).forEach(this::addItemToPanel);
        });
    }

    private void addItemToPanel(final FeedItem item) {
        final JPanel avatarAndRight = new JPanel(new BorderLayout());
        avatarAndRight.setPreferredSize(new Dimension(0, 56));
        JLabel avatar = new JLabel();
        avatar.setPreferredSize(new Dimension(52, 48));
        avatar.setBorder(new EmptyBorder(0, 4, 0, 0));
        switch (item.getType()) {
            case GROOT: {
                avatar.setIcon(new ImageIcon(this.itemManager.getImage(1044, 1, false).getScaledInstance(32, 32, 4)));
                break;
            }
            case DONOR_BOSS: {
                avatar.setIcon(new ImageIcon(this.itemManager.getImage(1042, 1, false).getScaledInstance(32, 32, 4)));
                break;
            }
            case VOTE_BOSS: {
                avatar.setIcon(new ImageIcon(this.itemManager.getImage(1046, 1, false).getScaledInstance(32, 32, 4)));
                break;
            }
            case WILDY_BOSS: {
                avatar.setIcon(new ImageIcon(this.itemManager.getImage(1038, 1, false).getScaledInstance(32, 32, 4)));
                break;
            }
            case HESPORI_BOSS: {
                avatar.setIcon(new ImageIcon(this.itemManager.getImage(20661, 1, false).getScaledInstance(32, 32, 4)));
                break;
            }
            case SHOOTING_STAR: {
                avatar.setIcon(new ImageIcon(this.itemManager.getImage(25527, 100000000, true).getScaledInstance(32, 32, 4)));
                break;
            }
            case SEASONAL: {
                avatar.setIcon(new ImageIcon(this.itemManager.getImage(23108, 1, false).getScaledInstance(32, 32, 4)));
            }
        }
        avatarAndRight.setBackground(BLOG_POST_BACKGROUND);
        JPanel upAndContent = new JPanel();
        upAndContent.setLayout(new BoxLayout(upAndContent, 1));
        upAndContent.setBorder(new EmptyBorder(4, 8, 4, 4));
        upAndContent.setBackground(null);
        JPanel titleAndTime = new JPanel();
        titleAndTime.setLayout(new BorderLayout());
        titleAndTime.setBackground(null);
        Color darkerForeground = UIManager.getColor("Label.foreground").darker();
        JLabel titleLabel = new JLabel(item.getTitle());
        titleLabel.setFont(FontManager.getRunescapeSmallFont());
        titleLabel.setBackground(null);
        titleLabel.setForeground(darkerForeground);
        titleLabel.setPreferredSize(new Dimension(128, 0));
        Duration duration = Duration.between(Instant.ofEpochMilli(item.getTimestamp()), Instant.now());
        JLabel timeLabel = new JLabel(this.durationToString(duration));
        timeLabel.setFont(FontManager.getRunescapeSmallFont());
        timeLabel.setForeground(darkerForeground);
        titleAndTime.add((Component)titleLabel, "West");
        titleAndTime.add((Component)timeLabel, "East");
        JPanel content = new JPanel(new BorderLayout());
        content.setBackground(null);
        JLabel contentLabel = new JLabel(this.lineBreakText(item.getContent(), FontManager.getRunescapeSmallFont()));
        contentLabel.setBorder(new EmptyBorder(2, 0, 0, 0));
        contentLabel.setFont(FontManager.getRunescapeSmallFont());
        contentLabel.setForeground(darkerForeground);
        content.add((Component)contentLabel, "Center");
        upAndContent.add(titleAndTime);
        upAndContent.add(content);
        upAndContent.add(new Box.Filler(new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE), new Dimension(0, Short.MAX_VALUE)));
        avatarAndRight.add((Component)avatar, "West");
        avatarAndRight.add((Component)upAndContent, "Center");
        final Color backgroundColor = avatarAndRight.getBackground();
        final Color hoverColor = backgroundColor.brighter().brighter();
        final Color pressedColor = hoverColor.brighter();
        avatarAndRight.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                avatarAndRight.setBackground(hoverColor);
                avatarAndRight.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                avatarAndRight.setBackground(backgroundColor);
                avatarAndRight.setCursor(new Cursor(0));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    Container parent = avatarAndRight.getParent();
                    if (parent != null) {
                        parent.remove(avatarAndRight);
                        parent.revalidate();
                        parent.repaint();
                    }
                } else if (item.getUrl().contains("https:")) {
                    LinkBrowser.browse(item.getUrl());
                }
                avatarAndRight.setBackground(pressedColor);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                avatarAndRight.setBackground(hoverColor);
            }
        });
        this.add(avatarAndRight);
        this.revalidate();
        this.repaint();
    }

    private String durationToString(Duration duration) {
        if (duration.getSeconds() >= 86400L) {
            return (int)(duration.getSeconds() / 86400L) + "d";
        }
        if (duration.getSeconds() >= 3600L) {
            return (int)(duration.getSeconds() / 3600L) + "h";
        }
        return (int)(duration.getSeconds() / 60L) + "m";
    }

    private String lineBreakText(String text, Font font) {
        StringBuilder newText = new StringBuilder("<html>");
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), true, true);
        int lines = 0;
        int pos = 0;
        String[] words = text.split(" ");
        String line = "";
        while (lines < 3 && pos < words.length) {
            Object newLine = pos > 0 ? line + " " + words[pos] : words[pos];
            double width = font.getStringBounds((String)newLine, fontRenderContext).getWidth();
            if (width >= 148.0) {
                newText.append(line);
                newText.append("<br>");
                line = "";
                ++lines;
                continue;
            }
            line = newLine;
            ++pos;
        }
        newText.append(line);
        newText.append("</html>");
        return newText.toString();
    }

    public void onFeedRecieved(FeedRecieved feedRecieved) {
        FeedResult initialFeedResult = new FeedResult(feedRecieved.getItems());
        currentFeedItems.addAll(initialFeedResult.getItems());
        feedRecieved.getItems().forEach(feedItem -> {
            if (feedItem.getType() == FeedItemType.GROOT && this.config.includeGrootSpawns()) {
                if (this.config.notificationSounds()) {
                    Toolkit.getDefaultToolkit().beep();
                }
                if (this.config.trayNotification()) {
                    this.notifier.notify(feedItem.content, TrayIcon.MessageType.INFO);
                }
            }
            if (feedItem.getType() == FeedItemType.DONOR_BOSS && this.config.includeDonorSpawns()) {
                if (this.config.notificationSounds()) {
                    Toolkit.getDefaultToolkit().beep();
                }
                if (this.config.trayNotification()) {
                    this.notifier.notify(feedItem.content, TrayIcon.MessageType.INFO);
                }
            }
            if (feedItem.getType() == FeedItemType.VOTE_BOSS && this.config.includeVoteSpawns()) {
                if (this.config.notificationSounds()) {
                    Toolkit.getDefaultToolkit().beep();
                }
                if (this.config.trayNotification()) {
                    this.notifier.notify(feedItem.content, TrayIcon.MessageType.INFO);
                }
            }
            if (feedItem.getType() == FeedItemType.WILDY_BOSS && this.config.includeWildySpawns()) {
                if (this.config.notificationSounds()) {
                    Toolkit.getDefaultToolkit().beep();
                }
                if (this.config.trayNotification()) {
                    this.notifier.notify(feedItem.content, TrayIcon.MessageType.INFO);
                }
            }
            if (feedItem.getType() == FeedItemType.HESPORI_BOSS && this.config.includeHesporiSpawns()) {
                if (this.config.notificationSounds()) {
                    Toolkit.getDefaultToolkit().beep();
                }
                if (this.config.trayNotification()) {
                    this.notifier.notify(feedItem.content, TrayIcon.MessageType.INFO);
                }
            }
            if (feedItem.getType() == FeedItemType.SHOOTING_STAR && this.config.includeStarSpawns()) {
                if (this.config.notificationSounds()) {
                    Toolkit.getDefaultToolkit().beep();
                }
                if (this.config.trayNotification()) {
                    this.notifier.notify(feedItem.content, TrayIcon.MessageType.INFO);
                }
            }
            if (feedItem.getType() == FeedItemType.SEASONAL && this.config.includeSeasonalSpawns()) {
                if (this.config.notificationSounds()) {
                    Toolkit.getDefaultToolkit().beep();
                }
                if (this.config.trayNotification()) {
                    this.notifier.notify(feedItem.content, TrayIcon.MessageType.INFO);
                }
            }
        });
        this.rebuildFeed();
    }

    private void reDrawFeed() {
        for (Component component : this.getComponents()) {
            Container parent = component.getParent();
            if (parent == null) continue;
            parent.remove(component);
            parent.revalidate();
            parent.repaint();
        }
    }

    static {
        TWEET_BACKGROUND = new Color(15, 15, 15);
        OSRS_NEWS_BACKGROUND = new Color(36, 30, 19);
        BLOG_POST_BACKGROUND = new Color(41, 11, 11);
        currentFeedItems = new ArrayList<FeedItem>();
        FEED_ITEM_COMPARATOR = (o1, o2) -> -Long.compare(o1.getTimestamp(), o2.getTimestamp());
        RUNELITE_ICON = new ImageIcon(ImageUtil.loadImageResource(FeedPanel.class, "runelite.png"));
        OSRS_ICON = new ImageIcon(ImageUtil.loadImageResource(FeedPanel.class, "osrs.png"));
        currentFeedItems.add(new FeedItem(FeedItemType.GROOT, null, "Groot Spawned", ";;groot to kill them", "https://discord.gg/BRcRaVVX", System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L)));
        currentFeedItems.add(new FeedItem(FeedItemType.DONOR_BOSS, null, "Donor Boss Spawend", ";;db to kill them", "https://discord.gg/BRcRaVVX", System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L)));
        currentFeedItems.add(new FeedItem(FeedItemType.SHOOTING_STAR, null, "Shooting Star Spawend", ";;star to get to the star", "https://discord.gg/BRcRaVVX", System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L)));
        currentFeedItems.add(new FeedItem(FeedItemType.VOTE_BOSS, null, "Vote Boss Spawend", ";;vb to kill them", "https://discord.gg/BRcRaVVX", System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L)));
        currentFeedItems.add(new FeedItem(FeedItemType.SEASONAL, null, "Seasonal event has spawned", ";;seasonal to get there", "https://discord.gg/BRcRaVVX", System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L)));
        currentFeedItems.add(new FeedItem(FeedItemType.WILDY_BOSS, null, "Wildy event is active", ";;wildyevent to get there", "https://discord.gg/BRcRaVVX", System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L)));
        currentFeedItems.add(new FeedItem(FeedItemType.HESPORI_BOSS, null, "Hespori is active", ";;worldevent to get there.", "https://discord.gg/BRcRaVVX", System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L)));
    }
}

