/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.grounditems;

import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.MouseAdapter;
import net.runelite.client.plugins.grounditems.GroundItemsConfig;
import net.runelite.client.plugins.grounditems.GroundItemsPlugin;

public class GroundItemInputListener
extends MouseAdapter
implements KeyListener {
    private static final int HOTKEY = 18;
    private Instant lastPress;
    @Inject
    private GroundItemsPlugin plugin;
    @Inject
    private GroundItemsConfig config;

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 18) {
            if (this.plugin.isHideAll()) {
                this.plugin.setHideAll(false);
                this.plugin.setHotKeyPressed(true);
                this.lastPress = null;
            } else if (this.lastPress != null && !this.plugin.isHotKeyPressed() && this.config.doubleTapDelay() > 0 && Duration.between(this.lastPress, Instant.now()).compareTo(Duration.ofMillis(this.config.doubleTapDelay())) < 0) {
                this.plugin.setHideAll(true);
                this.lastPress = null;
            } else {
                this.plugin.setHotKeyPressed(true);
                this.lastPress = Instant.now();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 18) {
            this.plugin.setHotKeyPressed(false);
            this.plugin.setTextBoxBounds(null);
            this.plugin.setHiddenBoxBounds(null);
            this.plugin.setHighlightBoxBounds(null);
        }
    }

    @Override
    public MouseEvent mousePressed(MouseEvent e) {
        Point mousePos = e.getPoint();
        if (this.plugin.isHotKeyPressed()) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                if (this.plugin.getHiddenBoxBounds() != null && this.plugin.getHiddenBoxBounds().getKey().contains(mousePos)) {
                    this.plugin.updateList(this.plugin.getHiddenBoxBounds().getValue().getName(), true);
                    e.consume();
                    return e;
                }
                if (this.plugin.getHighlightBoxBounds() != null && this.plugin.getHighlightBoxBounds().getKey().contains(mousePos)) {
                    this.plugin.updateList(this.plugin.getHighlightBoxBounds().getValue().getName(), false);
                    e.consume();
                    return e;
                }
                if (this.plugin.getTextBoxBounds() != null && this.plugin.getTextBoxBounds().getKey().contains(mousePos)) {
                    this.plugin.updateList(this.plugin.getTextBoxBounds().getValue().getName(), false);
                    e.consume();
                    return e;
                }
            } else if (SwingUtilities.isRightMouseButton(e) && this.plugin.getTextBoxBounds() != null && this.plugin.getTextBoxBounds().getKey().contains(mousePos)) {
                this.plugin.updateList(this.plugin.getTextBoxBounds().getValue().getName(), true);
                e.consume();
                return e;
            }
        }
        return e;
    }
}

