/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.scene;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.runelite.api.Scene;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.hd.data.environments.Environment;
import net.runelite.client.plugins.hd.data.materials.Material;
import net.runelite.client.plugins.hd.scene.lights.SceneLight;
import net.runelite.client.plugins.hd.utils.HDUtils;
import net.runelite.client.plugins.hd.utils.buffer.GpuFloatBuffer;
import net.runelite.client.plugins.hd.utils.buffer.GpuIntBuffer;

public class SceneContext {
    public final int id = HDUtils.rand.nextInt();
    public final Scene scene;
    public final HashSet<Integer> regionIds;
    public GpuIntBuffer stagingBufferVertices;
    public GpuFloatBuffer stagingBufferUvs;
    public GpuFloatBuffer stagingBufferNormals;
    public Map<Integer, Integer> vertexTerrainColor;
    public Map<Integer, Material> vertexTerrainTexture;
    public Map<Integer, float[]> vertexTerrainNormals;
    public HashMap<Integer, Boolean> highPriorityColor;
    public boolean[][][] tileIsWater;
    public Map<Integer, Boolean> vertexIsWater;
    public Map<Integer, Boolean> vertexIsLand;
    public Map<Integer, Boolean> vertexIsOverlay;
    public Map<Integer, Boolean> vertexIsUnderlay;
    public boolean[][][] skipTile;
    public Map<Integer, Integer> vertexUnderwaterDepth;
    public int[][][] underwaterDepthLevels;
    public final ArrayList<SceneLight> lights = new ArrayList();
    public int visibleLightCount = 0;
    public final ArrayList<Environment> environments = new ArrayList();
    public final int[] modelFaceVertices = new int[12];
    public final float[] modelFaceNormals = new float[12];
    public final int[] modelPusherResults = new int[2];

    public SceneContext(Scene scene, @Nullable SceneContext previousSceneContext) {
        this.scene = scene;
        this.regionIds = HDUtils.getSceneRegionIds(scene);
        if (previousSceneContext == null) {
            this.stagingBufferVertices = new GpuIntBuffer();
            this.stagingBufferUvs = new GpuFloatBuffer();
            this.stagingBufferNormals = new GpuFloatBuffer();
        } else {
            this.stagingBufferVertices = new GpuIntBuffer(previousSceneContext.stagingBufferVertices.getBuffer().capacity());
            this.stagingBufferUvs = new GpuFloatBuffer(previousSceneContext.stagingBufferUvs.getBuffer().capacity());
            this.stagingBufferNormals = new GpuFloatBuffer(previousSceneContext.stagingBufferNormals.getBuffer().capacity());
        }
    }

    public void destroy() {
        if (this.stagingBufferVertices != null) {
            this.stagingBufferVertices.destroy();
        }
        this.stagingBufferVertices = null;
        if (this.stagingBufferUvs != null) {
            this.stagingBufferUvs.destroy();
        }
        this.stagingBufferUvs = null;
        if (this.stagingBufferNormals != null) {
            this.stagingBufferNormals.destroy();
        }
        this.stagingBufferNormals = null;
    }

    public int getVertexOffset() {
        return this.stagingBufferVertices.position() / 4;
    }

    public int getUvOffset() {
        return this.stagingBufferUvs.position() / 4;
    }

    public WorldPoint localToWorld(LocalPoint localPoint, int plane) {
        if (this.scene.isInstance() && !localPoint.isInScene()) {
            return WorldPoint.fromLocal(this.scene, localPoint.getX(), localPoint.getY(), plane);
        }
        return WorldPoint.fromLocalInstance(this.scene, localPoint, plane);
    }

    public Collection<LocalPoint> worldInstanceToLocals(WorldPoint worldPoint) {
        return WorldPoint.toLocalInstance(this.scene, worldPoint).stream().map(this::worldToLocal).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public LocalPoint worldToLocal(WorldPoint worldPoint) {
        LocalPoint localPoint = new LocalPoint((worldPoint.getX() - this.scene.getBaseX()) * 128, (worldPoint.getY() - this.scene.getBaseY()) * 128);
        if (!localPoint.isInScene()) {
            return null;
        }
        return localPoint;
    }
}

