/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.utils;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.awt.Color;
import java.io.IOException;
import java.util.Arrays;
import net.runelite.client.plugins.hd.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorUtils {
    private static final float EPS = 1.0E-10f;
    private static final float[] RGB_TO_XYZ_MATRIX = new float[]{0.49f, 0.31f, 0.2f, 0.1769f, 0.8124f, 0.0107f, 0.0f, 0.0099f, 0.9901f};
    private static final float[] XYZ_TO_RGB_MATRIX = new float[]{2.36449f, -0.896553f, -0.467937f, -0.514935f, 1.42633f, 0.0886025f, 0.00514883f, -0.0142619f, 1.00911f};

    public static float[] colorTemperatureToLinearRgb(double kelvin) {
        double[] uv = new double[]{(0.860117757 + 1.54118254E-4 * kelvin + 1.28641212E-7 * kelvin * kelvin) / (1.0 + 8.42420235E-4 * kelvin + 7.08145163E-7 * kelvin * kelvin), (0.317398726 + 4.22806245E-5 * kelvin + 4.20481691E-8 * kelvin * kelvin) / (1.0 - 2.89741816E-5 * kelvin + 1.61456053E-7 * kelvin * kelvin)};
        double divisor = 2.0 * uv[0] - 8.0 * uv[1] + 4.0;
        double[] xy = new double[]{3.0 * uv[0] / divisor, 2.0 * uv[1] / divisor};
        float Y = 1.0f;
        float[] XYZ = new float[]{(float)(xy[0] * (double)Y / xy[1]), Y, (float)((1.0 - xy[0] - xy[1]) * (double)Y / xy[1])};
        return ColorUtils.XYZtoRGB(XYZ);
    }

    public static float[] XYZtoRGB(float[] XYZ) {
        float[] RGB = new float[3];
        ColorUtils.mat3MulVec3(RGB, XYZ_TO_RGB_MATRIX, XYZ);
        return RGB;
    }

    public static float[] RGBtoXYZ(float[] RGB) {
        float[] XYZ = new float[3];
        ColorUtils.mat3MulVec3(XYZ, RGB_TO_XYZ_MATRIX, RGB);
        return XYZ;
    }

    private static void mat3MulVec3(float[] out, float[] m3, float[] v) {
        out[0] = m3[0] * v[0] + m3[1] * v[1] + m3[2] * v[2];
        out[1] = m3[3] * v[0] + m3[4] * v[1] + m3[5] * v[2];
        out[2] = m3[6] * v[0] + m3[7] * v[1] + m3[8] * v[2];
    }

    public static float linearToSrgb(float c) {
        return (double)c <= 0.0031308 ? c * 12.92f : (float)(1.055 * Math.pow(c, 0.4166666666666667) - 0.055);
    }

    public static float srgbToLinear(float c) {
        return c <= 0.04045f ? c / 12.92f : (float)Math.pow(((double)c + 0.055) / 1.055, 2.4);
    }

    public static float[] linearToSrgb(float ... c) {
        float[] result2 = new float[c.length];
        for (int i = 0; i < c.length; ++i) {
            result2[i] = ColorUtils.linearToSrgb(c[i]);
        }
        return result2;
    }

    public static float[] srgbToLinear(float ... c) {
        float[] result2 = new float[c.length];
        for (int i = 0; i < c.length; ++i) {
            result2[i] = ColorUtils.srgbToLinear(c[i]);
        }
        return result2;
    }

    private static float mod(float x, float modulus) {
        return (float)((double)x - Math.floor(x / modulus) * (double)modulus);
    }

    private static float clamp(float value, float min2, float max) {
        return Math.min(Math.max(value, min2), max);
    }

    private static int clamp(int value, int min2, int max) {
        return Math.min(Math.max(value, min2), max);
    }

    public static float[] srgbToHsl(float[] srgb) {
        float L;
        float divisor;
        float V = Math.max(Math.max(srgb[0], srgb[1]), srgb[2]);
        float X_min = Math.min(Math.min(srgb[0], srgb[1]), srgb[2]);
        float C2 = V - X_min;
        float H = 0.0f;
        if (C2 > 0.0f) {
            H = V == srgb[0] ? ColorUtils.mod((srgb[1] - srgb[2]) / C2, 6.0f) : (V == srgb[1] ? (srgb[2] - srgb[0]) / C2 + 2.0f : (srgb[0] - srgb[1]) / C2 + 4.0f);
            assert (H >= 0.0f && H <= 6.0f);
        }
        float S_L = Math.abs(divisor = 1.0f - Math.abs(2.0f * (L = (V + X_min) / 2.0f) - 1.0f)) < 1.0E-10f ? 0.0f : C2 / divisor;
        return new float[]{H / 6.0f, S_L, L};
    }

    public static float[] hslToSrgb(float[] hsl) {
        float C2 = hsl[1] * (1.0f - Math.abs(2.0f * hsl[2] - 1.0f));
        float H_prime = hsl[0] * 6.0f;
        float m3 = hsl[2] - C2 / 2.0f;
        float r = ColorUtils.clamp(Math.abs(H_prime - 3.0f) - 1.0f, 0.0f, 1.0f) * C2 + m3;
        float g2 = ColorUtils.clamp(2.0f - Math.abs(H_prime - 2.0f), 0.0f, 1.0f) * C2 + m3;
        float b = ColorUtils.clamp(2.0f - Math.abs(H_prime - 4.0f), 0.0f, 1.0f) * C2 + m3;
        return new float[]{r, g2, b};
    }

    public static float[] hslToHsv(float[] hsl) {
        float v = hsl[2] + hsl[1] * Math.min(hsl[2], 1.0f - hsl[2]);
        return new float[]{hsl[0], Math.abs(v) < 1.0E-10f ? 0.0f : 2.0f * (1.0f - hsl[2] / v), v};
    }

    public static float[] hsvToHsl(float[] hsv) {
        float l = hsv[2] * (1.0f - hsv[1] / 2.0f);
        float divisor = Math.min(l, 1.0f - l);
        return new float[]{hsv[0], Math.abs(divisor) < 1.0E-10f ? 0.0f : (hsv[2] - l) / divisor, l};
    }

    public static float[] srgbToHsv(float[] srgb) {
        return ColorUtils.hslToHsv(ColorUtils.srgbToHsl(srgb));
    }

    public static float[] hsvToSrgb(float[] hsv) {
        return ColorUtils.hslToSrgb(ColorUtils.hsvToHsl(hsv));
    }

    public static float[] rgb(float r, float g2, float b) {
        return ColorUtils.srgbToLinear(ColorUtils.srgb(r, g2, b));
    }

    public static float[] rgb(String hex) {
        return ColorUtils.srgbToLinear(ColorUtils.srgb(hex));
    }

    public static float[] rgb(int srgb) {
        return ColorUtils.srgbToLinear(ColorUtils.srgb(srgb));
    }

    public static float[] srgb(float r, float g2, float b) {
        return new float[]{r / 255.0f, g2 / 255.0f, b / 255.0f};
    }

    public static float[] srgb(String hex) {
        Color color = Color.decode(hex);
        return ColorUtils.srgb(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static float[] srgb(int srgb) {
        return new float[]{(float)(srgb >> 16 & 0xFF) / 255.0f, (float)(srgb >> 8 & 0xFF) / 255.0f, (float)(srgb & 0xFF) / 255.0f};
    }

    public static float[] srgba(int alphaSrgb) {
        return new float[]{(float)(alphaSrgb >> 16 & 0xFF) / 255.0f, (float)(alphaSrgb >> 8 & 0xFF) / 255.0f, (float)(alphaSrgb & 0xFF) / 255.0f, (float)(alphaSrgb >> 24 & 0xFF) / 255.0f};
    }

    public static int hsl(float r, float g2, float b) {
        return ColorUtils.srgbToPackedHsl(ColorUtils.srgb(r, g2, b));
    }

    public static int hsl(String rgbHex) {
        return ColorUtils.srgbToPackedHsl(ColorUtils.srgb(rgbHex));
    }

    public static int hsl(int packedSrgb) {
        return ColorUtils.srgbToPackedHsl(ColorUtils.srgb(packedSrgb));
    }

    public static int packRawRgb(int ... rgb) {
        return rgb[0] << 16 | rgb[1] << 8 | rgb[2];
    }

    public static int packSrgb(float[] srgb) {
        int[] ints = new int[3];
        for (int i = 0; i < 3; ++i) {
            ints[i] = ColorUtils.clamp(Math.round(srgb[i] * 255.0f), 0, 255);
        }
        return ColorUtils.packRawRgb(ints);
    }

    public static int packRawHsl(int ... hsl) {
        return hsl[0] << 10 | hsl[1] << 7 | hsl[2];
    }

    public static void unpackRawHsl(int[] out, int hsl) {
        out[0] = hsl >>> 10 & 0x3F;
        out[1] = hsl >>> 7 & 7;
        out[2] = hsl & 0x7F;
    }

    public static int[] unpackRawHsl(int hsl) {
        int[] out = new int[3];
        ColorUtils.unpackRawHsl(out, hsl);
        return out;
    }

    public static int packHsl(float ... hsl) {
        int H = ColorUtils.clamp(Math.round((hsl[0] - 0.0078125f) * 64.0f), 0, 63);
        int S = ColorUtils.clamp(Math.round((hsl[1] - 0.0625f) * 8.0f), 0, 7);
        int L = ColorUtils.clamp(Math.round(hsl[2] * 128.0f), 0, 127);
        return ColorUtils.packRawHsl(H, S, L);
    }

    public static float[] unpackHsl(int hsl) {
        float H = (float)(hsl >>> 10 & 0x3F) / 64.0f + 0.0078125f;
        float S = (float)(hsl >>> 7 & 7) / 8.0f + 0.0625f;
        float L = (float)(hsl & 0x7F) / 128.0f;
        return new float[]{H, S, L};
    }

    public static int srgbToPackedHsl(float[] srgb) {
        return ColorUtils.packHsl(ColorUtils.srgbToHsl(srgb));
    }

    public static float[] packedHslToSrgb(int packedHsl) {
        return ColorUtils.hslToSrgb(ColorUtils.unpackHsl(packedHsl));
    }

    public static int linearRgbToPackedHsl(float[] linearRgb) {
        return ColorUtils.srgbToPackedHsl(ColorUtils.linearToSrgb(linearRgb));
    }

    public static float[] packedHslToLinearRgb(int hsl) {
        return ColorUtils.srgbToLinear(ColorUtils.packedHslToSrgb(hsl));
    }

    public static String srgbToHex(float ... srgb) {
        return String.format("#%h", ColorUtils.packSrgb(srgb));
    }

    public static String rgbToHex(float ... linearRgb) {
        return ColorUtils.srgbToHex(ColorUtils.linearToSrgb(linearRgb));
    }

    public static class SrgbToLinearAdapter
    extends SrgbAdapter {
        private static final Logger log = LoggerFactory.getLogger(SrgbToLinearAdapter.class);

        @Override
        public float[] read(JsonReader in) throws IOException {
            return ColorUtils.srgbToLinear(super.read(in));
        }

        @Override
        public void write(JsonWriter out, float[] src) throws IOException {
            super.write(out, ColorUtils.linearToSrgb(src));
        }
    }

    public static class SrgbAdapter
    extends TypeAdapter<float[]> {
        private static final Logger log = LoggerFactory.getLogger(SrgbAdapter.class);
        private final float[] rgba = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        private final int[] rgbaInt = new int[]{0, 0, 0, 255};

        @Override
        public float[] read(JsonReader in) throws IOException {
            JsonToken token = in.peek();
            if (token == JsonToken.STRING) {
                return ColorUtils.srgb(in.nextString());
            }
            if (token != JsonToken.BEGIN_ARRAY) {
                throw new IOException("Expected hex color code or array of color channels at " + GsonUtils.location(in));
            }
            in.beginArray();
            int i = 0;
            while (in.hasNext() && in.peek() != JsonToken.END_ARRAY) {
                if (in.peek() == JsonToken.NULL) {
                    log.warn("Skipping null value in color array at {}", (Object)GsonUtils.location(in));
                    in.skipValue();
                    continue;
                }
                if (in.peek() == JsonToken.NUMBER) {
                    if (i > 3) {
                        log.warn("Skipping extra elements in color array at {}", (Object)GsonUtils.location(in));
                        break;
                    }
                    this.rgba[i++] = (float)in.nextDouble();
                    continue;
                }
                throw new IOException("Unexpected type in color array: " + String.valueOf((Object)in.peek()) + " at " + GsonUtils.location(in));
            }
            in.endArray();
            if (i < 3) {
                throw new IOException("Too few elements in color array: " + i + " at " + GsonUtils.location(in));
            }
            int j = 0;
            while (j < i) {
                int n = j++;
                this.rgba[n] = this.rgba[n] / 255.0f;
            }
            if (i == 4) {
                return this.rgba;
            }
            float[] rgb = new float[3];
            System.arraycopy(this.rgba, 0, rgb, 0, 3);
            return rgb;
        }

        @Override
        public void write(JsonWriter out, float[] src) throws IOException {
            int i;
            if (src == null || src.length == 0) {
                out.nullValue();
                return;
            }
            if (src.length != 3 && src.length != 4) {
                throw new IOException("The number of components must be 3 or 4 in a color array. Got " + Arrays.toString(src));
            }
            for (int i2 = 0; i2 < src.length; ++i2) {
                this.rgba[i2] = src[i2] * 255.0f;
            }
            boolean canfit = true;
            for (i = 0; i < src.length; ++i) {
                float f = this.rgba[i];
                this.rgbaInt[i] = Math.round(f);
                if (!(Math.abs(f - (float)this.rgbaInt[i]) > 1.0E-10f)) continue;
                canfit = false;
                break;
            }
            if (canfit) {
                if (src.length == 3) {
                    out.value(String.format("#%02x%02x%02x", this.rgbaInt[0], this.rgbaInt[1], this.rgbaInt[2]));
                } else {
                    out.value(String.format("#%02x%02x%02x%02x", this.rgbaInt[0], this.rgbaInt[1], this.rgbaInt[2], this.rgbaInt[3]));
                }
            } else {
                out.beginArray();
                for (i = 0; i < src.length; ++i) {
                    out.value(this.rgba[i]);
                }
                out.endArray();
            }
        }
    }
}

