/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.utils;

import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.runelite.client.plugins.hd.utils.ResourcePath;

public class Props {
    public static boolean DEVELOPMENT;
    private static final Properties env;

    public static boolean has(String variableName) {
        return env.containsKey(variableName);
    }

    public static boolean missing(String variableName) {
        return !Props.has(variableName);
    }

    public static String get(String variableName) {
        return env.getProperty(variableName);
    }

    public static String getOrDefault(String variableName, String defaultValue) {
        String value = Props.get(variableName);
        return value == null ? defaultValue : value;
    }

    public static String getOrDefault(String variableName, Supplier<String> defaultValueSupplier) {
        String value = Props.get(variableName);
        return value == null ? defaultValueSupplier.get() : value;
    }

    @Nullable
    public static Boolean getBoolean(String variableName) {
        String value = Props.get(variableName);
        if (value == null) {
            return null;
        }
        return (value = value.toLowerCase()).equals("true") || value.equals("1") || value.equals("on") || value.equals("yes");
    }

    public static boolean getBooleanOrDefault(String variableName, boolean defaultValue) {
        Boolean value = Props.getBoolean(variableName);
        return value == null ? defaultValue : value;
    }

    public static ResourcePath getPathOrDefault(String variableName, Supplier<ResourcePath> fallback) {
        String path = Props.get(variableName);
        if (path == null) {
            return fallback.get();
        }
        return ResourcePath.path(path);
    }

    public static void set(String variableName, boolean value) {
        Props.set(variableName, value ? "true" : "false");
    }

    public static void set(String variableName, Path value) {
        Props.set(variableName, value.toAbsolutePath().toString());
    }

    public static void set(String variableName, String value) {
        if (value == null) {
            Props.unset(variableName);
        } else {
            env.put(variableName, value);
        }
    }

    public static void unset(String variableName) {
        env.remove(variableName);
    }

    static {
        env = new Properties();
        env.putAll((Map<?, ?>)System.getProperties());
    }
}

