/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.inventorytags;

import com.google.gson.Gson;
import com.google.inject.Provides;
import java.applet.Applet;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.inventorytags.InventoryTagsConfig;
import net.runelite.client.plugins.inventorytags.InventoryTagsOverlay;
import net.runelite.client.plugins.inventorytags.Tag;
import net.runelite.client.ui.components.colorpicker.ColorPickerManager;
import net.runelite.client.ui.components.colorpicker.RuneliteColorPicker;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Inventory Tags", description="Add the ability to tag items in your inventory", tags={"highlight", "items", "overlay", "tagging"}, enabledByDefault=false)
public class InventoryTagsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(InventoryTagsPlugin.class);
    private static final String ITEM_KEY_PREFIX = "item_";
    private static final String TAG_KEY_PREFIX = "tag_";
    @Inject
    private Client client;
    @Inject
    private ConfigManager configManager;
    @Inject
    private InventoryTagsOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Gson gson;
    @Inject
    private ColorPickerManager colorPickerManager;

    @Provides
    InventoryTagsConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(InventoryTagsConfig.class);
    }

    @Override
    protected void startUp() {
        this.overlayManager.add(this.overlay);
        this.convertConfig();
    }

    @Override
    protected void shutDown() {
        this.overlayManager.remove(this.overlay);
    }

    Tag getTag(int itemId) {
        String tag = this.configManager.getConfiguration("inventorytags", TAG_KEY_PREFIX + itemId);
        if (tag == null || tag.isEmpty()) {
            return null;
        }
        return this.gson.fromJson(tag, Tag.class);
    }

    void setTag(int itemId, Tag tag) {
        String json = this.gson.toJson(tag);
        this.configManager.setConfiguration("inventorytags", TAG_KEY_PREFIX + itemId, json);
    }

    void unsetTag(int itemId) {
        this.configManager.unsetConfiguration("inventorytags", TAG_KEY_PREFIX + itemId);
    }

    private void convertConfig() {
        String migrated = this.configManager.getConfiguration("inventorytags", "migrated");
        if (!"1".equals(migrated)) {
            return;
        }
        int removed = 0;
        List<String> keys2 = this.configManager.getConfigurationKeys("inventorytags.item_");
        for (String key : keys2) {
            String[] str = key.split("\\.", 2);
            if (str.length != 2) continue;
            this.configManager.unsetConfiguration(str[0], str[1]);
            ++removed;
        }
        log.debug("Removed {} old tags", (Object)removed);
        this.configManager.setConfiguration("inventorytags", "migrated", "2");
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("inventorytags")) {
            this.overlay.invalidateCache();
        }
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        if (!this.client.isKeyPressed(81)) {
            return;
        }
        MenuEntry[] entries2 = event.getMenuEntries();
        for (int idx = entries2.length - 1; idx >= 0; --idx) {
            MenuEntry entry = entries2[idx];
            Widget w = entry.getWidget();
            if (w != null && WidgetInfo.TO_GROUP(w.getId()) == 3214) {
                System.out.println(entry.getOption() + " / " + entry.getIdentifier());
            }
            if (w == null || WidgetInfo.TO_GROUP(w.getId()) != 3214 || !"Examine".equals(entry.getOption())) continue;
            int itemId = w.getItemId();
            Tag tag = this.getTag(itemId);
            MenuEntry parent = this.client.createMenuEntry(idx).setOption("Inventory tag").setTarget(entry.getTarget()).setType(MenuAction.RUNELITE_SUBMENU);
            for (Color color : this.invColors()) {
                if (tag != null && tag.color.equals(color)) continue;
                this.client.createMenuEntry(idx).setOption(ColorUtil.prependColorTag("Color", color)).setType(MenuAction.RUNELITE).setParent(parent).onClick(e -> {
                    Tag t = new Tag();
                    t.color = color;
                    this.setTag(itemId, t);
                });
            }
            this.client.createMenuEntry(idx).setOption("Pick").setType(MenuAction.RUNELITE).setParent(parent).onClick(e -> {
                Color color = tag == null ? Color.WHITE : tag.color;
                SwingUtilities.invokeLater(() -> {
                    RuneliteColorPicker colorPicker = this.colorPickerManager.create(SwingUtilities.windowForComponent((Applet)((Object)this.client)), color, "Inventory Tag", true);
                    colorPicker.setOnClose(c -> {
                        Tag t = new Tag();
                        t.color = c;
                        this.setTag(itemId, t);
                    });
                    colorPicker.setVisible(true);
                });
            });
            if (tag == null) continue;
            this.client.createMenuEntry(idx).setOption("Reset").setType(MenuAction.RUNELITE).setParent(parent).onClick(e -> this.unsetTag(itemId));
        }
    }

    private List<Color> invColors() {
        ArrayList<Color> colors = new ArrayList<Color>();
        ItemContainer container = this.client.getItemContainer(InventoryID.INVENTORY);
        for (Item item : container.getItems()) {
            Tag tag = this.getTag(item.getId());
            if (tag == null || tag.color == null || colors.contains(tag.color)) continue;
            colors.add(tag.color);
        }
        return colors;
    }
}

