/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.itemidentification;

import com.google.inject.Inject;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.itemidentification.ItemIdentification;
import net.runelite.client.plugins.itemidentification.ItemIdentificationConfig;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.components.TextComponent;

class ItemIdentificationOverlay
extends WidgetItemOverlay {
    private final ItemIdentificationConfig config;
    private final ItemManager itemManager;

    @Inject
    ItemIdentificationOverlay(ItemIdentificationConfig config, ItemManager itemManager) {
        this.config = config;
        this.itemManager = itemManager;
        this.showOnInventory();
        this.showOnBank();
        this.showOnInterfaces(100098, 100099, 100090, 100106, 100065);
    }

    @Override
    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem widgetItem) {
        ItemIdentification iden = this.findItemIdentification(itemId);
        if (iden == null || !iden.type.enabled.test(this.config)) {
            return;
        }
        if (!this.config.showBars() && iden.type == ItemIdentification.Type.BAR || !this.config.showAllotmentSeeds() && iden.type == ItemIdentification.Type.SEED_ALLOTMENT || !this.config.showHerbSeeds() && iden.type == ItemIdentification.Type.SEED_HERB || !this.config.showBerrySeeds() && iden.type == ItemIdentification.Type.SEED_BERRY || !this.config.showSpecialSeeds() && iden.type == ItemIdentification.Type.SEED_SPECIAL || !this.config.showTreeSeeds() && iden.type == ItemIdentification.Type.SEED_TREE || !this.config.showFruitTreeSeeds() && iden.type == ItemIdentification.Type.SEED_FRUIT_TREE || !this.config.showFlowerSeeds() && iden.type == ItemIdentification.Type.SEED_FLOWER || !this.config.showHopsSeeds() && iden.type == ItemIdentification.Type.HOPS_SEED || !this.config.showSacks() && iden.type == ItemIdentification.Type.SACK || !this.config.showHerbs() && iden.type == ItemIdentification.Type.HERB || !this.config.showLogs() && iden.type == ItemIdentification.Type.LOGS || !this.config.showPyreLogs() && iden.type == ItemIdentification.Type.LOGS_PYRE || !this.config.showPlanks() && iden.type == ItemIdentification.Type.PLANK || !this.config.showSaplings() && iden.type == ItemIdentification.Type.SAPLING || !this.config.showComposts() && iden.type == ItemIdentification.Type.COMPOST || !this.config.showOres() && iden.type == ItemIdentification.Type.ORE || !this.config.showGems() && iden.type == ItemIdentification.Type.GEM || !this.config.showPotions() && iden.type == ItemIdentification.Type.POTION || !this.config.showImplingJars() && iden.type == ItemIdentification.Type.IMPLING_JAR || !this.config.showTablets() && iden.type == ItemIdentification.Type.TABLET || !this.config.showTeleportScrolls() && iden.type == ItemIdentification.Type.SCROLL || !this.config.showJewellery() && iden.type == ItemIdentification.Type.JEWELLERY || !this.config.showEnchantedJewellery() && iden.type == ItemIdentification.Type.JEWELLERY_ENCHANTED) {
            return;
        }
        graphics.setFont(FontManager.getRunescapeSmallFont());
        this.renderText(graphics, widgetItem.getCanvasBounds(), iden);
    }

    private void renderText(Graphics2D graphics, Rectangle bounds, ItemIdentification iden) {
        TextComponent textComponent = new TextComponent();
        textComponent.setPosition(new Point(bounds.x - 1, bounds.y + bounds.height - 1));
        textComponent.setColor(this.config.textColor());
        switch (this.config.identificationType()) {
            case SHORT: {
                textComponent.setText(iden.shortName);
                break;
            }
            case MEDIUM: {
                textComponent.setText(iden.medName);
            }
        }
        textComponent.render(graphics);
    }

    private ItemIdentification findItemIdentification(int itemID) {
        return ItemIdentification.get(itemID);
    }
}

