/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.resourcepacks;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.gson.stream.JsonReader;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.SpritePixels;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.resourcepacks.ResourcePacksConfig;
import net.runelite.client.plugins.resourcepacks.ResourcePacksPlugin;
import net.runelite.client.plugins.resourcepacks.SpriteOverride;
import net.runelite.client.plugins.resourcepacks.WidgetOverride;
import net.runelite.client.plugins.resourcepacks.WidgetResize;
import net.runelite.client.plugins.resourcepacks.event.ResourcePacksChanged;
import net.runelite.client.plugins.resourcepacks.hub.ResourcePackManifest;
import net.runelite.client.plugins.resourcepacks.hub.ResourcePacksClient;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ResourcePacksManager {
    private static final Logger log = LoggerFactory.getLogger(ResourcePacksManager.class);
    private final Properties colorProperties = new Properties();
    private SpritePixels[] defaultCrossSprites;
    @Inject
    private Client client;
    @Inject
    private ResourcePacksConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private ResourcePacksClient resourcePacksClient;
    @Inject
    private ClientThread clientThread;
    @Inject
    private EventBus eventBus;

    public void refreshPlugins() {
        List<ResourcePackManifest> manifestList;
        List<String> installedIDs;
        HashMap<String, ResourcePackManifest> loadedPacks = new HashMap<String, ResourcePackManifest>();
        File[] resourcePackDirectories = ResourcePacksPlugin.RESOURCEPACKS_DIR.listFiles();
        if (resourcePackDirectories != null) {
            for (File resourcePackDirectory : resourcePackDirectories) {
                if (!resourcePackDirectory.isDirectory()) continue;
                try {
                    ResourcePackManifest man = this.getResourcePackManifest(resourcePackDirectory);
                    if (man == null) continue;
                    loadedPacks.put(man.getInternalName(), man);
                }
                catch (IOException man) {
                    // empty catch block
                }
            }
        }
        if ((installedIDs = this.getInstalledResourcePacks()).isEmpty() && loadedPacks.isEmpty()) {
            return;
        }
        HashSet<ResourcePackManifest> resourcePacks = new HashSet<ResourcePackManifest>();
        try {
            manifestList = this.resourcePacksClient.downloadManifest();
            Map manifests = manifestList.stream().collect(ImmutableMap.toImmutableMap(ResourcePackManifest::getInternalName, Function.identity()));
            HashSet<ResourcePackManifest> needsDownload = new HashSet<ResourcePackManifest>();
            HashSet<File> keep = new HashSet<File>();
            assert (resourcePackDirectories != null);
            List<File> resourcePackDirectoryList = Arrays.asList(resourcePackDirectories);
            for (String name : installedIDs) {
                ResourcePackManifest manifest = (ResourcePackManifest)manifests.get(name);
                if (manifest == null) continue;
                resourcePacks.add(manifest);
                ResourcePackManifest loadedResourcePack = (ResourcePackManifest)loadedPacks.get(manifest.getInternalName());
                File resourcePackDirectory = new File(String.valueOf(ResourcePacksPlugin.RESOURCEPACKS_DIR.toPath()) + File.separator + manifest.getInternalName());
                if (loadedResourcePack == null || !loadedResourcePack.equals(manifest)) {
                    needsDownload.add(manifest);
                    continue;
                }
                if (!loadedResourcePack.getCommit().equals(manifest.getCommit()) || !resourcePackDirectoryList.contains(resourcePackDirectory)) continue;
                keep.add(resourcePackDirectory);
            }
            for (File fi : resourcePackDirectoryList) {
                if (keep.contains(fi) || fi.getPath().equals(ResourcePacksPlugin.NOTICE_FILE.getPath())) continue;
                MoreFiles.deleteRecursively(fi.toPath(), RecursiveDeleteOption.ALLOW_INSECURE);
            }
            for (ResourcePackManifest manifest : needsDownload) {
                HttpUrl url = ResourcePacksPlugin.GITHUB.newBuilder().addPathSegment("archive").addPathSegment(manifest.getCommit() + ".zip").build();
                try {
                    Response res = RuneLiteAPI.CLIENT.newCall(new Request.Builder().url(url).build()).execute();
                    try {
                        ZipEntry entry;
                        BufferedInputStream is = new BufferedInputStream(res.body().byteStream());
                        ZipInputStream zipInputStream = new ZipInputStream(is);
                        while ((entry = zipInputStream.getNextEntry()) != null) {
                            String filePath = ResourcePacksPlugin.RESOURCEPACKS_DIR.getPath() + File.separator + entry.getName().replaceAll("resource-packs-" + manifest.getCommit(), manifest.getInternalName());
                            if (!entry.isDirectory()) {
                                int read2;
                                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
                                byte[] bytesIn = new byte[2048];
                                while ((read2 = zipInputStream.read(bytesIn)) != -1) {
                                    bos.write(bytesIn, 0, read2);
                                }
                                bos.close();
                                continue;
                            }
                            File dir = new File(filePath);
                            dir.mkdir();
                        }
                        zipInputStream.close();
                        is.close();
                        File manifestFile = new File(ResourcePacksPlugin.RESOURCEPACKS_DIR.getPath() + File.separator + manifest.getInternalName() + File.separator + "manifest.js");
                        FileWriter manifestWriter = new FileWriter(manifestFile);
                        RuneLiteAPI.GSON.toJson((Object)manifest, (Appendable)manifestWriter);
                        manifestWriter.close();
                        if (!this.config.selectedHubPack().equals(manifest.getInternalName())) continue;
                        this.clientThread.invokeLater(this::updateAllOverrides);
                    }
                    finally {
                        if (res == null) continue;
                        res.close();
                    }
                }
                catch (IOException e) {
                    resourcePacks.remove(manifest);
                    log.error("Unable to download resource pack \"{}\"", (Object)manifest.getInternalName(), (Object)e);
                }
            }
        }
        catch (IOException e) {
            log.error("Unable to download resource packs", e);
            return;
        }
        for (ResourcePackManifest ex : resourcePacks) {
            loadedPacks.remove(ex.getInternalName());
        }
        Collection remove = loadedPacks.values();
        for (ResourcePackManifest rem : remove) {
            log.info("Removing pack \"{}\"", (Object)rem.getInternalName());
            HashSet<String> packs = new HashSet<String>(this.getInstalledResourcePacks());
            if (!packs.remove(rem.getInternalName())) continue;
            this.configManager.setConfiguration("resourcepacks", "hubPacks", Text.toCSV(packs));
        }
        this.eventBus.post(new ResourcePacksChanged(manifestList));
    }

    private ResourcePackManifest getResourcePackManifest(File resourcePackDirectory) throws IOException {
        File manifest = new File(resourcePackDirectory.getPath() + File.separator + "manifest.js");
        JsonReader reader = new JsonReader(new FileReader(manifest));
        ResourcePackManifest packManifest = (ResourcePackManifest)RuneLiteAPI.GSON.fromJson(reader, (Type)((Object)ResourcePackManifest.class));
        reader.close();
        return packManifest;
    }

    public HashMultimap<String, ResourcePackManifest> getCurrentManifests() throws IOException {
        HashMultimap<String, ResourcePackManifest> currentManifests = HashMultimap.create();
        File[] directories = ResourcePacksPlugin.RESOURCEPACKS_DIR.listFiles();
        if (directories != null) {
            for (File resourcePackDirectory : directories) {
                if (!resourcePackDirectory.isDirectory()) continue;
                ResourcePackManifest resourcePackManifest = this.getResourcePackManifest(resourcePackDirectory);
                currentManifests.put((Object)resourcePackManifest.getInternalName(), (Object)resourcePackManifest);
            }
        }
        return currentManifests;
    }

    public void setSelectedHubPack(String internalName) {
        if (!internalName.equals("None")) {
            this.configManager.setConfiguration("resourcepacks", "resourcePack", ResourcePacksConfig.ResourcePack.HUB);
            this.configManager.setConfiguration("resourcepacks", "selectedHubPack", internalName);
            this.clientThread.invokeLater(this::updateAllOverrides);
        } else {
            this.configManager.setConfiguration("resourcepacks", "selectedHubPack", "");
            this.clientThread.invokeLater(() -> {
                this.adjustWidgetDimensions(false);
                this.reloadColorProperties();
                this.resetLoginScreen();
                this.removeGameframe();
            });
        }
    }

    public List<String> getInstalledResourcePacks() {
        String resourcePacksString = this.configManager.getConfiguration("resourcepacks", "hubPacks");
        return Text.fromCSV(resourcePacksString == null ? "" : resourcePacksString);
    }

    public void install(String internalName) {
        HashSet<String> packs = new HashSet<String>(this.getInstalledResourcePacks());
        if (packs.add(internalName)) {
            log.debug("Installing: " + internalName);
            this.configManager.setConfiguration("resourcepacks", "hubPacks", Text.toCSV(packs));
            this.configManager.setConfiguration("resourcepacks", "resourcePack", ResourcePacksConfig.ResourcePack.HUB);
            this.executor.submit(() -> {
                this.refreshPlugins();
                this.setSelectedHubPack(internalName);
            });
        }
    }

    public void remove(String internalName) {
        HashSet<String> packs = new HashSet<String>(this.getInstalledResourcePacks());
        if (packs.remove(internalName)) {
            log.debug("Removing: " + internalName);
            this.configManager.setConfiguration("resourcepacks", "hubPacks", Text.toCSV(packs));
            if (this.config.selectedHubPack() != null && this.config.selectedHubPack().equals(internalName)) {
                this.setSelectedHubPack("None");
            }
            this.executor.submit(this::refreshPlugins);
        }
    }

    void updateAllOverrides() {
        if (!this.checkIfResourcePackPathIsNotEmpty()) {
            return;
        }
        this.removeGameframe();
        this.overrideSprites();
        this.reloadColorProperties();
        this.applyWidgetOverrides();
        this.adjustWidgetDimensions(false);
        this.adjustWidgetDimensions(true);
        this.resetCrossSprites();
        this.changeCrossSprites();
    }

    void removeGameframe() {
        this.restoreSprites();
        BufferedImage compassImage = this.spriteManager.getSprite(169, 0);
        if (compassImage != null) {
            SpritePixels compass = ImageUtil.getImageSpritePixels(compassImage, this.client);
            this.client.setCompass(compass);
        }
    }

    void adjustWidgetDimensions(boolean modify) {
        for (WidgetResize widgetResize : WidgetResize.values()) {
            Widget widget = this.client.getWidget(widgetResize.getGroup());
            if (widget != null) {
                if (widgetResize.getOriginalX() != null) {
                    widget.setOriginalX(modify ? widgetResize.getModifiedX() : widgetResize.getOriginalX());
                }
                if (widgetResize.getOriginalY() != null) {
                    widget.setOriginalY(modify ? widgetResize.getModifiedY() : widgetResize.getOriginalY());
                }
                if (widgetResize.getOriginalWidth() != null) {
                    widget.setOriginalWidth(modify ? widgetResize.getModifiedWidth() : widgetResize.getOriginalWidth());
                }
                if (widgetResize.getOriginalHeight() != null) {
                    widget.setOriginalWidth(modify ? widgetResize.getModifiedHeight() : widgetResize.getOriginalHeight());
                }
            }
            if (widget == null) continue;
            widget.revalidate();
        }
    }

    void restoreSprites() {
        for (SpriteOverride spriteOverride : SpriteOverride.values()) {
            if (spriteOverride.equals((Object)SpriteOverride.LOGIN_SCREEN_BACKGROUND)) continue;
            this.client.getSpriteOverrides().remove(spriteOverride.getSpriteID());
        }
    }

    public String getCurrentPackPath() {
        Object path;
        switch (this.config.resourcePack()) {
            case SECOND: {
                path = this.config.resourcePack2Path();
                break;
            }
            case THIRD: {
                path = this.config.resourcePack3Path();
                break;
            }
            case HUB: {
                path = String.valueOf(ResourcePacksPlugin.RESOURCEPACKS_DIR) + File.separator + this.config.selectedHubPack();
                break;
            }
            default: {
                path = this.config.resourcePackPath();
            }
        }
        return path;
    }

    public boolean checkIfResourcePackPathIsNotEmpty() {
        switch (this.config.resourcePack()) {
            case FIRST: {
                if (!this.config.resourcePackPath().equals("")) break;
                return false;
            }
            case SECOND: {
                if (!this.config.resourcePack2Path().equals("")) break;
                return false;
            }
            case HUB: {
                if (!this.config.selectedHubPack().equals("")) break;
                return false;
            }
            case THIRD: {
                if (!this.config.resourcePack3Path().equals("")) break;
                return false;
            }
        }
        return true;
    }

    public SpritePixels getSpritePixels(SpriteOverride spriteOverride, String currentPackPath) {
        File spriteFile;
        String folder = spriteOverride.getFolder().name().toLowerCase();
        String name = spriteOverride.name().toLowerCase();
        if (!folder.equals("other")) {
            name = name.replaceFirst(folder + "_", "");
        }
        if (!(spriteFile = new File(currentPackPath + File.separator + folder + File.separator + name + ".png")).exists()) {
            return null;
        }
        try {
            BufferedImage image = ImageIO.read(spriteFile);
            if (this.config.allowColorPack() && this.config.colorPack() != null) {
                image = this.dye(image, this.config.colorPack());
            }
            return ImageUtil.getImageSpritePixels(image, this.client);
        }
        catch (IOException | RuntimeException ex) {
            log.debug("Unable to find image (" + spriteFile.getPath() + "): ");
            return null;
        }
    }

    void overrideSprites() {
        String currentPackPath = this.getCurrentPackPath();
        SpriteOverride.getOverrides().asMap().forEach((key, collection) -> {
            if (!Files.isDirectory(Paths.get(currentPackPath + File.separator + key.name().toLowerCase(), new String[0]), new LinkOption[0]) || !this.config.allowSpellsPrayers() && (key.name().contains("SPELL") || key.equals((Object)SpriteOverride.Folder.PRAYER))) {
                return;
            }
            for (SpriteOverride spriteOverride : collection) {
                SpritePixels spritePixels = this.getSpritePixels(spriteOverride, currentPackPath);
                if (this.config.allowLoginScreen() && spriteOverride == SpriteOverride.LOGIN_SCREEN_BACKGROUND) {
                    if (spritePixels != null) {
                        this.client.setLoginScreen(spritePixels);
                    } else {
                        this.resetLoginScreen();
                    }
                }
                if (spritePixels == null) continue;
                if (spriteOverride.getSpriteID() == 169) {
                    this.client.setCompass(spritePixels);
                    continue;
                }
                if (spriteOverride.getSpriteID() < -200) {
                    this.client.getSpriteOverrides().remove(spriteOverride.getSpriteID());
                }
                this.client.getSpriteOverrides().put(spriteOverride.getSpriteID(), spritePixels);
            }
        });
    }

    void reloadBankTagSprites() {
        String currentPackPath = this.getCurrentPackPath();
        SpriteOverride.getOverrides().asMap().forEach((key, collection) -> {
            if (!Files.isDirectory(Paths.get(currentPackPath + File.separator + key.name().toLowerCase(), new String[0]), new LinkOption[0])) {
                return;
            }
            for (SpriteOverride spriteOverride : collection) {
                if (spriteOverride.getSpriteID() >= -200) continue;
                SpritePixels spritePixels = this.getSpritePixels(spriteOverride, currentPackPath);
                this.client.getSpriteOverrides().remove(spriteOverride.getSpriteID());
                this.client.getSpriteOverrides().put(spriteOverride.getSpriteID(), spritePixels);
            }
        });
    }

    void resetLoginScreen() {
        ConfigChanged loginScreenConfigChanged = new ConfigChanged();
        loginScreenConfigChanged.setGroup("loginscreen");
        loginScreenConfigChanged.setKey("loginScreen");
        loginScreenConfigChanged.setOldValue(null);
        loginScreenConfigChanged.setNewValue("");
        this.eventBus.post(loginScreenConfigChanged);
    }

    void reloadColorProperties() {
        this.colorProperties.clear();
        File colorPropertiesFile = new File(this.getCurrentPackPath() + "/color.properties");
        try (FileInputStream in = new FileInputStream(colorPropertiesFile);){
            this.colorProperties.load(in);
        }
        catch (IOException e) {
            log.debug("Color properties not found");
            this.resetOverlayColor();
            return;
        }
        if (this.config.allowOverlayColor()) {
            this.changeOverlayColor();
        }
    }

    void changeOverlayColor() {
        if (this.configManager.getConfiguration("resourcepacks", "originalOverlayColor") == null) {
            this.configManager.setConfiguration("resourcepacks", "originalOverlayColor", this.configManager.getConfiguration("runelite", "overlayBackgroundColor"));
        }
        ResourcePacksPlugin.setIgnoreOverlayConfig(true);
        Color overlayColor = ColorUtil.fromHex(this.colorProperties.getProperty("overlay_color"));
        if (this.config.allowColorPack() && this.config.colorPack() != null && this.config.colorPack().getAlpha() != 0 && this.config.colorPackOverlay()) {
            overlayColor = this.config.colorPack();
        }
        this.configManager.setConfiguration("runelite", "overlayBackgroundColor", overlayColor);
        ResourcePacksPlugin.setIgnoreOverlayConfig(false);
    }

    void resetOverlayColor() {
        if (this.configManager.getConfiguration("resourcepacks", "originalOverlayColor") != null) {
            this.configManager.setConfiguration("runelite", "overlayBackgroundColor", this.configManager.getConfiguration("resourcepacks", "originalOverlayColor"));
            this.configManager.unsetConfiguration("resourcepacks", "originalOverlayColor");
        }
    }

    void changeCrossSprites() {
        if (!this.config.allowCrossSprites() || Boolean.getBoolean(this.configManager.getConfiguration("interfaceStyles", "rsCrossSprites")) || this.defaultCrossSprites != null) {
            return;
        }
        SpritePixels[] crossSprites = this.client.getCrossSprites();
        if (crossSprites == null) {
            return;
        }
        this.defaultCrossSprites = new SpritePixels[crossSprites.length];
        System.arraycopy(crossSprites, 0, this.defaultCrossSprites, 0, this.defaultCrossSprites.length);
        String currentPackPath = this.getCurrentPackPath();
        SpriteOverride.getOverrides().asMap().forEach((key, collection) -> {
            if (key != SpriteOverride.Folder.CROSS_SPRITES || !Files.isDirectory(Paths.get(currentPackPath + File.separator + key.name().toLowerCase(), new String[0]), new LinkOption[0])) {
                return;
            }
            for (SpriteOverride spriteOverride : collection) {
                SpritePixels spritePixels = this.getSpritePixels(spriteOverride, currentPackPath);
                if (spritePixels == null) continue;
                crossSprites[spriteOverride.getFrameID()] = spritePixels;
            }
        });
    }

    void resetCrossSprites() {
        if (this.defaultCrossSprites == null) {
            return;
        }
        SpritePixels[] crossSprites = this.client.getCrossSprites();
        if (crossSprites != null && this.defaultCrossSprites.length == crossSprites.length) {
            System.arraycopy(this.defaultCrossSprites, 0, crossSprites, 0, this.defaultCrossSprites.length);
        }
        this.defaultCrossSprites = null;
    }

    private BufferedImage dye(BufferedImage image, Color color) {
        int w = image.getWidth();
        int h2 = image.getHeight();
        BufferedImage dyed = new BufferedImage(w, h2, 2);
        Graphics2D g2 = dyed.createGraphics();
        g2.drawImage((Image)image, 0, 0, null);
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.setColor(color);
        g2.fillRect(0, 0, w, h2);
        g2.dispose();
        return dyed;
    }

    private void applyWidgetOverrides() {
        if (this.colorProperties.isEmpty()) {
            return;
        }
        for (WidgetOverride widgetOverride : WidgetOverride.values()) {
            this.addPropertyToWidget(widgetOverride);
        }
    }

    public void resetWidgetOverrides() {
        this.colorProperties.clear();
        for (WidgetOverride widgetOverride : WidgetOverride.values()) {
            this.addPropertyToWidget(widgetOverride);
        }
    }

    public void addPropertyToWidget(WidgetOverride widgetOverride) {
        String widgetProperty;
        int property = this.colorProperties.containsKey(widgetOverride.name().toLowerCase()) ? (!(widgetProperty = this.colorProperties.getProperty(widgetOverride.name().toLowerCase())).isEmpty() ? Integer.decode(widgetProperty).intValue() : widgetOverride.getDefaultColor()) : widgetOverride.getDefaultColor();
        int[] nArray = widgetOverride.getWidgetChildIds();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer childId = nArray[i];
            Widget widgetToOverride = this.client.getWidget(widgetOverride.getWidgetGroupId(), childId);
            if (widgetToOverride == null) continue;
            if (widgetOverride.getWidgetArrayIds()[0] != -1) {
                for (int arrayId : widgetOverride.getWidgetArrayIds()) {
                    Widget arrayWidget = widgetToOverride.getChild(arrayId);
                    if (arrayWidget == null || arrayWidget.getTextColor() == -1 || arrayWidget.getTextColor() == property) continue;
                    arrayWidget.setTextColor(property);
                }
                continue;
            }
            if (widgetToOverride.getTextColor() == -1 && widgetToOverride.getTextColor() == property) continue;
            widgetToOverride.setTextColor(property);
        }
    }

    public Properties getColorProperties() {
        return this.colorProperties;
    }
}

