/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.sailingskill.widgets;

import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.ScriptEvent;
import net.runelite.api.SpritePixels;
import net.runelite.api.widgets.Widget;
import net.runelite.client.plugins.sailingskill.SailingPlugin;
import net.runelite.client.util.ImageUtil;

public class BoatWidgetManager {
    @Inject
    private Client client;
    @Inject
    private SailingPlugin plugin;
    private final BufferedImage wheelLeftUnpressed = ImageUtil.loadImageResource(this.getClass(), "Wheel_Left_Unpressed.png");
    private final BufferedImage wheelLeftPressed = ImageUtil.loadImageResource(this.getClass(), "Wheel_Left_Pressed.png");
    private final BufferedImage wheelRightUnpressed = ImageUtil.loadImageResource(this.getClass(), "Wheel_Right_Unpressed.png");
    private final BufferedImage wheelRightPressed = ImageUtil.loadImageResource(this.getClass(), "Wheel_Right_Pressed.png");
    private final BufferedImage anchorPressed = ImageUtil.loadImageResource(this.getClass(), "Anchor_Pressed.png");
    private final BufferedImage anchorUnpressed = ImageUtil.loadImageResource(this.getClass(), "Anchor_Unpressed.png");
    private final BufferedImage speed1Unpressed = ImageUtil.loadImageResource(this.getClass(), "Speed_1_Unpressed.png");
    private final BufferedImage speed1Pressed = ImageUtil.loadImageResource(this.getClass(), "Speed_1_Pressed.png");
    private final BufferedImage speed2Unpressed = ImageUtil.loadImageResource(this.getClass(), "Speed_2_Unpressed.png");
    private final BufferedImage speed2Pressed = ImageUtil.loadImageResource(this.getClass(), "Speed_2_Pressed.png");
    private final BufferedImage speed3Unpressed = ImageUtil.loadImageResource(this.getClass(), "Speed_3_Unpressed.png");
    private final BufferedImage speed3Pressed = ImageUtil.loadImageResource(this.getClass(), "Speed_3_Pressed.png");
    private Widget parent;
    private Widget wheelRightWidget;
    private Widget wheelLeftWidget;
    private Widget anchorWidget;
    private Widget speed1Widget;
    private Widget speed2Widget;
    private Widget speed3Widget;
    private final int SPEED_1_PRESSED_ID = 1625;
    private final int SPEED_1_UNPRESSED_ID = 1615;
    private final int SPEED_2_PRESSED_ID = 2434;
    private final int SPEED_2_UNPRESSED_ID = 2436;
    private final int SPEED_3_PRESSED_ID = 2438;
    private final int SPEED_3_UNPRESSED_ID = 2440;
    private final int WHEEL_LEFT_UNPRESSED_ID = 1619;
    private final int WHEEL_LEFT_PRESSED_ID = 2974;
    private final int WHEEL_RIGHT_UNPRESSED_ID = 1626;
    private final int WHEEL_RIGHT_PRESSED_ID = 2442;
    private final int ANCHOR_UNPRESSED_ID = 1624;
    private final int ANCHOR_PRESSED_ID = 1098;
    private final int HOVERED_OPACITY = 125;
    private final int BASE_Y = -25;

    public void setParent(Widget parentWidget) {
        this.parent = parentWidget;
    }

    public void createWidgets() {
        this.wheelLeftWidget = this.parent.createChild(1, 5);
        this.wheelLeftWidget.setPos(-50, -62, 1, 1);
        this.wheelLeftWidget.setSize(53, 88);
        this.wheelLeftWidget.setOriginalHeight(88);
        this.wheelLeftWidget.setOriginalWidth(53);
        this.wheelLeftWidget.setSpriteId(1619);
        this.wheelLeftWidget.revalidate();
        this.wheelLeftWidget.setHasListener(true);
        this.wheelLeftWidget.setOnMouseRepeatListener(this::wheelLeftHoverEvent);
        this.wheelLeftWidget.setOnMouseLeaveListener(this::wheelLeftLeaveEvent);
        this.wheelLeftWidget.setOnOpListener(this::wheelLeftClickEvent);
        this.wheelLeftWidget.setAction(0, "Rotate left");
        this.wheelRightWidget = this.parent.createChild(2, 5);
        this.wheelRightWidget.setPos(51, -62, 1, 1);
        this.wheelRightWidget.setSize(53, 88);
        this.wheelRightWidget.setOriginalHeight(88);
        this.wheelRightWidget.setOriginalWidth(53);
        this.wheelRightWidget.setSpriteId(1626);
        this.wheelRightWidget.revalidate();
        this.wheelRightWidget.setHasListener(true);
        this.wheelRightWidget.setOnMouseRepeatListener(this::wheelRightHoverEvent);
        this.wheelRightWidget.setOnMouseLeaveListener(this::wheelRightLeaveEvent);
        this.wheelRightWidget.setOnOpListener(this::wheelRightClickEvent);
        this.wheelRightWidget.setAction(0, "Rotate right");
        this.anchorWidget = this.parent.createChild(3, 5);
        this.anchorWidget.setPos(0, -25, 1, 1);
        this.anchorWidget.setSize(40, 26);
        this.anchorWidget.setOriginalHeight(26);
        this.anchorWidget.setOriginalWidth(40);
        this.anchorWidget.setSpriteId(1098);
        this.anchorWidget.revalidate();
        this.anchorWidget.setNoClickThrough(true);
        this.anchorWidget.setHasListener(true);
        this.anchorWidget.setOnOpListener(this::anchorOpEvent);
        this.anchorWidget.setOnTimerListener(this::anchorOnClientTick);
        this.anchorWidget.setOnMouseOverListener(this::anchorHoverEvent);
        this.anchorWidget.setOnMouseLeaveListener(this::anchorLeaveEvent);
        this.anchorWidget.setAction(0, "Toggle anchor");
        this.speed1Widget = this.parent.createChild(4, 5);
        this.speed1Widget.setPos(0, -50, 1, 1);
        this.speed1Widget.setSize(40, 26);
        this.speed1Widget.setOriginalHeight(26);
        this.speed1Widget.setOriginalWidth(40);
        this.speed1Widget.setSpriteId(1625);
        this.speed1Widget.revalidate();
        this.speed1Widget.setHasListener(true);
        this.speed1Widget.setOnOpListener(this::speed1ClickEvent);
        this.speed1Widget.setOnMouseOverListener(this::speed1HoverEvent);
        this.speed1Widget.setOnMouseLeaveListener(this::speed1LeaveEvent);
        this.speed1Widget.setAction(0, "Sail speed 1");
        this.speed2Widget = this.parent.createChild(5, 5);
        this.speed2Widget.setPos(0, -75, 1, 1);
        this.speed2Widget.setSize(40, 26);
        this.speed2Widget.setOriginalHeight(26);
        this.speed2Widget.setOriginalWidth(40);
        this.speed2Widget.setSpriteId(2436);
        this.speed2Widget.revalidate();
        this.speed2Widget.setHasListener(true);
        this.speed2Widget.setOnOpListener(this::speed2ClickEvent);
        this.speed2Widget.setOnMouseOverListener(this::speed2HoverEvent);
        this.speed2Widget.setOnMouseLeaveListener(this::speed2LeaveEvent);
        this.speed2Widget.setAction(0, "Sail speed 2");
        this.speed3Widget = this.parent.createChild(6, 5);
        this.speed3Widget.setPos(0, -100, 1, 1);
        this.speed3Widget.setSize(40, 26);
        this.speed3Widget.setOriginalHeight(26);
        this.speed3Widget.setOriginalWidth(40);
        this.speed3Widget.setSpriteId(2440);
        this.speed3Widget.revalidate();
        this.speed3Widget.setHasListener(true);
        this.speed3Widget.setOnOpListener(this::speed3ClickEvent);
        this.speed3Widget.setOnMouseOverListener(this::speed3HoverEvent);
        this.speed3Widget.setOnMouseLeaveListener(this::speed3LeaveEvent);
        this.speed3Widget.setAction(0, "Sail speed 3");
    }

    public void speed1ClickEvent(ScriptEvent e) {
        this.plugin.setSailLength(1);
    }

    public void speed1HoverEvent(ScriptEvent e) {
        this.speed1Widget.setOpacity(125);
    }

    public void speed1LeaveEvent(ScriptEvent e) {
        this.speed1Widget.setOpacity(0);
    }

    public void speed2ClickEvent(ScriptEvent e) {
        this.plugin.setSailLength(2);
    }

    public void speed2HoverEvent(ScriptEvent e) {
        this.speed2Widget.setOpacity(125);
    }

    public void speed2LeaveEvent(ScriptEvent e) {
        this.speed2Widget.setOpacity(0);
    }

    public void speed3ClickEvent(ScriptEvent e) {
        this.plugin.setSailLength(3);
    }

    public void speed3HoverEvent(ScriptEvent e) {
        this.speed3Widget.setOpacity(125);
    }

    public void speed3LeaveEvent(ScriptEvent e) {
        this.speed3Widget.setOpacity(0);
    }

    public void wheelLeftClickEvent(ScriptEvent e) {
        this.plugin.rotateBoatCCW();
    }

    public void wheelRightClickEvent(ScriptEvent e) {
        this.plugin.rotateBoatCW();
    }

    public void wheelLeftHoverEvent(ScriptEvent e) {
        this.wheelLeftWidget.setOpacity(125);
    }

    public void wheelRightHoverEvent(ScriptEvent e) {
        this.wheelRightWidget.setOpacity(125);
    }

    public void wheelLeftLeaveEvent(ScriptEvent e) {
        this.wheelLeftWidget.setOpacity(0);
    }

    public void wheelRightLeaveEvent(ScriptEvent e) {
        this.wheelRightWidget.setOpacity(0);
    }

    public void anchorOpEvent(ScriptEvent e) {
        this.plugin.setSailLength(0);
    }

    public void anchorHoverEvent(ScriptEvent e) {
        this.anchorWidget.setOpacity(125);
    }

    public void anchorLeaveEvent(ScriptEvent e) {
        this.anchorWidget.setOpacity(0);
    }

    public void anchorOnClientTick(ScriptEvent e) {
        this.updateSailLengthSprite(this.plugin.getSailLength());
        this.updateBoatRotationSprite();
    }

    public void updateBoatRotationSprite() {
        int rotationQueue = this.plugin.getBoatRotationQueue();
        if (rotationQueue > 0) {
            this.wheelLeftWidget.setSpriteId(1619);
            this.wheelRightWidget.setSpriteId(2442);
            return;
        }
        if (rotationQueue < 0) {
            this.wheelLeftWidget.setSpriteId(2974);
            this.wheelRightWidget.setSpriteId(1626);
            return;
        }
        this.wheelLeftWidget.setSpriteId(1619);
        this.wheelRightWidget.setSpriteId(1626);
    }

    public void updateSailLengthSprite(int sailLength) {
        switch (sailLength) {
            case 0: {
                this.speed1Widget.setSpriteId(1615);
                this.speed2Widget.setSpriteId(2436);
                this.speed3Widget.setSpriteId(2440);
                this.anchorWidget.setSpriteId(1098);
                return;
            }
            case 1: {
                this.speed1Widget.setSpriteId(1625);
                this.speed2Widget.setSpriteId(2436);
                this.speed3Widget.setSpriteId(2440);
                this.anchorWidget.setSpriteId(1624);
                return;
            }
            case 2: {
                this.speed1Widget.setSpriteId(1615);
                this.speed2Widget.setSpriteId(2434);
                this.speed3Widget.setSpriteId(2440);
                this.anchorWidget.setSpriteId(1624);
                return;
            }
            case 3: {
                this.speed1Widget.setSpriteId(1615);
                this.speed2Widget.setSpriteId(2436);
                this.speed3Widget.setSpriteId(2438);
                this.anchorWidget.setSpriteId(1624);
            }
        }
    }

    public void setWheelSprite() {
        SpritePixels sp1 = ImageUtil.getImageSpritePixels(this.speed1Unpressed, this.client);
        this.client.getSpriteOverrides().put(1615, sp1);
        SpritePixels sp2 = ImageUtil.getImageSpritePixels(this.speed1Pressed, this.client);
        this.client.getSpriteOverrides().put(1625, sp2);
        SpritePixels sp3 = ImageUtil.getImageSpritePixels(this.speed2Unpressed, this.client);
        this.client.getSpriteOverrides().put(2436, sp3);
        SpritePixels sp4 = ImageUtil.getImageSpritePixels(this.speed2Pressed, this.client);
        this.client.getSpriteOverrides().put(2434, sp4);
        SpritePixels sp5 = ImageUtil.getImageSpritePixels(this.speed3Unpressed, this.client);
        this.client.getSpriteOverrides().put(2440, sp5);
        SpritePixels sp6 = ImageUtil.getImageSpritePixels(this.speed3Pressed, this.client);
        this.client.getSpriteOverrides().put(2438, sp6);
        SpritePixels sp7 = ImageUtil.getImageSpritePixels(this.wheelLeftUnpressed, this.client);
        this.client.getSpriteOverrides().put(1619, sp7);
        SpritePixels sp8 = ImageUtil.getImageSpritePixels(this.wheelRightUnpressed, this.client);
        this.client.getSpriteOverrides().put(1626, sp8);
        SpritePixels sp9 = ImageUtil.getImageSpritePixels(this.wheelLeftPressed, this.client);
        this.client.getSpriteOverrides().put(2974, sp9);
        SpritePixels sp10 = ImageUtil.getImageSpritePixels(this.wheelRightPressed, this.client);
        this.client.getSpriteOverrides().put(2442, sp10);
        SpritePixels anchorSprite = ImageUtil.getImageSpritePixels(this.anchorUnpressed, this.client);
        this.client.getSpriteOverrides().put(1624, anchorSprite);
        SpritePixels anchorPressedSprite = ImageUtil.getImageSpritePixels(this.anchorPressed, this.client);
        this.client.getSpriteOverrides().put(1098, anchorPressedSprite);
    }

    public void setupManager(Widget parent) {
        this.setParent(parent);
        this.setWheelSprite();
        this.createWidgets();
    }

    public Widget getSpeed1Widget() {
        return this.speed1Widget;
    }

    public Widget getSpeed2Widget() {
        return this.speed2Widget;
    }

    public Widget getSpeed3Widget() {
        return this.speed3Widget;
    }
}

