/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.sailingskill.widgets;

import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.ScriptEvent;
import net.runelite.api.SpritePixels;
import net.runelite.api.widgets.Widget;
import net.runelite.client.plugins.sailingskill.SailingPlugin;
import net.runelite.client.util.ImageUtil;

public class MiscWidgetManager {
    @Inject
    private Client client;
    @Inject
    private SailingPlugin plugin;
    private final BufferedImage cannonPressed = ImageUtil.loadImageResource(this.getClass(), "Button_Cannon_Pressed.png");
    private final BufferedImage cannonUnpressed = ImageUtil.loadImageResource(this.getClass(), "Button_Cannon_Unpressed.png");
    private final BufferedImage invPressed = ImageUtil.loadImageResource(this.getClass(), "Button_Inv_Pressed.png");
    private final BufferedImage invUnpressed = ImageUtil.loadImageResource(this.getClass(), "Button_Inv_Unpressed.png");
    private final BufferedImage keyboardUnpressed = ImageUtil.loadImageResource(this.getClass(), "Button_Keyboard_Unpressed.png");
    private final BufferedImage keyboardPressed = ImageUtil.loadImageResource(this.getClass(), "Button_Keyboard_Pressed.png");
    private Widget parent;
    private Widget keyboardWidget;
    private Widget cannonOverlayWidget;
    private Widget inventoryWidget;
    private final int KEYBOARD_UNPRESSED_SPRITE_ID = 1622;
    private final int KEYBOARD_PRESSED_SPRITE_ID = 1346;
    private final int CANNON_UNPRESSED_SPRITE_ID = 1617;
    private final int CANNON_PRESSED_SPRITE_ID = 1347;
    private final int INVENTORY_UNPRESSED_SPRITE_ID = 1653;
    private final int INVENTORY_PRESSED_SPRITE_ID = 1348;
    private final int BASE_Y = 95;

    public void setParent(Widget parentWidget) {
        this.parent = parentWidget;
    }

    public void createWidgets() {
        this.cannonOverlayWidget = this.parent.createChild(7, 5);
        this.cannonOverlayWidget.setPos(-55, 95, 1, 1);
        this.cannonOverlayWidget.setSize(40, 40);
        this.cannonOverlayWidget.setOriginalHeight(40);
        this.cannonOverlayWidget.setOriginalWidth(40);
        this.cannonOverlayWidget.setSpriteId(1617);
        this.cannonOverlayWidget.revalidate();
        this.cannonOverlayWidget.setHasListener(true);
        this.cannonOverlayWidget.setOnOpListener(this::cannonOverlayOpEvent);
        this.cannonOverlayWidget.setAction(0, "Toggle cannon overlay");
        this.keyboardWidget = this.parent.createChild(8, 5);
        this.keyboardWidget.setPos(0, 95, 1, 1);
        this.keyboardWidget.setSize(40, 40);
        this.keyboardWidget.setOriginalHeight(40);
        this.keyboardWidget.setOriginalWidth(40);
        this.keyboardWidget.setSpriteId(1346);
        this.keyboardWidget.revalidate();
        this.keyboardWidget.setHasListener(true);
        this.keyboardWidget.setOnOpListener(this::keyboardOpEvent);
        this.keyboardWidget.setAction(0, "Toggle keyboard control");
        this.inventoryWidget = this.parent.createChild(9, 5);
        this.inventoryWidget.setPos(55, 95, 1, 1);
        this.inventoryWidget.setSize(40, 40);
        this.inventoryWidget.setOriginalHeight(40);
        this.inventoryWidget.setOriginalWidth(40);
        this.inventoryWidget.setSpriteId(1653);
        this.inventoryWidget.revalidate();
        this.inventoryWidget.setHasListener(true);
        this.inventoryWidget.setOnOpListener(this::inventoryOpEvent);
        this.inventoryWidget.setOnReleaseListener(this::inventoryReleaseEvent);
        this.inventoryWidget.setAction(0, "Open ship inventory");
    }

    public void cannonOverlayOpEvent(ScriptEvent e) {
        if (this.plugin.isShowCannonRange()) {
            this.plugin.setShowCannonRange(false);
            this.cannonOverlayWidget.setSpriteId(1617);
        } else {
            this.plugin.setShowCannonRange(true);
            this.cannonOverlayWidget.setSpriteId(1347);
        }
    }

    public void keyboardOpEvent(ScriptEvent e) {
        if (this.plugin.isEnableKeyboardControl()) {
            this.plugin.setEnableKeyboardControl(false);
            this.keyboardWidget.setSpriteId(1622);
        } else {
            this.plugin.setEnableKeyboardControl(true);
            this.keyboardWidget.setSpriteId(1346);
        }
    }

    public void inventoryOpEvent(ScriptEvent e) {
        this.inventoryWidget.setSpriteId(1348);
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "player", "Sailing isn't real so your ship has no inventory.", "game");
    }

    public void inventoryReleaseEvent(ScriptEvent e) {
        this.inventoryWidget.setSpriteId(1653);
    }

    public void setButtonSprites() {
        SpritePixels cannonOverlayUnpressedSprite = ImageUtil.getImageSpritePixels(this.cannonUnpressed, this.client);
        this.client.getSpriteOverrides().put(1617, cannonOverlayUnpressedSprite);
        SpritePixels cannonOverlayPressedSprite = ImageUtil.getImageSpritePixels(this.cannonPressed, this.client);
        this.client.getSpriteOverrides().put(1347, cannonOverlayPressedSprite);
        SpritePixels keyboardUnpressedSprite = ImageUtil.getImageSpritePixels(this.keyboardUnpressed, this.client);
        this.client.getSpriteOverrides().put(1622, keyboardUnpressedSprite);
        SpritePixels keyboardPressedSprite = ImageUtil.getImageSpritePixels(this.keyboardPressed, this.client);
        this.client.getSpriteOverrides().put(1346, keyboardPressedSprite);
        SpritePixels inventoryUnpressedSprite = ImageUtil.getImageSpritePixels(this.invUnpressed, this.client);
        this.client.getSpriteOverrides().put(1653, inventoryUnpressedSprite);
        SpritePixels inventoryPressedSprite = ImageUtil.getImageSpritePixels(this.invPressed, this.client);
        this.client.getSpriteOverrides().put(1348, inventoryPressedSprite);
    }

    public void setupManager(Widget parent) {
        this.setParent(parent);
        this.setButtonSprites();
        this.createWidgets();
    }
}

