/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.sailingskill.widgets;

import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.SpritePixels;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.util.ImageUtil;

public class TabIconManager {
    @Inject
    private Client client;
    private final BufferedImage anchorTabImage = ImageUtil.loadImageResource(this.getClass(), "Tab_Anchor_Icon.png");
    private final int ANCHOR_SPRITE_ID = 803;

    public void setFixedSailingTab() {
        Widget fixedCombatWidget = this.client.getWidget(WidgetInfo.FIXED_VIEWPORT_COMBAT_ICON);
        if (fixedCombatWidget != null) {
            fixedCombatWidget.setSpriteId(803);
            fixedCombatWidget.setPos(14, 6);
            fixedCombatWidget.setSize(24, 24);
            fixedCombatWidget.setOriginalHeight(24);
            fixedCombatWidget.setOriginalWidth(24);
            fixedCombatWidget.revalidate();
        }
    }

    public void setResizableSailingTab() {
        Widget resizableCombatWidget = this.client.getWidget(WidgetInfo.RESIZABLE_VIEWPORT_COMBAT_ICON);
        if (resizableCombatWidget != null) {
            resizableCombatWidget.setSpriteId(803);
            resizableCombatWidget.setPos(8, 6);
            resizableCombatWidget.setSize(24, 24);
            resizableCombatWidget.setOriginalHeight(24);
            resizableCombatWidget.setOriginalWidth(24);
            resizableCombatWidget.revalidate();
        }
    }

    public void setModernSailingTab() {
        Widget modernCombatWidget = this.client.getWidget(WidgetInfo.RESIZABLE_VIEWPORT_BOTTOM_LINE_COMBAT_ICON);
        if (modernCombatWidget != null) {
            modernCombatWidget.setSpriteId(803);
            modernCombatWidget.setPos(5, 6);
            modernCombatWidget.setSize(24, 24);
            modernCombatWidget.setOriginalHeight(24);
            modernCombatWidget.setOriginalWidth(24);
            modernCombatWidget.revalidate();
        }
    }

    public void unsetFixedSailingTab() {
        Widget fixedCombatWidget = this.client.getWidget(WidgetInfo.FIXED_VIEWPORT_COMBAT_ICON);
        if (fixedCombatWidget != null) {
            fixedCombatWidget.setSpriteId(774);
            fixedCombatWidget.setPos(10, 0);
            fixedCombatWidget.setSize(33, 36);
            fixedCombatWidget.setOriginalHeight(36);
            fixedCombatWidget.setOriginalWidth(33);
            fixedCombatWidget.revalidate();
        }
    }

    public void unsetResizableSailingTab() {
        Widget resizableCombatWidget = this.client.getWidget(WidgetInfo.RESIZABLE_VIEWPORT_COMBAT_ICON);
        if (resizableCombatWidget != null) {
            resizableCombatWidget.setSpriteId(774);
            resizableCombatWidget.setPos(4, 0);
            resizableCombatWidget.setSize(33, 36);
            resizableCombatWidget.setOriginalHeight(36);
            resizableCombatWidget.setOriginalWidth(33);
            resizableCombatWidget.revalidate();
        }
    }

    public void unsetModernSailingTab() {
        Widget modernCombatWidget = this.client.getWidget(WidgetInfo.RESIZABLE_VIEWPORT_BOTTOM_LINE_COMBAT_ICON);
        if (modernCombatWidget != null) {
            modernCombatWidget.setSpriteId(774);
            modernCombatWidget.setPos(0, 0);
            modernCombatWidget.setSize(33, 36);
            modernCombatWidget.setOriginalHeight(36);
            modernCombatWidget.setOriginalWidth(33);
            modernCombatWidget.revalidate();
        }
    }

    public void setAnchorSpriteOverride() {
        SpritePixels anchorTabSprite = ImageUtil.getImageSpritePixels(this.anchorTabImage, this.client);
        this.client.getSpriteOverrides().put(803, anchorTabSprite);
    }
}

