/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.timers;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import net.runelite.client.plugins.timers.TimersPlugin;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import org.apache.commons.lang3.time.DurationFormatUtils;

class ElapsedTimer
extends InfoBox {
    private final Instant startTime;
    private final Instant lastTime;

    ElapsedTimer(BufferedImage image, TimersPlugin plugin, Instant startTime, Instant lastTime) {
        super(image, plugin);
        this.startTime = startTime;
        this.lastTime = lastTime;
    }

    @Override
    public String getText() {
        if (this.startTime == null) {
            return null;
        }
        Duration time = Duration.between(this.startTime, this.lastTime == null ? Instant.now() : this.lastTime);
        String formatString = "mm:ss";
        return DurationFormatUtils.formatDuration(time.toMillis(), "mm:ss", true);
    }

    @Override
    public Color getTextColor() {
        return Color.WHITE;
    }

    @Override
    public String getTooltip() {
        Duration time = Duration.between(this.startTime == null ? Instant.now().minus(5L, ChronoUnit.SECONDS) : this.startTime, this.lastTime == null ? Instant.now() : this.lastTime);
        return "Elapsed time: " + DurationFormatUtils.formatDuration(time.toMillis(), "HH:mm:ss", true);
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getLastTime() {
        return this.lastTime;
    }
}

