/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.http.api;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PomVersionFetcher {
    public static String init() {
        try {
            String pomXmlUrl = "https://raw.githubusercontent.com/runelite/runelite/master/pom.xml";
            return "runelite-" + PomVersionFetcher.getVersionFromPom(pomXmlUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getVersionFromPom(String pomXmlUrl) throws IOException {
        try (InputStream inputStream2 = new URL(pomXmlUrl).openStream();){
            DocumentBuilderFactory factory2 = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory2.newDocumentBuilder();
            Document document = builder.parse(new InputSource(inputStream2));
            NodeList versionNodes = document.getElementsByTagName("version");
            if (versionNodes.getLength() <= 0) throw new IOException("Version element not found in the XML");
            String string2 = versionNodes.item(0).getTextContent();
            return string2;
        }
        catch (Exception e) {
            throw new IOException("Error parsing XML", e);
        }
    }
}

