/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.http.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import net.runelite.http.api.PomVersionFetcher;
import net.runelite.http.api.gson.ColorTypeAdapter;
import net.runelite.http.api.gson.IllegalReflectionExclusion;
import net.runelite.http.api.gson.InstantTypeAdapter;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuneLiteAPI {
    private static final Logger logger = LoggerFactory.getLogger(RuneLiteAPI.class);
    public static final String RUNELITE_AUTH = "RUNELITE-AUTH";
    public static final String RUNELITE_MACHINEID = "RUNELITE-MACHINEID";
    public static OkHttpClient CLIENT;
    public static final Gson GSON;
    public static final MediaType JSON;
    public static String userAgent;
    private static final String BASE = "https://api.runelite.net";
    private static final String WSBASE = "https://api.runelite.net/ws";
    private static final String STATICBASE = "https://static.runelite.net";
    private static final Properties properties;
    private static String version;

    public static HttpUrl getSessionBase() {
        String prop = System.getProperty("runelite.session.url");
        if (prop != null && !prop.isEmpty()) {
            return HttpUrl.get(prop);
        }
        return HttpUrl.get("https://api.runelite.net/session");
    }

    public static HttpUrl getApiBase() {
        String prop = System.getProperty("runelite.http-service.url");
        if (prop != null && !prop.isEmpty()) {
            return HttpUrl.get(prop);
        }
        return HttpUrl.get("https://api.runelite.net/runelite-" + RuneLiteAPI.getVersion());
    }

    public static HttpUrl getStaticBase() {
        String prop = System.getProperty("runelite.static.url");
        if (prop != null && !prop.isEmpty()) {
            return HttpUrl.get(prop);
        }
        return HttpUrl.get(STATICBASE);
    }

    public static HttpUrl getWsEndpoint() {
        String prop = System.getProperty("runelite.ws.url");
        if (prop != null && !prop.isEmpty()) {
            return HttpUrl.get(prop);
        }
        return HttpUrl.get(WSBASE);
    }

    public static String getVersion() {
        String ver = PomVersionFetcher.init();
        if (ver == null) {
            ver = properties.getProperty("runelite.version");
        }
        return ver;
    }

    public static void setVersion(String version) {
        RuneLiteAPI.version = version;
    }

    static {
        JSON = MediaType.parse("application/json");
        properties = new Properties();
        try {
            InputStream in = RuneLiteAPI.class.getResourceAsStream("runelite.properties");
            properties.load(in);
            String ver = PomVersionFetcher.init();
            if (ver == null) {
                ver = properties.getProperty("runelite.version");
            }
            version = ver;
            String commit = properties.getProperty("runelite.commit");
            boolean dirty = Boolean.parseBoolean(properties.getProperty("runelite.dirty"));
            userAgent = "RuneLite/" + version + "-" + commit + (dirty ? "+" : "");
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Version string has not been substituted; Re-run maven");
        }
        catch (IOException ex) {
            logger.error(null, ex);
        }
        CLIENT = new OkHttpClient.Builder().pingInterval(30L, TimeUnit.SECONDS).addNetworkInterceptor(new Interceptor(){

            @Override
            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request userAgentRequest = chain.request().newBuilder().header("User-Agent", userAgent).build();
                return chain.proceed(userAgentRequest);
            }
        }).build();
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter((Type)((Object)Instant.class), new InstantTypeAdapter()).registerTypeAdapter((Type)((Object)Color.class), new ColorTypeAdapter());
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertionsEnabled) {
            IllegalReflectionExclusion jbe = new IllegalReflectionExclusion();
            gsonBuilder.addSerializationExclusionStrategy(jbe);
            gsonBuilder.addDeserializationExclusionStrategy(jbe);
        }
        GSON = gsonBuilder.create();
    }
}

