/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.rlawt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public final class AWTContext {
    private static boolean nativesLoaded = false;
    private long instance;

    public static synchronized void loadNatives() {
        if (nativesLoaded) {
            return;
        }
        System.loadLibrary("jawt");
        String string2 = System.getProperty("runelite.rlawtpath");
        if (string2 != null) {
            System.load(string2);
            nativesLoaded = true;
            return;
        }
        String string3 = System.getProperty("os.name", "no-os").toLowerCase();
        String string4 = System.getProperty("os.arch", "no-arch");
        String string5 = "unknown";
        if (string3.contains("mac") || string3.contains("darwin")) {
            string3 = "macos";
            string5 = "librlawt.dylib";
        } else if (string3.contains("win")) {
            string3 = "windows";
            string5 = "rlawt.dll";
        } else if (string3.contains("nux")) {
            string3 = "linux";
            string5 = "librlawt.so";
        }
        String string6 = string3 + "-" + string4 + "/" + string5;
        try (InputStream inputStream2 = AWTContext.class.getResourceAsStream(string6);){
            if (inputStream2 == null) {
                throw new RuntimeException("rlawt does not exist at " + string6);
            }
            Path path = Files.createTempFile("", string5, new FileAttribute[0]);
            path.toFile().deleteOnExit();
            Files.copy(inputStream2, path, StandardCopyOption.REPLACE_EXISTING);
            System.load(path.toAbsolutePath().toString());
            nativesLoaded = true;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static native long create0(Component var0);

    public AWTContext(Component component) {
        this.instance = AWTContext.create0(component);
        if (this.instance == 0L) {
            throw new NullPointerException();
        }
        int n = 0;
        int n2 = 0;
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (container instanceof Window) {
                Insets insets = ((Window)container).getInsets();
                n -= insets.left;
                n2 -= insets.top;
                break;
            }
            n += container.getX();
            n2 += container.getY();
        }
        this.configureInsets(n, n2);
    }

    public native void destroy();

    private native void configureInsets(int var1, int var2);

    public native void configurePixelFormat(int var1, int var2, int var3);

    public native void configureMultisamples(int var1);

    public native int getFramebuffer(boolean var1);

    public int getBufferMode() {
        return this.getFramebuffer(true) == 0 ? 1028 : 36064;
    }

    public native void createGLContext();

    public native int setSwapInterval(int var1);

    public native void makeCurrent();

    public native void detachCurrent();

    public native void swapBuffers();

    public native long getGLContext();

    public native long getCGLShareGroup();

    public native long getGLXDisplay();

    public native long getWGLHDC();
}

