/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Iterator;
import org.jgroups.Address;
import org.jgroups.BytesMessage;
import org.jgroups.EmptyMessage;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.Component;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.XmlAttribute;
import org.jgroups.auth.AuthToken;
import org.jgroups.auth.X509Token;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.AuthHeader;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

@XmlAttribute(attrs={"auth_value", "fixed_members_value", "fixed_members_seperator", "client_principal_name", "client_password", "service_principal_name", "match_string", "match_ip_address", "match_logical_name", "keystore_type", "cert_alias", "keystore_path", "cipher_type", "cert_password", "keystore_password"})
@MBean(description="Provides authentication of joiners, to prevent un-authorized joining of a cluster")
public class AUTH
extends Protocol {
    protected static final short GMS_ID = ClassConfigurator.getProtocolId(GMS.class);
    @Component
    protected AuthToken auth_token;
    protected volatile boolean authenticate_coord = true;

    @Property(description="Do join or merge responses from the coordinator also need to be authenticated")
    public AUTH setAuthCoord(boolean authenticateCoord) {
        this.authenticate_coord = authenticateCoord;
        return this;
    }

    @Property(name="auth_class", description="The fully qualified name of the class implementing the AuthToken interface")
    public void setAuthClass(String class_name) throws Exception {
        Object obj2 = Class.forName(class_name).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.auth_token = (AuthToken)obj2;
        this.auth_token.setAuth(this);
    }

    public String getAuthClass() {
        return this.auth_token != null ? this.auth_token.getClass().getName() : null;
    }

    public AuthToken getAuthToken() {
        return this.auth_token;
    }

    public AUTH setAuthToken(AuthToken token) {
        this.auth_token = token;
        return this;
    }

    public PhysicalAddress getPhysicalAddress() {
        return this.getTransport().getPhysicalAddress();
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.auth_token == null) {
            throw new IllegalStateException("no authentication mechanism configured");
        }
        if (this.auth_token instanceof X509Token) {
            X509Token tmp = (X509Token)this.auth_token;
            tmp.setCertificate();
        }
        this.auth_token.init();
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (this.auth_token != null) {
            this.auth_token.start();
        }
    }

    @Override
    public void stop() {
        if (this.auth_token != null) {
            this.auth_token.stop();
        }
        super.stop();
    }

    @Override
    public void destroy() {
        if (this.auth_token != null) {
            this.auth_token.destroy();
        }
        super.destroy();
    }

    @Override
    public Object up(Message msg) {
        GMS.GmsHeader gms_hdr = AUTH.getGMSHeader(msg);
        if (gms_hdr != null && this.needsAuthentication(msg, gms_hdr)) {
            AuthHeader auth_hdr = (AuthHeader)msg.getHeader(this.id);
            if (auth_hdr == null) {
                this.sendRejectionMessage(gms_hdr.getType(), msg.getSrc(), "no AUTH header found in message");
                throw new IllegalStateException(String.format("found %s from %s but no AUTH header", gms_hdr, msg.getSrc()));
            }
            if (!this.handleAuthHeader(gms_hdr, auth_hdr, msg)) {
                return null;
            }
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            GMS.GmsHeader gms_hdr = AUTH.getGMSHeader(msg);
            if (gms_hdr == null || !this.needsAuthentication(msg, gms_hdr)) continue;
            AuthHeader auth_hdr = (AuthHeader)msg.getHeader(this.id);
            if (auth_hdr == null) {
                this.log.warn("%s: found GMS join or merge request from %s but no AUTH header", this.local_addr, batch.sender());
                this.sendRejectionMessage(gms_hdr.getType(), batch.sender(), "join or merge without an AUTH header");
                it.remove();
                continue;
            }
            if (this.handleAuthHeader(gms_hdr, auth_hdr, msg)) continue;
            it.remove();
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    @Override
    public Object down(Message msg) {
        GMS.GmsHeader hdr = AUTH.getGMSHeader(msg);
        if (hdr != null && this.needsAuthentication(msg, hdr)) {
            msg.putHeader(this.id, new AuthHeader(this.auth_token));
        }
        return this.down_prot.down(msg);
    }

    protected boolean needsAuthentication(Message msg, GMS.GmsHeader hdr) {
        switch (hdr.getType()) {
            case 1: 
            case 6: 
            case 11: {
                return true;
            }
            case 2: {
                JoinRsp jr = AUTH.getJoinResponse(msg);
                if (jr.getFailReason() != null) {
                    return false;
                }
            }
            case 7: 
            case 8: {
                return this.authenticate_coord;
            }
        }
        return false;
    }

    protected boolean handleAuthHeader(GMS.GmsHeader gms_hdr, AuthHeader auth_hdr, Message msg) {
        if (this.needsAuthentication(msg, gms_hdr)) {
            if (this.auth_token.authenticate(auth_hdr.getToken(), msg)) {
                return true;
            }
            this.log.warn("%s: failed to validate AuthHeader (token: %s) from %s; dropping message and sending rejection message", this.local_addr, this.auth_token.getClass().getSimpleName(), msg.src());
            this.sendRejectionMessage(gms_hdr.getType(), msg.getSrc(), "authentication failed");
            return false;
        }
        return true;
    }

    protected void sendRejectionMessage(byte type2, Address dest, String error_msg) {
        switch (type2) {
            case 1: 
            case 11: {
                this.sendJoinRejectionMessage(dest, error_msg);
                break;
            }
            case 6: {
                this.sendMergeRejectionMessage(dest);
            }
        }
    }

    protected void sendJoinRejectionMessage(Address dest, String error_msg) {
        if (dest == null) {
            return;
        }
        JoinRsp joinRes = new JoinRsp(error_msg);
        Message msg = new BytesMessage(dest).putHeader(GMS_ID, new GMS.GmsHeader(2)).setArray(GMS.marshal(joinRes));
        this.down_prot.down(msg);
    }

    protected void sendMergeRejectionMessage(Address dest) {
        GMS.GmsHeader hdr = new GMS.GmsHeader(7).setMergeRejected(true);
        Message msg = new EmptyMessage(dest).setFlag(Message.Flag.OOB).putHeader(GMS_ID, hdr);
        if (this.authenticate_coord) {
            msg.putHeader(this.id, new AuthHeader(this.auth_token));
        }
        this.log.debug("merge response=%s", hdr);
        this.down_prot.down(msg);
    }

    protected static GMS.GmsHeader getGMSHeader(Message msg) {
        Object hdr = msg.getHeader(GMS_ID);
        if (hdr instanceof GMS.GmsHeader) {
            return (GMS.GmsHeader)hdr;
        }
        return null;
    }

    protected static JoinRsp getJoinResponse(Message msg) {
        byte[] buf = msg.getArray();
        try {
            return buf != null ? Util.streamableFromBuffer(JoinRsp::new, buf, msg.getOffset(), msg.getLength()) : null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

