/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;

@MBean(description="Discards messages")
public class DISCARD
extends Protocol {
    @Property
    protected double up;
    @Property
    protected double down;
    @Property(description="If discard_all is true, still sends messages to self")
    protected boolean excludeItself = true;
    @ManagedAttribute(description="Number of dropped down messages", name="dropped_down_messages")
    protected int num_down;
    @ManagedAttribute(description="Number of dropped up messages", name="dropped_up_messages")
    protected int num_up;
    protected final Set<Address> ignoredMembers = Collections.synchronizedSet(new HashSet());
    protected final Collection<Address> members = Collections.synchronizedList(new ArrayList());
    @Property(description="Drops all messages (up or down) if true")
    protected boolean discard_all;
    @Property(description="Number of subsequent unicasts to drop in the down direction")
    protected int drop_down_unicasts;
    @Property(description="Number of subsequent multicasts to drop in the down direction")
    protected int drop_down_multicasts;
    protected DiscardDialog discard_dialog;
    @Property(name="gui", description="use a GUI or not")
    protected boolean use_gui;

    @ManagedAttribute(description="The set of ignored members")
    public String getIgnoredMembers() {
        return this.ignoredMembers.toString();
    }

    public boolean discardAll() {
        return this.discard_all;
    }

    public DISCARD discardAll(boolean discard_all) {
        this.discard_all = discard_all;
        return this;
    }

    public boolean excludeItself() {
        return this.excludeItself;
    }

    public DISCARD setAddress(Address localAddress) {
        super.setAddress(localAddress);
        if (this.discard_dialog != null) {
            this.discard_dialog.setTitle(localAddress != null ? localAddress.toString() : "n/a");
        }
        return this;
    }

    public DISCARD excludeItself(boolean excludeItself) {
        this.excludeItself = excludeItself;
        return this;
    }

    public double getUpDiscardRate() {
        return this.up;
    }

    public DISCARD setUpDiscardRate(double up2) {
        this.up = up2;
        return this;
    }

    public double getDownDiscardRate() {
        return this.down;
    }

    public DISCARD setDownDiscardRate(double down2) {
        this.down = down2;
        return this;
    }

    public int getDropDownUnicasts() {
        return this.drop_down_unicasts;
    }

    public DISCARD dropDownUnicasts(int drop_down_unicasts) {
        this.drop_down_unicasts = drop_down_unicasts;
        return this;
    }

    public int dropDownMulticasts() {
        return this.drop_down_multicasts;
    }

    public DISCARD dropDownMulticasts(int drop_down_multicasts) {
        this.drop_down_multicasts = drop_down_multicasts;
        return this;
    }

    public DISCARD addIgnoreMember(Address sender) {
        this.ignoredMembers.add(sender);
        return this;
    }

    public DISCARD addIgnoredMembers(Address ... senders) {
        this.ignoredMembers.addAll(Arrays.asList(senders));
        return this;
    }

    public DISCARD removeIgnoredMember(Address member) {
        this.ignoredMembers.remove(member);
        return this;
    }

    public DISCARD resetIgnoredMembers() {
        this.ignoredMembers.clear();
        return this;
    }

    @ManagedOperation
    public void startGui() {
        if (this.discard_dialog == null) {
            this.discard_dialog = new DiscardDialog();
            this.discard_dialog.init();
            this.discard_dialog.setTitle(this.local_addr != null ? this.local_addr.toString() : "n/a");
            this.discard_dialog.handleView(this.members);
        }
    }

    @ManagedOperation
    public void stopGui() {
        if (this.discard_dialog != null) {
            this.discard_dialog.dispose();
        }
        this.discard_dialog = null;
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (this.use_gui) {
            this.discard_dialog = new DiscardDialog();
            this.discard_dialog.init();
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.discard_dialog != null) {
            this.discard_dialog.dispose();
        }
    }

    @Override
    public Object up(Message msg) {
        if (this.shouldDropUpMessage(msg, msg.getSrc())) {
            return null;
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            if (msg == null || !this.shouldDropUpMessage(msg, msg.getSrc())) continue;
            it.remove();
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                View view = (View)evt.getArg();
                List<Address> mbrs = view.getMembers();
                this.members.clear();
                this.members.addAll(mbrs);
                if (this.discard_dialog == null) break;
                this.discard_dialog.handleView(mbrs);
                break;
            }
            case 109: {
                if (!this.discard_all) break;
                return null;
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object down(Message msg) {
        double r;
        boolean multicast;
        Address dest = msg.getDest();
        boolean bl = multicast = dest == null;
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
        if (this.discard_all) {
            if (this.excludeItself) {
                if (dest == null) {
                    this.up_prot.up(msg);
                    return null;
                }
                if (Objects.equals(dest, this.local_addr)) {
                    this.down_prot.down(msg);
                }
            }
            return null;
        }
        if (!multicast && this.drop_down_unicasts > 0) {
            this.drop_down_unicasts = Math.max(0, this.drop_down_unicasts - 1);
            return null;
        }
        if (multicast && this.drop_down_multicasts > 0) {
            this.drop_down_multicasts = Math.max(0, this.drop_down_multicasts - 1);
            return null;
        }
        if (this.down > 0.0 && (r = Math.random()) < this.down) {
            if (this.excludeItself && dest != null && dest.equals(this.local_addr)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("excluding itself");
                }
            } else {
                this.log.trace("dropping message");
                ++this.num_down;
                return null;
            }
        }
        return this.down_prot.down(msg);
    }

    protected boolean shouldDropUpMessage(Message msg, Address sender) {
        double r;
        if (this.discard_all && !sender.equals(this.local_addr)) {
            return true;
        }
        if (this.ignoredMembers.contains(sender)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": dropping message from " + sender);
            }
            ++this.num_up;
            return true;
        }
        if (this.up > 0.0 && (r = Math.random()) < this.up) {
            if (this.excludeItself && sender.equals(this.local_addr)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("excluding myself");
                }
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace(this.local_addr + ": dropping message from " + sender);
                }
                ++this.num_up;
                return true;
            }
        }
        return false;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_up = 0;
        this.num_down = 0;
    }

    private static class MyCheckBox
    extends JCheckBox {
        final Address mbr;

        public MyCheckBox(String name, Address member) {
            super(name);
            this.mbr = member;
        }

        @Override
        public String toString() {
            return super.toString() + " [mbr=" + this.mbr + "]";
        }
    }

    protected class DiscardDialog
    extends JFrame
    implements ActionListener {
        private final JButton start_discarding_button = new JButton("start discarding");
        private final JButton stop_discarding_button = new JButton("stop discarding");
        private final JPanel checkboxes = new JPanel();

        protected DiscardDialog() {
        }

        void init() {
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.checkboxes.setLayout(new BoxLayout(this.checkboxes, 1));
            this.getContentPane().add(this.start_discarding_button);
            this.getContentPane().add(this.stop_discarding_button);
            this.start_discarding_button.addActionListener(this);
            this.stop_discarding_button.addActionListener(this);
            this.getContentPane().add(this.checkboxes);
            this.pack();
            this.setVisible(true);
            this.setTitle(DISCARD.this.local_addr != null ? DISCARD.this.local_addr.toString() : "n/a");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command2 = e.getActionCommand();
            if (command2.startsWith("start")) {
                DISCARD.this.discard_all = true;
            } else if (command2.startsWith("stop")) {
                Component[] comps;
                DISCARD.this.discard_all = false;
                for (Component c : comps = this.checkboxes.getComponents()) {
                    if (!(c instanceof JCheckBox)) continue;
                    ((JCheckBox)c).setSelected(false);
                }
                DISCARD.this.ignoredMembers.clear();
            }
        }

        void handleView(Collection<Address> mbrs) {
            this.checkboxes.removeAll();
            for (Address addr : mbrs) {
                MyCheckBox box = new MyCheckBox("discard traffic from " + addr, addr);
                box.addActionListener(e -> {
                    if (box.isSelected()) {
                        DISCARD.this.ignoredMembers.add(addr);
                    } else {
                        DISCARD.this.ignoredMembers.remove(addr);
                    }
                });
                this.checkboxes.add(box);
            }
            for (Component comp : this.checkboxes.getComponents()) {
                MyCheckBox box = (MyCheckBox)comp;
                if (!DISCARD.this.ignoredMembers.contains(box.mbr)) continue;
                box.setSelected(true);
            }
            this.pack();
        }
    }
}

