/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.BytesMessage;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.locking.AwaitInfo;
import org.jgroups.blocks.locking.LockInfo;
import org.jgroups.blocks.locking.LockNotification;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Bits;
import org.jgroups.util.ByteArray;
import org.jgroups.util.Owner;
import org.jgroups.util.Streamable;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

@MBean(description="Based class for locking functionality")
public abstract class Locking
extends Protocol {
    @Property(description="bypasses message bundling if set")
    protected boolean bypass_bundling = true;
    @Property(description="Number of locks to be used for lock striping (for synchronized access to the server_lock entries)")
    protected int lock_striping_size = 10;
    @Property(description="By default, a lock owner is address:thread-id. If false, we only use the node's address. See https://issues.jboss.org/browse/JGRP-1886 for details")
    protected boolean use_thread_id_for_lock_owner = true;
    protected View view;
    protected final ConcurrentMap<String, ServerLock> server_locks = Util.createConcurrentMap(20);
    protected Lock[] lock_stripes;
    protected final ClientLockTable client_lock_table = new ClientLockTable();
    protected final Set<LockNotification> lock_listeners = new CopyOnWriteArraySet<LockNotification>();
    protected static final AtomicInteger current_lock_id = new AtomicInteger(1);

    public boolean bypassBundling() {
        return this.bypass_bundling;
    }

    public Locking bypassBundling(boolean b) {
        this.bypass_bundling = b;
        return this;
    }

    public int getLockStripingSize() {
        return this.lock_striping_size;
    }

    public Locking setLockStripingSize(int l) {
        this.lock_striping_size = l;
        return this;
    }

    public boolean useThreadIdForLockOwner() {
        return this.use_thread_id_for_lock_owner;
    }

    public Locking useThreadIdForLockOwner(boolean u) {
        this.use_thread_id_for_lock_owner = u;
        return this;
    }

    public void addLockListener(LockNotification listener) {
        if (listener != null) {
            this.lock_listeners.add(listener);
        }
    }

    public void removeLockListener(LockNotification listener) {
        if (listener != null) {
            this.lock_listeners.remove(listener);
        }
    }

    @ManagedAttribute
    public String getView() {
        return this.view != null ? this.view.toString() : null;
    }

    @ManagedAttribute(description="Number of server locks (only on coord)")
    public int getNumServerLocks() {
        return this.server_locks.size();
    }

    @ManagedAttribute(description="Number of client locks")
    public int getNumClientLocks() {
        return this.client_lock_table.numLocks();
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.lock_stripes = new Lock[this.lock_striping_size];
        for (int i = 0; i < this.lock_stripes.length; ++i) {
            this.lock_stripes[i] = new ReentrantLock();
        }
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 95: {
                LockInfo info = (LockInfo)evt.getArg();
                ClientLock lock = this.getLock(info.getName());
                if (!info.isTrylock()) {
                    if (info.isLockInterruptibly()) {
                        try {
                            lock.lockInterruptibly();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    } else {
                        lock.lock();
                    }
                } else if (info.isUseTimeout()) {
                    try {
                        return lock.tryLock(info.getTimeout(), info.getTimeUnit());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    return lock.tryLock();
                }
                return null;
            }
            case 96: {
                LockInfo info = (LockInfo)evt.getArg();
                ClientLock lock = this.getLock(info.getName(), false);
                if (lock != null) {
                    lock.unlock();
                }
                return null;
            }
            case 97: {
                this.unlockAll();
                return null;
            }
            case 113: {
                this.unlockForce((String)evt.arg());
                break;
            }
            case 98: {
                LockInfo info = (LockInfo)evt.getArg();
                ClientLock lock = this.getLock(info.getName(), false);
                if (lock == null || !lock.acquired) {
                    throw new IllegalMonitorStateException();
                }
                Condition condition = lock.newCondition();
                if (info.isUseTimeout()) {
                    try {
                        return condition.awaitNanos(info.getTimeUnit().toNanos(info.getTimeout()));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } else if (info.isLockInterruptibly()) {
                    try {
                        condition.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    condition.awaitUninterruptibly();
                }
                return null;
            }
            case 99: {
                AwaitInfo awaitInfo = (AwaitInfo)evt.getArg();
                ClientLock lock = this.getLock(awaitInfo.getName(), false);
                if (lock == null || !lock.acquired) {
                    throw new IllegalMonitorStateException();
                }
                this.sendSignalConditionRequest(awaitInfo.getName(), awaitInfo.isAll());
                return null;
            }
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object up(Message msg) {
        LockingHeader hdr = (LockingHeader)msg.getHeader(this.id);
        if (hdr == null) {
            return this.up_prot.up(msg);
        }
        Request req = null;
        try {
            req = Util.streamableFromBuffer(Request::new, msg.getArray(), msg.getOffset(), msg.getLength()).sender(msg.getSrc());
        }
        catch (Exception ex) {
            this.log.error("%s: failed deserializing request", this.local_addr, ex);
            return null;
        }
        if (req.type != Type.LOCK_INFO_REQ && req.type != Type.LOCK_INFO_RSP && req.type != Type.LOCK_REVOKED && null != this.view && !this.view.containsMember(msg.getSrc())) {
            this.log.error("%s: received request from '%s' but member is not present in the current view - ignoring request", this.local_addr, msg.getSrc());
            return null;
        }
        this.requestReceived(req);
        return null;
    }

    protected void requestReceived(Request req) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("%s <-- %s: %s", this.local_addr, req.sender, req);
        }
        this.handleRequest(req);
    }

    protected void handleRequest(Request req) {
        if (req == null) {
            return;
        }
        switch (req.type) {
            case GRANT_LOCK: 
            case RELEASE_LOCK: {
                this.handleLockRequest(req);
                break;
            }
            case LOCK_GRANTED: {
                this.handleLockGrantedResponse(req.lock_name, req.lock_id, req.owner);
                break;
            }
            case RELEASE_LOCK_OK: {
                this.handleLockReleasedResponse(req.lock_name, req.lock_id, req.owner);
                break;
            }
            case LOCK_DENIED: {
                this.handleLockDeniedResponse(req.lock_name, req.lock_id, req.owner);
                break;
            }
            case CREATE_LOCK: {
                this.handleCreateLockRequest(req.lock_name, req.owner);
                break;
            }
            case DELETE_LOCK: {
                this.handleDeleteLockRequest(req.lock_name);
                break;
            }
            case COND_SIG: 
            case COND_SIG_ALL: {
                this.handleSignalRequest(req);
                break;
            }
            case LOCK_AWAIT: {
                this.handleAwaitRequest(req.lock_name, req.owner);
                this.handleLockRequest(req);
                break;
            }
            case DELETE_LOCK_AWAIT: {
                this.handleDeleteAwaitRequest(req.lock_name, req.owner);
                break;
            }
            case SIG_RET: {
                this.handleSignalResponse(req.lock_name, req.owner);
                break;
            }
            case CREATE_AWAITER: {
                this.handleCreateAwaitingRequest(req.lock_name, req.owner);
                break;
            }
            case DELETE_AWAITER: {
                this.handleDeleteAwaitingRequest(req.lock_name, req.owner);
                break;
            }
            case LOCK_INFO_REQ: {
                this.handleLockInfoRequest(req.sender);
                break;
            }
            case LOCK_INFO_RSP: {
                this.handleLockInfoResponse(req.sender, req);
                break;
            }
            case LOCK_REVOKED: {
                this.handleLockRevoked(req);
                break;
            }
            default: {
                this.log.error("%s: request of type %s not known", new Object[]{this.local_addr, req.type});
            }
        }
    }

    protected ClientLock getLock(String name) {
        return this.client_lock_table.getLock(name, this.getOwner(), true);
    }

    protected ClientLock getLock(String name, boolean create_if_absent) {
        return this.client_lock_table.getLock(name, this.getOwner(), create_if_absent);
    }

    @ManagedOperation(description="Unlocks all currently held locks")
    public void unlockAll() {
        this.client_lock_table.unlockAll();
    }

    @ManagedOperation(description="Forcefully removes the client lock")
    public void unlockForce(String lock_name) {
        this.client_lock_table.unlockForce(lock_name);
    }

    @ManagedOperation(description="Dumps all locks")
    public String printLocks() {
        String client_locks;
        StringBuilder sb = new StringBuilder();
        Collection values2 = this.server_locks.values();
        if (values2 != null && !values2.isEmpty()) {
            sb.append("server locks: ");
            for (ServerLock sl : this.server_locks.values()) {
                sb.append(sl).append("\n");
            }
        }
        if ((client_locks = this.client_lock_table.printLocks()) != null && !client_locks.isEmpty()) {
            sb.append("my locks: ").append(this.client_lock_table.printLocks());
        }
        return sb.toString();
    }

    @ManagedOperation(description="Dumps all server locks")
    public Object printServerLocks() {
        return this.server_locks.values().stream().map(ServerLock::toString).collect(Collectors.joining(", "));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleView(View view) {
        this.view = view;
        this.log.debug("%s: view=%s", this.local_addr, view);
        List<Address> members2 = view.getMembers();
        ArrayList<Response> responses = new ArrayList<Response>();
        for (Map.Entry entry : this.server_locks.entrySet()) {
            String lock_name = (String)entry.getKey();
            ServerLock server_lock = (ServerLock)entry.getValue();
            Lock lock = this._getLock(lock_name);
            lock.lock();
            try {
                Response rsp = server_lock.handleView(members2);
                if (rsp != null) {
                    responses.add(rsp);
                }
                if (!server_lock.isEmpty() || server_lock.owner != null || !server_lock.condition.queue.isEmpty()) continue;
                this.server_locks.remove(lock_name);
            }
            finally {
                lock.unlock();
            }
        }
        for (Response rsp : responses) {
            this.sendLockResponse(rsp.type, rsp.owner, rsp.lock_name, rsp.lock_id);
        }
    }

    protected ClientLock createLock(String lock_name, Owner owner) {
        return new ClientLock(lock_name, owner);
    }

    protected Lock _getLock(String lock_name) {
        int index = lock_name != null ? Math.abs(lock_name.hashCode() % this.lock_stripes.length) : 0;
        return this.lock_stripes[index];
    }

    protected Owner getOwner() {
        return new Owner(this.local_addr, Thread.currentThread().getId());
    }

    protected abstract void sendGrantLockRequest(String var1, int var2, Owner var3, long var4, boolean var6);

    protected abstract void sendReleaseLockRequest(String var1, int var2, Owner var3);

    protected abstract void sendAwaitConditionRequest(String var1, Owner var2);

    protected abstract void sendSignalConditionRequest(String var1, boolean var2);

    protected abstract void sendDeleteAwaitConditionRequest(String var1, Owner var2);

    protected void sendRequest(Address dest, Type type2, String lock_name, Owner owner, long timeout2, boolean is_trylock) {
        this.send(dest, new Request(type2, lock_name, owner, timeout2, is_trylock));
    }

    protected void sendRequest(Address dest, Type type2, String lock_name, int lock_id, Owner owner, long timeout2, boolean is_trylock) {
        this.send(dest, new Request(type2, lock_name, owner, timeout2, is_trylock).lockId(lock_id));
    }

    protected void sendLockResponse(Type type2, Owner dest, String lock_name, int lock_id) {
        this.send(dest.getAddress(), new Request(type2, lock_name, dest, 0L).lockId(lock_id));
    }

    protected void sendSignalResponse(Owner dest, String lock_name) {
        this.send(dest.getAddress(), new Request(Type.SIG_RET, lock_name, dest, 0L));
    }

    protected void send(Address dest, Request req) {
        ByteArray array = null;
        try {
            array = Util.streamableToBuffer(req);
        }
        catch (Exception e) {
            this.log.warn("%s: failed serializing request: %s", this.local_addr, e);
        }
        Message msg = new BytesMessage(dest, array).putHeader(this.id, new LockingHeader());
        if (this.bypass_bundling) {
            msg.setFlag(Message.Flag.DONT_BUNDLE);
        }
        this.log.trace("%s --> %s: %s", this.local_addr, dest == null ? "ALL" : dest, req);
        try {
            this.down_prot.down(msg);
        }
        catch (Exception ex) {
            this.log.error("%s: failed sending %s request: %s", new Object[]{this.local_addr, req.type, ex});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLockRequest(Request req) {
        Response rsp = null;
        Lock lock = this._getLock(req.lock_name);
        lock.lock();
        try {
            ServerLock server_lock = (ServerLock)this.server_locks.get(req.lock_name);
            if (server_lock == null) {
                server_lock = new ServerLock(req.lock_name);
                ServerLock tmp = this.server_locks.putIfAbsent(req.lock_name, server_lock);
                if (tmp != null) {
                    server_lock = tmp;
                } else {
                    this.notifyLockCreated(req.lock_name);
                }
            }
            rsp = server_lock.handleRequest(req);
            if (server_lock.isEmpty() && server_lock.owner == null && server_lock.condition.queue.isEmpty()) {
                this.server_locks.remove(req.lock_name);
            }
        }
        finally {
            lock.unlock();
        }
        if (rsp != null) {
            this.sendLockResponse(rsp.type, rsp.owner, rsp.lock_name, rsp.lock_id);
        }
    }

    protected void handleLockGrantedResponse(String lock_name, int lock_id, Owner owner) {
        ClientLock lock = this.client_lock_table.getLock(lock_name, owner, false);
        if (lock != null) {
            lock.handleLockGrantedResponse(lock_id);
        }
    }

    protected void handleLockReleasedResponse(String lock_name, int lock_id, Owner owner) {
        ClientLock lock = this.client_lock_table.getLock(lock_name, owner, false);
        if (lock != null) {
            lock.handleLockReleasedResponse(lock_id);
        }
    }

    protected void handleLockDeniedResponse(String lock_name, int lock_id, Owner owner) {
        ClientLock lock = this.client_lock_table.getLock(lock_name, owner, false);
        if (lock != null) {
            lock.lockDenied(lock_id);
        }
    }

    protected void handleLockInfoRequest(Address requester) {
    }

    protected void handleLockInfoResponse(Address sender, Request rsp) {
    }

    protected void handleLockRevoked(Request rsp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAwaitRequest(String lock_name, Owner owner) {
        Lock lock = this._getLock(lock_name);
        lock.lock();
        try {
            ServerLock server_lock = (ServerLock)this.server_locks.get(lock_name);
            if (server_lock != null) {
                server_lock.condition.addWaiter(owner);
            } else {
                this.log.error(Util.getMessage("ConditionAwaitWasReceivedButLockWasNotCreatedWaiterMayBlockForever"));
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDeleteAwaitRequest(String lock_name, Owner owner) {
        Lock lock = this._getLock(lock_name);
        lock.lock();
        try {
            ServerLock server_lock = (ServerLock)this.server_locks.get(lock_name);
            if (server_lock != null) {
                server_lock.condition.removeWaiter(owner);
            } else {
                this.log.error(Util.getMessage("ConditionAwaitDeleteWasReceivedButLockWasGone"));
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected void handleSignalResponse(String lock_name, Owner owner) {
        ClientLock lock = this.client_lock_table.getLock(lock_name, owner, false);
        if (lock != null) {
            lock.condition.signaled();
        } else {
            this.log.error(Util.getMessage("ConditionResponseWasClientLockWasNotPresentIgnoredSignal"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSignalRequest(Request req) {
        Response rsp = null;
        Lock lock = this._getLock(req.lock_name);
        lock.lock();
        try {
            ServerLock server_lock = (ServerLock)this.server_locks.get(req.lock_name);
            if (server_lock != null) {
                rsp = server_lock.handleRequest(req);
            } else {
                this.log.error(Util.getMessage("ConditionSignalWasReceivedButLockWasNotCreatedCouldnTNotifyAnyone"));
            }
        }
        finally {
            lock.unlock();
        }
        if (rsp != null) {
            this.sendLockResponse(rsp.type, rsp.owner, rsp.lock_name, rsp.lock_id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCreateLockRequest(String lock_name, Owner owner) {
        Lock lock = this._getLock(lock_name);
        lock.lock();
        try {
            this.server_locks.put(lock_name, new ServerLock(lock_name, owner));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDeleteLockRequest(String lock_name) {
        Lock lock = this._getLock(lock_name);
        lock.lock();
        try {
            ServerLock server_lock = (ServerLock)this.server_locks.get(lock_name);
            if (server_lock == null) {
                return;
            }
            if (server_lock.condition.queue.isEmpty()) {
                this.server_locks.remove(lock_name);
            } else {
                server_lock.owner = null;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCreateAwaitingRequest(String lock_name, Owner owner) {
        Lock lock = this._getLock(lock_name);
        lock.lock();
        try {
            ServerLock tmp;
            ServerLock server_lock = (ServerLock)this.server_locks.get(lock_name);
            if (server_lock == null && (tmp = this.server_locks.putIfAbsent(lock_name, server_lock = new ServerLock(lock_name))) != null) {
                server_lock = tmp;
            }
            server_lock.condition.queue.add(owner);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDeleteAwaitingRequest(String lock_name, Owner owner) {
        Lock lock = this._getLock(lock_name);
        lock.lock();
        try {
            ServerLock server_lock = (ServerLock)this.server_locks.get(lock_name);
            if (server_lock != null) {
                server_lock.condition.queue.remove(owner);
                if (server_lock.condition.queue.isEmpty() && server_lock.owner == null) {
                    this.server_locks.remove(lock_name);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected void notifyLockCreated(String lock_name) {
        for (LockNotification listener : this.lock_listeners) {
            try {
                listener.lockCreated(lock_name);
            }
            catch (Throwable t) {
                this.log.error("%s: failed notifying %s: %s", this.local_addr, listener, t.toString());
            }
        }
    }

    protected void notifyLockDeleted(String lock_name) {
        for (LockNotification listener : this.lock_listeners) {
            try {
                listener.lockDeleted(lock_name);
            }
            catch (Throwable t) {
                this.log.error("%s: failed notifying %s: %s", this.local_addr, listener, t.toString());
            }
        }
    }

    protected void notifyLockRevoked(String lock_name, Owner current_owner) {
        for (LockNotification listener : this.lock_listeners) {
            try {
                listener.lockRevoked(lock_name, current_owner);
            }
            catch (Throwable t) {
                this.log.error("%s: failed notifying %s: %s", this.local_addr, listener, t.toString());
            }
        }
    }

    protected void notifyLocked(String lock_name, Owner owner) {
        for (LockNotification listener : this.lock_listeners) {
            try {
                listener.locked(lock_name, owner);
            }
            catch (Throwable t) {
                this.log.error("%s: failed notifying %s: %s", this.local_addr, listener, t.toString());
            }
        }
    }

    protected void notifyUnlocked(String lock_name, Owner owner) {
        for (LockNotification listener : this.lock_listeners) {
            try {
                listener.unlocked(lock_name, owner);
            }
            catch (Throwable t) {
                this.log.error("%s: failed notifying %s: %s", this.local_addr, listener, t.toString());
            }
        }
    }

    protected void notifyAwaiting(String lock_name, Owner owner) {
        for (LockNotification listener : this.lock_listeners) {
            try {
                listener.awaiting(lock_name, owner);
            }
            catch (Throwable t) {
                this.log.error("%s: failed notifying %s: %s", this.local_addr, listener, t.toString());
            }
        }
    }

    protected void notifyAwaited(String lock_name, Owner owner) {
        for (LockNotification listener : this.lock_listeners) {
            try {
                listener.awaited(lock_name, owner);
            }
            catch (Throwable t) {
                this.log.error("%s: failed notifying %s: %s", this.local_addr, listener, t.toString());
            }
        }
    }

    protected static class LockInfoResponse
    implements Streamable {
        protected List<Tuple<String, Owner>> existing_locks;
        protected List<Request> pending_requests;

        protected LockInfoResponse() {
        }

        protected LockInfoResponse add(Tuple<String, Owner> el) {
            if (this.existing_locks == null) {
                this.existing_locks = new ArrayList<Tuple<String, Owner>>();
            }
            this.existing_locks.add(el);
            return this;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            if (this.existing_locks == null) {
                out.writeInt(0);
            } else {
                out.writeInt(this.existing_locks.size());
                for (Tuple<String, Owner> t : this.existing_locks) {
                    Bits.writeString(t.getVal1(), out);
                    t.getVal2().writeTo(out);
                }
            }
            if (this.pending_requests == null) {
                out.writeInt(0);
            } else {
                out.writeInt(this.pending_requests.size());
                for (Request req : this.pending_requests) {
                    req.writeTo(out);
                }
            }
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            int i;
            int size = in.readInt();
            if (size > 0) {
                this.existing_locks = new ArrayList<Tuple<String, Owner>>(size);
                for (i = 0; i < size; ++i) {
                    String lock_name = Bits.readString(in);
                    Owner owner = new Owner();
                    owner.readFrom(in);
                    this.existing_locks.add(new Tuple<String, Owner>(lock_name, owner));
                }
            }
            if ((size = in.readInt()) > 0) {
                this.pending_requests = new ArrayList<Request>();
                for (i = 0; i < size; ++i) {
                    Request req = new Request();
                    req.readFrom(in);
                    this.pending_requests.add(req);
                }
            }
        }

        public String toString() {
            return String.format("%d locks and %d pending lock/unlock requests", this.existing_locks == null ? 0 : this.existing_locks.size(), this.pending_requests == null ? 0 : this.pending_requests.size());
        }

        public String printDetails() {
            StringBuilder sb = new StringBuilder(this.toString());
            if (this.existing_locks != null && !this.existing_locks.isEmpty()) {
                sb.append(String.format("\nlocks:\n%s", this.existing_locks.stream().map(Tuple::getVal1).collect(Collectors.joining(", "))));
            }
            if (this.pending_requests != null && !this.pending_requests.isEmpty()) {
                sb.append(String.format("\npending requests:\n%s", this.pending_requests));
            }
            return sb.toString();
        }
    }

    public static class LockingHeader
    extends Header {
        @Override
        public short getMagicId() {
            return 72;
        }

        @Override
        public Supplier<? extends Header> create() {
            return LockingHeader::new;
        }

        @Override
        public int serializedSize() {
            return 0;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        }
    }

    protected static class Response {
        protected final Type type;
        protected final Owner owner;
        protected final String lock_name;
        protected final int lock_id;

        public Response(Type type2, Owner owner, String lock_name, int lock_id) {
            this.type = type2;
            this.owner = owner;
            this.lock_name = lock_name;
            this.lock_id = lock_id;
        }
    }

    public static class Request
    implements Streamable {
        protected Type type;
        protected String lock_name;
        protected int lock_id;
        protected Owner owner;
        protected long timeout;
        protected boolean is_trylock;
        protected LockInfoResponse info_rsp;
        protected Address sender;

        public Request() {
        }

        public Request(Type type2) {
            this.type = type2;
        }

        public Request(Type type2, String lock_name, Owner owner, long timeout2) {
            this(type2);
            this.lock_name = lock_name;
            this.owner = owner;
            this.timeout = timeout2;
        }

        public Request(Type type2, String lock_name, Owner owner, long timeout2, boolean is_trylock) {
            this(type2, lock_name, owner, timeout2);
            this.is_trylock = is_trylock;
        }

        public Type getType() {
            return this.type;
        }

        public Request lockId(int lock_id) {
            this.lock_id = lock_id;
            return this;
        }

        public int lockId() {
            return this.lock_id;
        }

        public Request infoRsp(LockInfoResponse r) {
            this.info_rsp = r;
            return this;
        }

        public Address sender() {
            return this.sender;
        }

        public Request sender(Address sender) {
            this.sender = sender;
            return this;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.writeByte(this.type.ordinal());
            Bits.writeString(this.lock_name, out);
            out.writeInt(this.lock_id);
            Util.writeStreamable(this.owner, out);
            out.writeLong(this.timeout);
            out.writeBoolean(this.is_trylock);
            Util.writeStreamable(this.info_rsp, out);
            Util.writeAddress(this.sender, out);
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.type = Type.values()[in.readByte()];
            this.lock_name = Bits.readString(in);
            this.lock_id = in.readInt();
            this.owner = Util.readStreamable(Owner::new, in);
            this.timeout = in.readLong();
            this.is_trylock = in.readBoolean();
            this.info_rsp = Util.readStreamable(LockInfoResponse::new, in);
            this.sender = Util.readAddress(in);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.type.name() + "[");
            if (this.lock_name != null) {
                sb.append(this.lock_name);
            }
            if (this.lock_id > 0) {
                sb.append(", lock_id=").append(this.lock_id);
            }
            if (this.owner != null) {
                sb.append(", owner=").append(this.owner);
            }
            if (this.is_trylock) {
                sb.append(", trylock");
            }
            if (this.timeout > 0L) {
                sb.append(", timeout=").append(this.timeout);
            }
            if (this.sender != null) {
                sb.append(", sender=").append(this.sender);
            }
            sb.append("]");
            return sb.toString();
        }

        public String toStringShort() {
            StringBuilder sb = new StringBuilder();
            switch (this.type) {
                case RELEASE_LOCK: {
                    sb.append("U");
                    break;
                }
                case GRANT_LOCK: {
                    sb.append(this.is_trylock ? "TL" : "L");
                    break;
                }
                default: {
                    sb.append("N/A");
                }
            }
            sb.append("(").append(this.lock_name).append(",").append(this.owner);
            if (this.timeout > 0L) {
                sb.append(",").append(this.timeout);
            }
            if (this.info_rsp != null) {
                sb.append(", lock-info-response: ").append(this.info_rsp);
            }
            sb.append(")");
            return sb.toString();
        }
    }

    protected class ClientCondition
    implements Condition {
        protected final ClientLock lock;
        protected final AtomicBoolean signaled = new AtomicBoolean(false);
        protected volatile AtomicReference<Thread> parker = new AtomicReference();

        public ClientCondition(ClientLock lock) {
            this.lock = lock;
        }

        @Override
        public void await() throws InterruptedException {
            InterruptedException ex = null;
            try {
                this.await(true);
            }
            catch (InterruptedException e) {
                ex = e;
                throw ex;
            }
            finally {
                this.lock.lock();
                if (ex != null) {
                    Thread.interrupted();
                }
            }
        }

        @Override
        public void awaitUninterruptibly() {
            try {
                this.await(false);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.lock.lock();
            }
        }

        @Override
        public long awaitNanos(long nanosTimeout) throws InterruptedException {
            InterruptedException ex = null;
            try {
                long l = this.await(nanosTimeout);
                return l;
            }
            catch (InterruptedException e) {
                ex = e;
                throw ex;
            }
            finally {
                this.lock.lock();
                if (ex != null) {
                    Thread.interrupted();
                }
            }
        }

        @Override
        public boolean await(long time, TimeUnit unit) throws InterruptedException {
            return this.awaitNanos(unit.toNanos(time)) > 0L;
        }

        @Override
        public boolean awaitUntil(Date deadline) throws InterruptedException {
            long currentTime;
            long waitUntilTime = deadline.getTime();
            long waitTime = waitUntilTime - (currentTime = System.currentTimeMillis());
            return waitTime > 0L && this.await(waitTime, TimeUnit.MILLISECONDS);
        }

        protected void await(boolean throwInterrupt) throws InterruptedException {
            if (!this.signaled.get()) {
                this.lock.acquired = false;
                Locking.this.sendAwaitConditionRequest(this.lock.name, this.lock.owner);
                boolean interrupted = false;
                while (!this.signaled.get()) {
                    this.parker.set(Thread.currentThread());
                    LockSupport.park(this);
                    if (!Thread.interrupted()) continue;
                    if (!this.signaled.get()) {
                        Locking.this.sendDeleteAwaitConditionRequest(this.lock.name, this.lock.owner);
                        throw new InterruptedException();
                    }
                    interrupted = true;
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            this.signaled.set(false);
        }

        protected long await(long nanoSeconds) throws InterruptedException {
            long start = System.nanoTime();
            if (!this.signaled.get()) {
                long wait_nano;
                this.lock.acquired = false;
                Locking.this.sendAwaitConditionRequest(this.lock.name, this.lock.owner);
                boolean interrupted = false;
                while (!this.signaled.get() && (wait_nano = nanoSeconds - (System.nanoTime() - start)) > 0L) {
                    this.parker.set(Thread.currentThread());
                    LockSupport.parkNanos(this, wait_nano);
                    if (!Thread.interrupted()) continue;
                    if (!this.signaled.get()) {
                        Locking.this.sendDeleteAwaitConditionRequest(this.lock.name, this.lock.owner);
                        throw new InterruptedException();
                    }
                    interrupted = true;
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if (!this.signaled.getAndSet(false)) {
                Locking.this.sendDeleteAwaitConditionRequest(this.lock.name, this.lock.owner);
            }
            return nanoSeconds - (System.nanoTime() - start);
        }

        @Override
        public void signal() {
            Locking.this.sendSignalConditionRequest(this.lock.name, false);
        }

        @Override
        public void signalAll() {
            Locking.this.sendSignalConditionRequest(this.lock.name, true);
        }

        protected void signaled() {
            this.signaled.set(true);
            Thread thread2 = this.parker.getAndSet(null);
            if (thread2 != null) {
                LockSupport.unpark(thread2);
            }
        }
    }

    protected class ClientLockTable {
        protected final ConcurrentMap<String, Map<Owner, ClientLock>> table = Util.createConcurrentMap(20);
        protected final Set<ClientLock> pending_release_reqs = new ConcurrentSkipListSet<ClientLock>();

        protected ClientLockTable() {
        }

        protected int numLocks() {
            return this.table.size();
        }

        protected synchronized ClientLock getLock(String name, Owner owner, boolean create_if_absent) {
            ClientLock lock;
            Map<Owner, ClientLock> owners = (ConcurrentMap)this.table.get(name);
            if (owners == null) {
                if (!create_if_absent) {
                    return null;
                }
                owners = Util.createConcurrentMap(20);
                Map existing = this.table.putIfAbsent(name, owners);
                if (existing != null) {
                    owners = existing;
                }
            }
            if ((lock = (ClientLock)owners.get(owner)) == null) {
                if (!create_if_absent) {
                    return null;
                }
                lock = Locking.this.createLock(name, owner);
                owners.put(owner, lock);
            }
            return lock;
        }

        protected synchronized boolean removeClientLock(String lock_name, Owner owner) {
            this.pending_release_reqs.removeIf(cl -> Objects.equals(cl.name, lock_name) && Objects.equals(cl.owner, owner));
            Map owners = (Map)this.table.get(lock_name);
            if (owners != null) {
                ClientLock lock = (ClientLock)owners.remove(owner);
                if (lock != null && owners.isEmpty()) {
                    this.table.remove(lock_name);
                }
                return lock != null;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unlockAll() {
            ArrayList lock_list = new ArrayList();
            ClientLockTable clientLockTable = this;
            synchronized (clientLockTable) {
                this.table.values().forEach(map2 -> lock_list.addAll(map2.values()));
            }
            lock_list.forEach(ClientLock::unlock);
        }

        protected void unlockForce(String lock_name) {
            Map owners = (Map)this.table.get(lock_name);
            if (owners != null) {
                for (ClientLock cl2 : owners.values()) {
                    cl2._unlock(true);
                }
            }
            this.pending_release_reqs.removeIf(cl -> Objects.equals(cl.name, lock_name));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void resendPendingLockRequests() {
            String tmp;
            ArrayList pending_lock_reqs = new ArrayList();
            ClientLockTable clientLockTable = this;
            synchronized (clientLockTable) {
                if (!this.table.isEmpty()) {
                    this.table.values().forEach(map2 -> map2.values().stream().filter(lock -> !lock.acquired && !lock.denied).forEach(pending_lock_reqs::add));
                }
            }
            if (!pending_lock_reqs.isEmpty()) {
                if (Locking.this.log.isTraceEnabled()) {
                    tmp = pending_lock_reqs.stream().map(ClientLock::toString).collect(Collectors.joining(", "));
                    Locking.this.log.trace("%s: resending pending lock requests: %s", Locking.this.local_addr, tmp);
                }
                pending_lock_reqs.forEach(l -> Locking.this.sendGrantLockRequest(l.name, l.lock_id, l.owner, l.timeout, l.is_trylock));
            }
            if (!this.pending_release_reqs.isEmpty()) {
                if (Locking.this.log.isTraceEnabled()) {
                    tmp = this.pending_release_reqs.stream().map(ClientLock::toString).collect(Collectors.joining(", "));
                    Locking.this.log.trace("%s: resending pending unlock requests: %s", Locking.this.local_addr, tmp);
                }
                this.pending_release_reqs.forEach(cl -> Locking.this.sendReleaseLockRequest(cl.name, cl.lock_id, cl.owner));
            }
        }

        protected synchronized Collection<Map<Owner, ClientLock>> values() {
            return this.table.values();
        }

        protected synchronized List<Tuple<String, Owner>> getLockInfo() {
            ArrayList<Tuple<String, Owner>> l = new ArrayList<Tuple<String, Owner>>();
            this.table.forEach((k, v) -> v.forEach((owner, cl) -> {
                if (cl.acquired && !cl.denied) {
                    l.add(new Tuple<String, Owner>((String)k, (Owner)owner));
                }
            }));
            return l;
        }

        protected synchronized List<Request> getPendingRequests(Address sender) {
            ArrayList<Request> list = new ArrayList<Request>();
            this.table.forEach((k, v) -> v.forEach((owner, cl) -> {
                if (!cl.acquired && !cl.denied) {
                    Request req = new Request(Type.GRANT_LOCK, cl.name, (Owner)owner, cl.timeout, cl.is_trylock).lockId(cl.lock_id);
                    list.add(req);
                }
            }));
            this.pending_release_reqs.forEach(cl -> {
                if (cl.acquired && !cl.denied) {
                    Request req = new Request(Type.RELEASE_LOCK, cl.name, cl.owner, cl.timeout, cl.is_trylock).lockId(cl.lock_id).sender(sender);
                    list.add(req);
                }
            });
            return list;
        }

        public String printLocks() {
            return this.table.values().stream().map(Map::values).flatMap(Collection::stream).filter(cl -> cl.isHeld() && Objects.nonNull(cl.name)).map(cl -> cl.name).collect(Collectors.joining(", "));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            boolean first_element = true;
            for (Map.Entry entry : this.table.entrySet()) {
                if (first_element) {
                    first_element = false;
                } else {
                    sb.append(", ");
                }
                sb.append((String)entry.getKey()).append(" (");
                Map owners = (Map)entry.getValue();
                boolean first2 = true;
                for (Map.Entry entry2 : owners.entrySet()) {
                    if (first2) {
                        first2 = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(entry2.getKey());
                    ClientLock cl = (ClientLock)entry2.getValue();
                    if (cl.acquired && !cl.denied) continue;
                    sb.append(", unlocked");
                }
                sb.append(")");
            }
            return sb.toString();
        }

        public void addToPendingReleaseRequests(ClientLock cl) {
            if (cl != null) {
                this.pending_release_reqs.add(cl);
            }
        }

        public void removeFromPendingReleaseRequests(ClientLock cl) {
            if (cl != null) {
                this.pending_release_reqs.remove(cl);
            }
        }
    }

    protected class ClientLock
    implements Lock,
    Comparable<ClientLock> {
        protected final String name;
        protected Owner owner;
        protected volatile boolean acquired;
        protected volatile boolean denied;
        protected volatile boolean is_trylock;
        protected long timeout;
        protected final ClientCondition condition;
        protected final int lock_id = current_lock_id.getAndIncrement();

        public ClientLock(String name) {
            this.name = name;
            this.condition = new ClientCondition(this);
        }

        public ClientLock(String name, Owner owner) {
            this(name);
            this.owner = owner;
        }

        public boolean isHeld() {
            return this.acquired && !this.denied;
        }

        @Override
        public void lock() {
            try {
                this.acquire(false);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.acquire(true);
        }

        @Override
        public boolean tryLock() {
            try {
                return this.acquireTryLock(0L, false);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return this.acquireTryLock(TimeUnit.MILLISECONDS.convert(time, unit), true);
        }

        @Override
        public synchronized void unlock() {
            this._unlock(false);
        }

        @Override
        public Condition newCondition() {
            return this.condition;
        }

        public String toString() {
            return String.format("%s (id=%d, locked=%b, owner=%s)", this.name, this.lock_id, this.acquired, this.owner != null ? this.owner : "n/a");
        }

        protected synchronized void lockGranted(int lock_id) {
            if (this.lock_id != lock_id) {
                Locking.this.log.error(Util.getMessage("DiscardedLOCKGRANTEDResponseWithLockId") + lock_id + ", my lock-id=" + this.lock_id);
                return;
            }
            this.acquired = true;
            this.notifyAll();
        }

        protected synchronized void lockDenied(int lock_id) {
            if (this.lock_id != lock_id) {
                Locking.this.log.error(Util.getMessage("DiscardedLOCKDENIEDResponseWithLockId") + lock_id + ", my lock_id=" + this.lock_id);
                return;
            }
            this.denied = true;
            this.notifyAll();
        }

        protected void handleLockGrantedResponse(int lock_id) {
            this.lockGranted(lock_id);
        }

        protected void handleLockReleasedResponse(int lock_id) {
            if (this.lock_id != lock_id) {
                Locking.this.log.error(Util.getMessage("DiscardedLOCKGRANTEDResponseWithLockId") + lock_id + ", my lock-id=" + this.lock_id);
                return;
            }
            this._unlockOK();
        }

        protected synchronized void acquire(boolean throwInterrupt) throws InterruptedException {
            if (this.acquired) {
                return;
            }
            if (throwInterrupt && Thread.interrupted()) {
                throw new InterruptedException();
            }
            this.owner = Locking.this.getOwner();
            Locking.this.sendGrantLockRequest(this.name, this.lock_id, this.owner, 0L, false);
            boolean interrupted = false;
            while (!this.acquired) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    if (throwInterrupt && !this.acquired) {
                        this._unlock(true);
                        throw e;
                    }
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }

        protected synchronized void _unlock(boolean force) {
            if (!(this.acquired || this.denied || force)) {
                return;
            }
            this.timeout = 0L;
            this.is_trylock = false;
            if (!this.denied) {
                if (!force) {
                    Locking.this.client_lock_table.addToPendingReleaseRequests(this);
                }
                Locking.this.sendReleaseLockRequest(this.name, this.lock_id, this.owner);
                if (force && Locking.this.client_lock_table.removeClientLock(this.name, this.owner)) {
                    Locking.this.notifyLockDeleted(this.name);
                }
                if (!force) {
                    long time_left = 10000L;
                    while (this.acquired || this.denied) {
                        long start = System.currentTimeMillis();
                        try {
                            this.wait(time_left);
                        }
                        catch (InterruptedException ie) {
                            break;
                        }
                        long duration = System.currentTimeMillis() - start;
                        if (duration > 0L) {
                            time_left -= duration;
                        }
                        if (time_left > 0L) continue;
                        Locking.this.log.warn("%s: timeout waiting for RELEASE_LOCK_OK response for lock %s", Locking.this.local_addr, this);
                        break;
                    }
                }
            } else {
                this._unlockOK();
            }
        }

        protected synchronized void _unlockOK() {
            this.denied = false;
            this.acquired = false;
            this.notifyAll();
            if (Locking.this.client_lock_table.removeClientLock(this.name, this.owner)) {
                Locking.this.notifyLockDeleted(this.name);
            }
            this.owner = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized boolean acquireTryLock(long timeout2, boolean use_timeout) throws InterruptedException {
            boolean retval;
            if (this.denied) {
                return false;
            }
            if (!this.acquired) {
                if (use_timeout && Thread.interrupted()) {
                    throw new InterruptedException();
                }
                this.is_trylock = true;
                this.timeout = timeout2;
                if (this.owner == null) {
                    this.owner = Locking.this.getOwner();
                }
                Locking.this.sendGrantLockRequest(this.name, this.lock_id, this.owner, timeout2, true);
                boolean interrupted = false;
                block8: while (!this.acquired && !this.denied) {
                    if (use_timeout) {
                        long timeout_ns;
                        long wait_time = timeout_ns = TimeUnit.NANOSECONDS.convert(timeout2, TimeUnit.MILLISECONDS);
                        long start = System.nanoTime();
                        while (wait_time > 0L && !this.acquired && !this.denied) {
                            try {
                                long wait_ms = TimeUnit.MILLISECONDS.convert(wait_time, TimeUnit.NANOSECONDS);
                                if (wait_ms <= 0L) break block8;
                                this.wait(wait_ms);
                            }
                            catch (InterruptedException e) {
                                interrupted = true;
                            }
                            finally {
                                wait_time = timeout_ns - (System.nanoTime() - start);
                                this.timeout = TimeUnit.MILLISECONDS.convert(wait_time, TimeUnit.NANOSECONDS);
                            }
                        }
                        break;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            boolean bl = retval = this.acquired && !this.denied;
            if (!this.acquired || this.denied) {
                this._unlock(true);
            }
            return retval;
        }

        public boolean equals(Object obj2) {
            return this == obj2 || Objects.equals(this.owner, ((ClientLock)obj2).owner);
        }

        @Override
        public int compareTo(ClientLock o) {
            int rc = this.owner.compareTo(o.owner);
            return rc != 0 ? rc : this.name.compareTo(o.name);
        }
    }

    protected class ServerCondition {
        protected final ServerLock lock;
        protected final Queue<Owner> queue = new ArrayDeque<Owner>();

        public ServerCondition(ServerLock lock) {
            this.lock = lock;
        }

        public void addWaiter(Owner waiter) {
            Locking.this.notifyAwaiting(this.lock.lock_name, waiter);
            Locking.this.log.trace("%s: waiter %s was added for %s", Locking.this.local_addr, waiter, this.lock.lock_name);
            this.queue.add(waiter);
        }

        public void removeWaiter(Owner waiter) {
            Locking.this.notifyAwaited(this.lock.lock_name, waiter);
            Locking.this.log.trace("%s: waiter %s was removed for %s", Locking.this.local_addr, waiter, this.lock.lock_name);
            this.queue.remove(waiter);
        }

        public void signal(boolean all) {
            if (this.queue.isEmpty()) {
                Locking.this.log.trace("%s: signal for %s ignored since, no one is waiting in queue", Locking.this.local_addr, this.lock.lock_name);
            }
            if (all) {
                Owner entry;
                while ((entry = this.queue.poll()) != null) {
                    Locking.this.notifyAwaited(this.lock.lock_name, entry);
                    Locking.this.log.trace("%s: signalled %s for %s", Locking.this.local_addr, entry, this.lock.lock_name);
                    Locking.this.sendSignalResponse(entry, this.lock.lock_name);
                }
            } else {
                Owner entry = this.queue.poll();
                if (entry != null) {
                    Locking.this.notifyAwaited(this.lock.lock_name, entry);
                    Locking.this.log.trace("%s: signalled %s for %s", Locking.this.local_addr, entry, this.lock.lock_name);
                    Locking.this.sendSignalResponse(entry, this.lock.lock_name);
                }
            }
        }
    }

    protected class ServerLock {
        protected final String lock_name;
        protected Owner owner;
        protected final List<Request> queue = new ArrayList<Request>();
        protected final ServerCondition condition;

        public ServerLock(String lock_name) {
            this.lock_name = lock_name;
            this.condition = new ServerCondition(this);
        }

        protected ServerLock(String lock_name, Owner owner) {
            this.lock_name = lock_name;
            this.owner = owner;
            this.condition = new ServerCondition(this);
        }

        protected Response handleRequest(Request req) {
            switch (req.type) {
                case GRANT_LOCK: {
                    if (this.owner == null) {
                        this.setOwner(req.owner);
                        return new Response(Type.LOCK_GRANTED, req.owner, req.lock_name, req.lock_id);
                    }
                    if (this.owner.equals(req.owner)) {
                        return new Response(Type.LOCK_GRANTED, req.owner, req.lock_name, req.lock_id);
                    }
                    if (req.is_trylock && req.timeout <= 0L) {
                        return new Response(Type.LOCK_DENIED, req.owner, req.lock_name, req.lock_id);
                    }
                    this.addToQueue(req);
                    break;
                }
                case RELEASE_LOCK: 
                case LOCK_AWAIT: {
                    if (Objects.equals(this.owner, req.owner)) {
                        this.setOwner(null);
                        if (req.type != Type.RELEASE_LOCK) break;
                        Locking.this.sendLockResponse(Type.RELEASE_LOCK_OK, req.owner, req.lock_name, req.lock_id);
                        break;
                    }
                    this.addToQueue(req);
                    break;
                }
                case COND_SIG: {
                    this.condition.signal(false);
                    break;
                }
                case COND_SIG_ALL: {
                    this.condition.signal(true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("type " + req.type + " is invalid here");
                }
            }
            return this.processQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Response handleView(List<Address> members2) {
            if (this.owner != null && !members2.contains(this.owner.getAddress())) {
                Owner tmp = this.owner;
                this.setOwner(null);
                Locking.this.log.debug("%s: unlocked \"%s\" because owner %s left", Locking.this.local_addr, this.lock_name, tmp);
            }
            List<Request> list = this.queue;
            synchronized (list) {
                this.queue.removeIf(req -> !members2.contains(req.owner.getAddress()));
            }
            this.condition.queue.removeIf(own -> !members2.contains(own.getAddress()));
            return this.processQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addToQueue(Request req) {
            List<Request> list = this.queue;
            synchronized (list) {
                if (this.queue.isEmpty()) {
                    if (req.type == Type.GRANT_LOCK) {
                        this.queue.add(req);
                    }
                    return;
                }
            }
            switch (req.type) {
                case GRANT_LOCK: {
                    list = this.queue;
                    synchronized (list) {
                        if (!this.isRequestPresent(Type.GRANT_LOCK, req.owner)) {
                            this.queue.add(req);
                        }
                        break;
                    }
                }
                case RELEASE_LOCK: {
                    this.removeRequest(Type.GRANT_LOCK, req.owner);
                }
            }
        }

        protected boolean isRequestPresent(Type type2, Owner owner) {
            for (Request req : this.queue) {
                if (req.type != type2 || !req.owner.equals(owner)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeRequest(Type type2, Owner owner) {
            List<Request> list = this.queue;
            synchronized (list) {
                this.queue.removeIf(req -> req.type == type2 && req.owner.equals(owner));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Request getNextRequest() {
            List<Request> list = this.queue;
            synchronized (list) {
                return !this.queue.isEmpty() ? this.queue.remove(0) : null;
            }
        }

        protected Response processQueue() {
            Request req;
            if (this.owner != null) {
                return null;
            }
            while ((req = this.getNextRequest()) != null) {
                switch (req.type) {
                    case GRANT_LOCK: {
                        this.setOwner(req.owner);
                        return new Response(Type.LOCK_GRANTED, req.owner, req.lock_name, req.lock_id);
                    }
                    case RELEASE_LOCK: {
                        if (this.owner == null) break;
                        if (this.owner.equals(req.owner)) {
                            this.setOwner(null);
                        }
                        return new Response(Type.RELEASE_LOCK_OK, req.owner, req.lock_name, req.lock_id);
                    }
                }
            }
            return null;
        }

        protected void setOwner(Owner owner) {
            if (owner == null) {
                if (this.owner != null) {
                    Owner tmp = this.owner;
                    this.owner = null;
                    Locking.this.notifyUnlocked(this.lock_name, tmp);
                }
            } else {
                this.owner = owner;
                Locking.this.notifyLocked(this.lock_name, owner);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            List<Request> list = this.queue;
            synchronized (list) {
                return this.queue.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuilder sb = new StringBuilder(this.lock_name + ": ").append(this.owner);
            List<Request> list = this.queue;
            synchronized (list) {
                if (!this.queue.isEmpty()) {
                    sb.append(", queue: ");
                    for (Request req : this.queue) {
                        sb.append(req.toStringShort()).append(" ");
                    }
                }
            }
            return sb.toString();
        }
    }

    public static enum Type {
        GRANT_LOCK,
        LOCK_GRANTED,
        LOCK_DENIED,
        RELEASE_LOCK,
        RELEASE_LOCK_OK,
        CREATE_LOCK,
        DELETE_LOCK,
        LOCK_AWAIT,
        COND_SIG,
        COND_SIG_ALL,
        SIG_RET,
        DELETE_LOCK_AWAIT,
        CREATE_AWAITER,
        DELETE_AWAITER,
        LOCK_INFO_REQ,
        LOCK_INFO_RSP,
        LOCK_REVOKED;

    }
}

