/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.results;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.experimental.results.PrintableResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultMatchers {
    @Deprecated
    public ResultMatchers() {
    }

    public static Matcher<PrintableResult> isSuccessful() {
        return ResultMatchers.failureCountIs(0);
    }

    public static Matcher<PrintableResult> failureCountIs(final int count2) {
        return new TypeSafeMatcher<PrintableResult>(){

            @Override
            public void describeTo(Description description2) {
                description2.appendText("has " + count2 + " failures");
            }

            @Override
            public boolean matchesSafely(PrintableResult item) {
                return item.failureCount() == count2;
            }
        };
    }

    public static Matcher<Object> hasSingleFailureContaining(final String string2) {
        return new BaseMatcher<Object>(){

            @Override
            public boolean matches(Object item) {
                return item.toString().contains(string2) && ResultMatchers.failureCountIs(1).matches(item);
            }

            @Override
            public void describeTo(Description description2) {
                description2.appendText("has single failure containing " + string2);
            }
        };
    }

    public static Matcher<PrintableResult> hasSingleFailureMatching(final Matcher<Throwable> matcher) {
        return new TypeSafeMatcher<PrintableResult>(){

            @Override
            public boolean matchesSafely(PrintableResult item) {
                return item.failureCount() == 1 && matcher.matches(item.failures().get(0).getException());
            }

            @Override
            public void describeTo(Description description2) {
                description2.appendText("has failure with exception matching ");
                matcher.describeTo(description2);
            }
        };
    }

    public static Matcher<PrintableResult> hasFailureContaining(final String string2) {
        return new TypeSafeMatcher<PrintableResult>(){

            @Override
            public boolean matchesSafely(PrintableResult item) {
                return item.failureCount() > 0 && item.toString().contains(string2);
            }

            @Override
            public void describeTo(Description description2) {
                description2.appendText("has failure containing " + string2);
            }
        };
    }
}

