/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.panama;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.LongPredicate;
import jdk.incubator.foreign.Addressable;
import jdk.incubator.foreign.CLinker;
import jdk.incubator.foreign.FunctionDescriptor;
import jdk.incubator.foreign.MemoryAddress;
import jdk.incubator.foreign.MemoryLayout;
import jdk.incubator.foreign.MemorySegment;
import jdk.incubator.foreign.NativeSymbol;
import jdk.incubator.foreign.ResourceScope;
import jdk.incubator.foreign.SegmentAllocator;
import jdk.incubator.foreign.ValueLayout;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import sun.misc.Unsafe;

/*
 * Exception performing whole class analysis ignored.
 */
public class Test {
    private static final MethodHandle STRLEN_ADDR;
    private static final Unsafe UNSAFE;
    private static final Class<? extends MemorySegment> MEMORY_SEGMENT_CLASS;
    private static final long MASK;
    private static final long LENGTH;
    private static final long SCOPE;
    private static final long MIN;
    private static final MethodHandle STRLEN;
    private static final long MAGIC_LENGTH = 58932333114681950L;

    private static long size_t32(int len) {
        return (long)len & 0xFFFFFFFFL;
    }

    public static long strlen(Addressable addressable) throws Throwable {
        return STRLEN.invokeExact(addressable);
    }

    public static void main(String[] args2) throws Throwable {
        int i;
        for (i = 0; i < 10000; ++i) {
            System.nanoTime();
        }
        for (i = 0; i < 100; ++i) {
            Test.benchPanamaReuse((int)1000000);
        }
        long t = System.nanoTime();
        Test.benchPanamaReuse((int)100000000);
        t = (System.nanoTime() - t) / 10000000L;
        System.out.println((double)t / 10.0);
    }

    private static void benchPanamaAlloc(int iters) throws Throwable {
        try (ResourceScope scope2 = ResourceScope.newConfinedScope();){
            MemorySegment stack = SegmentAllocator.nativeAllocator((ResourceScope)scope2).allocate(256L);
            SegmentAllocator stackFrame = SegmentAllocator.prefixAllocator((MemorySegment)stack);
            for (int i = 0; i < iters; ++i) {
                Test.benchPanamaAlloc((SegmentAllocator)stackFrame);
            }
        }
    }

    private static void benchPanamaAlloc(SegmentAllocator stackFrame) throws Throwable {
        long len = STRLEN.invokeExact((Addressable)stackFrame.allocateUtf8String("Hello"));
        if (len != 5L) {
            throw new IllegalStateException();
        }
    }

    private static void benchPanamaReuse(int iters) throws Throwable {
        try (ResourceScope scope2 = ResourceScope.newConfinedScope();){
            SegmentAllocator malloc = SegmentAllocator.nativeAllocator((ResourceScope)scope2);
            MemorySegment segment = malloc.allocateUtf8String("Hello");
            for (int i = 0; i < iters; ++i) {
                Test.benchPanamaReuse((Addressable)segment);
            }
        }
    }

    private static void benchPanamaReuse(Addressable addressable) throws Throwable {
        long len = STRLEN.invokeExact(addressable);
        if (len != 5L) {
            throw new IllegalStateException();
        }
    }

    private static void benchInterop(int iters) throws Throwable {
        try (MemoryStack stack = MemoryStack.stackPush();){
            for (int i = 0; i < iters; ++i) {
                Test.benchInterop((MemoryStack)stack);
            }
        }
    }

    private static void benchInterop(MemoryStack stack) throws Throwable {
        try (MemoryStack frame = stack.push();){
            MemoryAddress len = STRLEN_ADDR.invokeExact((Addressable)MemorySegment.ofByteBuffer((ByteBuffer)frame.UTF8("Hello")));
            if (len.toRawLongValue() != 5L) {
                throw new IllegalStateException();
            }
        }
    }

    private static void benchJNI(int iters) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            for (int i = 0; i < iters; ++i) {
                Test.benchJNI((MemoryStack)stack);
            }
        }
    }

    private static void benchJNI(MemoryStack stack) {
        try (MemoryStack frame = stack.push();){
            ByteBuffer byteBuffer = frame.UTF8("Hello");
        }
    }

    private static void benchJNIalloc(int iters) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            for (int i = 0; i < iters; ++i) {
                Test.benchJNIalloc();
            }
        }
    }

    private static void benchJNIalloc() {
        ByteBuffer buffer = MemoryUtil.memUTF8("Hello");
    }

    static MemorySegment wrap(long address, int capacity) {
        MemorySegment segment;
        try {
            segment = (MemorySegment)UNSAFE.allocateInstance(MEMORY_SEGMENT_CLASS);
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException(e);
        }
        UNSAFE.putInt(segment, MASK, 2);
        UNSAFE.putLong(segment, LENGTH, capacity);
        UNSAFE.putObject(segment, SCOPE, ResourceScope.globalScope());
        UNSAFE.putLong(segment, MIN, address);
        return segment;
    }

    private static Unsafe getUnsafeInstance() {
        Field[] fields2;
        for (Field field : fields2 = Unsafe.class.getDeclaredFields()) {
            int modifiers;
            if (!field.getType().equals(Unsafe.class) || !Modifier.isStatic(modifiers = field.getModifiers()) || !Modifier.isFinal(modifiers)) continue;
            try {
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
            catch (Exception exception) {
                break;
            }
        }
        throw new UnsupportedOperationException("LWJGL requires sun.misc.Unsafe to be available.");
    }

    private static long getFieldOffsetInt(Object container, int value) {
        return Test.getFieldOffset(container.getClass(), Integer.TYPE, offset -> UNSAFE.getInt(container, offset) == value);
    }

    private static long getFieldOffsetLong(Object container, long value) {
        return Test.getFieldOffset(container.getClass(), Long.TYPE, offset -> UNSAFE.getLong(container, offset) == value);
    }

    private static long getFieldOffsetObject(Object container, Object value) {
        return Test.getFieldOffset(container.getClass(), value.getClass(), offset -> UNSAFE.getObject(container, offset) == value);
    }

    private static long getAddressOffset() {
        long MAGIC_ADDRESS = 0xDEADBEEF8BADF00DL & (MemoryStack.BITS32 ? 0xFFFFFFFFL : -1L);
        MemorySegment segment = Objects.requireNonNull(MemorySegment.ofAddress((MemoryAddress)MemoryAddress.ofLong((long)MAGIC_ADDRESS), (long)1L, (ResourceScope)ResourceScope.globalScope()));
        return Test.getFieldOffset((Class)segment.getClass(), Long.TYPE, offset -> UNSAFE.getLong(segment, offset) == MAGIC_ADDRESS);
    }

    private static long getLengthOffset() {
        MemorySegment segment = Objects.requireNonNull(MemorySegment.ofAddress((MemoryAddress)MemoryAddress.ofLong((long)-1L), (long)58932333114681950L, (ResourceScope)ResourceScope.globalScope()));
        return Test.getFieldOffsetLong((Object)segment, (long)58932333114681950L);
    }

    private static long getMaskOffset() {
        MemorySegment segment = Objects.requireNonNull(MemorySegment.ofAddress((MemoryAddress)MemoryAddress.ofLong((long)-1L), (long)1L, (ResourceScope)ResourceScope.globalScope()));
        return Test.getFieldOffsetInt((Object)segment, (int)2);
    }

    private static long getFieldOffset(Class<?> containerType, Class<?> fieldType, LongPredicate predicate) {
        for (Class<?> c = containerType; c != Object.class; c = c.getSuperclass()) {
            Field[] fields2;
            for (Field field : fields2 = c.getDeclaredFields()) {
                long offset;
                if (!field.getType().isAssignableFrom(fieldType) || Modifier.isStatic(field.getModifiers()) || field.isSynthetic() || !predicate.test(offset = UNSAFE.objectFieldOffset(field))) continue;
                return offset;
            }
        }
        throw new UnsupportedOperationException("Failed to find field offset in class.");
    }

    static {
        CLinker linker = CLinker.systemCLinker();
        NativeSymbol strlen = (NativeSymbol)linker.lookup("strlen").get();
        try {
            STRLEN = Pointer.BITS64 ? linker.downcallHandle(strlen, FunctionDescriptor.of((MemoryLayout)ValueLayout.JAVA_LONG, (MemoryLayout[])new MemoryLayout[]{ValueLayout.ADDRESS})) : MethodHandles.filterReturnValue(linker.downcallHandle(strlen, FunctionDescriptor.of((MemoryLayout)ValueLayout.JAVA_INT, (MemoryLayout[])new MemoryLayout[]{ValueLayout.ADDRESS})), MethodHandles.lookup().findStatic(Test.class, "size_t32", MethodType.methodType(Long.TYPE, Integer.TYPE)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            MethodHandle cat = MethodHandles.lookup().findVirtual(String.class, "concat", MethodType.methodType(String.class, String.class));
            MethodHandle length = MethodHandles.lookup().findVirtual(String.class, "length", MethodType.methodType(Integer.TYPE));
            System.out.println(cat.invokeExact("x", "y"));
            MethodHandle filtered = MethodHandles.filterReturnValue(cat, length);
            System.out.println(filtered.invokeExact("x", "y"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        linker = CLinker.systemCLinker();
        STRLEN_ADDR = linker.downcallHandle((NativeSymbol)linker.lookup("strlen").get(), FunctionDescriptor.of((MemoryLayout)ValueLayout.ADDRESS, (MemoryLayout[])new MemoryLayout[]{ValueLayout.ADDRESS}));
        UNSAFE = Test.getUnsafeInstance();
        MemorySegment segment = MemorySegment.ofAddress((MemoryAddress)MemoryAddress.ofLong((long)-1L), (long)1L, (ResourceScope)ResourceScope.globalScope());
        MEMORY_SEGMENT_CLASS = segment.getClass();
        LENGTH = Test.getLengthOffset();
        MASK = Test.getMaskOffset();
        SCOPE = Test.getFieldOffsetObject((Object)segment, (Object)ResourceScope.globalScope());
        MIN = Test.getAddressOffset();
    }
}

