/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.JTextComponent;
import org.pushingpixels.substance.api.SubstanceComponentPlugin;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSkinPlugin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.combo.ComboPopupPrototypeCallback;
import org.pushingpixels.substance.api.font.FontPolicy;
import org.pushingpixels.substance.api.font.FontSet;
import org.pushingpixels.substance.api.font.SubstanceFontUtilities;
import org.pushingpixels.substance.api.icon.SubstanceDefaultIconPack;
import org.pushingpixels.substance.api.icon.SubstanceIconPack;
import org.pushingpixels.substance.api.painter.preview.PreviewPainter;
import org.pushingpixels.substance.api.password.PasswordStrengthChecker;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.api.skin.SkinChangeListener;
import org.pushingpixels.substance.api.skin.SkinInfo;
import org.pushingpixels.substance.api.tabbed.BaseTabCloseListener;
import org.pushingpixels.substance.api.tabbed.TabCloseCallback;
import org.pushingpixels.substance.internal.AnimationConfigurationManager;
import org.pushingpixels.substance.internal.SubstancePluginRepository;
import org.pushingpixels.substance.internal.SubstanceWidgetRepository;
import org.pushingpixels.substance.internal.contrib.intellij.UIUtil;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.ui.SubstanceRootPaneUI;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTitlePaneUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceWidgetManager;
import org.pushingpixels.substance.internal.utils.TabCloseListenerManager;

public class SubstanceCortex {

    public static final class WindowScope {
        public static void setWidgetVisible(Window window, boolean visible, SubstanceSlices.SubstanceWidgetType ... substanceWidgets) {
            if (window == null) {
                throw new IllegalArgumentException("Window scope APIs do not accept null windows");
            }
            JRootPane rootPane = SwingUtilities.getRootPane(window);
            if (rootPane != null) {
                SubstanceWidgetManager.getInstance().register(rootPane, visible, substanceWidgets);
                SwingUtilities.updateComponentTreeUI(rootPane);
            }
        }

        public static void extendContentIntoTitlePane(Window window, SubstanceSlices.HorizontalGravity controlButtonGroupHorizontalGravity, SubstanceSlices.VerticalGravity controlButtonGroupVerticalGravity) {
            if (window == null) {
                throw new IllegalArgumentException("Window scope APIs do not accept null windows");
            }
            if (controlButtonGroupHorizontalGravity != SubstanceSlices.HorizontalGravity.LEADING && controlButtonGroupHorizontalGravity != SubstanceSlices.HorizontalGravity.TRAILING) {
                throw new IllegalArgumentException("Can only pass LEADING or TRAILING for control button group horizontal gravity.");
            }
            if (controlButtonGroupVerticalGravity == null) {
                throw new IllegalArgumentException("Cannot pass null for control button group vertical gravity. Did you mean CENTERED?");
            }
            JRootPane rootPane = SwingUtilities.getRootPane(window);
            if (rootPane != null) {
                rootPane.putClientProperty("substancelaf.internal.rootPaneContentExtendsIntoTitlePane", Boolean.TRUE);
                rootPane.putClientProperty("substancelaf.internal.titleControlButtonGroupHorizontalGravity", (Object)controlButtonGroupHorizontalGravity);
                rootPane.putClientProperty("substancelaf.internal.titleControlButtonGroupVerticalGravity", (Object)controlButtonGroupVerticalGravity);
                SubstanceRootPaneUI ui = (SubstanceRootPaneUI)rootPane.getUI();
                ui.extendContentIntoTitlePane();
            }
        }

        public static JButton createTitlePaneControlButton(Window window) {
            if (window == null) {
                throw new IllegalArgumentException("Window scope APIs do not accept null windows");
            }
            JRootPane rootPane = SwingUtilities.getRootPane(window);
            if (rootPane != null) {
                SubstanceRootPaneUI ui = (SubstanceRootPaneUI)rootPane.getUI();
                return ui.createTitlePaneControlButton();
            }
            return null;
        }

        public static Insets getTitlePaneControlInsets(Window window) {
            if (window == null) {
                throw new IllegalArgumentException("Window scope APIs do not accept null windows");
            }
            JRootPane rootPane = SwingUtilities.getRootPane(window);
            if (rootPane != null) {
                SubstanceRootPaneUI ui = (SubstanceRootPaneUI)rootPane.getUI();
                return ui.getTitlePaneControlInsets();
            }
            return null;
        }

        public static void setPreferredTitlePaneHeight(Window window, int preferredTitlePaneHeight) {
            if (window == null) {
                throw new IllegalArgumentException("Window scope APIs do not accept null windows");
            }
            if (preferredTitlePaneHeight <= 0) {
                throw new IllegalArgumentException("Should pass positive value");
            }
            JRootPane rootPane = SwingUtilities.getRootPane(window);
            if (rootPane != null) {
                rootPane.putClientProperty("substancelaf.internal.rootPanePreferredTitlePaneHeight", preferredTitlePaneHeight);
                SubstanceRootPaneUI ui = (SubstanceRootPaneUI)rootPane.getUI();
                ui.setPreferredTitlePaneHeight(preferredTitlePaneHeight);
            }
        }

        public static SubstanceSlices.HorizontalGravity getTitleControlButtonGroupHorizontalGravity(Window window) {
            if (window == null) {
                throw new IllegalArgumentException("Window scope APIs do not accept null windows");
            }
            return SubstanceTitlePaneUtilities.getTitleControlButtonGroupHorizontalGravity(SwingUtilities.getRootPane(window));
        }
    }

    public static final class RootPaneScope {
        public static void setSkin(JRootPane rootPane, SubstanceSkin skin) {
            if (rootPane == null) {
                throw new IllegalArgumentException("Root pane scope APIs do not accept null root panes");
            }
            rootPane.putClientProperty("substancelaf.internal.rootPaneSkin", skin);
        }

        public static void setContentsModified(JRootPane rootPane, Boolean contentsModified) {
            if (rootPane == null) {
                throw new IllegalArgumentException("Root pane scope APIs do not accept null root panes");
            }
            rootPane.putClientProperty("substancelaf.internal.contentsModified", contentsModified);
        }
    }

    public static final class ComponentOrParentChainScope {
        public static void setSelectTextOnFocus(JComponent comp, Boolean selectTextOnFocus) {
            comp.putClientProperty("substancelaf.internal.widget.textSelectAllOnFocus", selectTextOnFocus);
        }

        public static void setWatermarkVisible(JComponent comp, Boolean watermarkVisible) {
            comp.putClientProperty("substancelaf.internal.watermarkVisible", watermarkVisible);
        }

        public static void setToolbarButtonCornerRadius(JToolBar toolbar, float toolbarButtonCornerRadius) {
            toolbar.putClientProperty("substancelaf.internal.toolbarButtonCornerRadius", Float.valueOf(toolbarButtonCornerRadius));
        }

        public static void setExtraWidgetsPresence(JComponent comp, Boolean extraWidgetsPresence) {
            comp.putClientProperty("substancelaf.internal.showExtraWidgets", extraWidgetsPresence);
        }

        public static void setColorizationFactor(JComponent comp, double colorizationFactor) {
            comp.putClientProperty("substancelaf.internal.colorizationFactor", colorizationFactor);
        }

        public static void setFocusKind(JComponent comp, SubstanceSlices.FocusKind focusKind) {
            comp.putClientProperty("substancelaf.internal.focusKind", (Object)focusKind);
        }

        public static void setDecorationType(JComponent comp, SubstanceSlices.DecorationAreaType type2) {
            if (comp == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            DecorationPainterUtils.setDecorationType(comp, type2);
        }

        public static SubstanceSlices.DecorationAreaType getDecorationType(Component comp) {
            if (comp == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            return DecorationPainterUtils.getDecorationType(comp);
        }
    }

    public static final class ComponentOrParentScope {
        public static void setComponentPreviewPainter(JComponent comp, PreviewPainter previewPainter) {
            comp.putClientProperty("substancelaf.internal.widget.componentPreviewPainter", previewPainter);
        }

        public static void setButtonIgnoreMinimumSize(JComponent comp, Boolean buttonIgnoreMinimumSize) {
            comp.putClientProperty("substancelaf.internal.buttonNoMinSize", buttonIgnoreMinimumSize);
        }

        public static void setButtonNeverPaintBackground(JComponent comp, Boolean neverPaintButtonBackground) {
            comp.putClientProperty("substancelaf.internal.buttonNeverPaintBackground", neverPaintButtonBackground);
        }

        public static void setFlatBackground(JComponent comp, Boolean flatBackground) {
            comp.putClientProperty("substancelaf.internal.FlatLook", flatBackground);
        }
    }

    public static final class ComponentScope {
        public static SubstanceSkin getCurrentSkin(Component c) {
            return SubstanceCoreUtilities.getSkin(c);
        }

        public static void registerTabCloseChangeListener(JTabbedPane tabbedPane, BaseTabCloseListener tabCloseListener) {
            if (tabbedPane == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            TabCloseListenerManager.getInstance().registerListener(tabbedPane, tabCloseListener);
        }

        public static void unregisterTabCloseChangeListener(JTabbedPane tabbedPane, BaseTabCloseListener tabCloseListener) {
            if (tabbedPane == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            TabCloseListenerManager.getInstance().unregisterListener(tabbedPane, tabCloseListener);
        }

        public static Set<BaseTabCloseListener> getAllTabCloseListeners(JTabbedPane tabbedPane) {
            if (tabbedPane == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            return TabCloseListenerManager.getInstance().getListeners(tabbedPane);
        }

        public static void allowAnimations(Component comp, SubstanceSlices.AnimationFacet animationFacet) {
            if (comp == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            AnimationConfigurationManager.getInstance().allowAnimations(animationFacet, comp);
        }

        public static void disallowAnimations(Component comp, SubstanceSlices.AnimationFacet animationFacet) {
            if (comp == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            AnimationConfigurationManager.getInstance().disallowAnimations(animationFacet, comp);
        }

        public static boolean isAnimationAllowed(Component comp, SubstanceSlices.AnimationFacet animationFacet) {
            if (comp == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            return AnimationConfigurationManager.getInstance().isAnimationAllowed(animationFacet, comp);
        }

        public static SubstanceSlices.DecorationAreaType getImmediateDecorationType(Component comp) {
            if (comp == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            return DecorationPainterUtils.getImmediateDecorationType(comp);
        }

        public static void setLockIconVisible(JComponent comp, Boolean visible) {
            comp.putClientProperty("substancelaf.internal.widget.hasLockIcon", visible);
        }

        public static void setPasswordStrengthChecker(JPasswordField passwordField, PasswordStrengthChecker passwordStrengthChecker) {
            passwordField.putClientProperty("substancelaf.internal.widget.passwordStrengthChecker", passwordStrengthChecker);
        }

        public static void setFlipTextSelectionOnEscape(JTextComponent comp, Boolean flipTextSelectionOnEscape) {
            comp.putClientProperty("substancelaf.internal.widget.textFlipSelectOnEscape", flipTextSelectionOnEscape);
        }

        public static void setTextEditContextMenuPresence(JTextComponent comp, Boolean hasEditContextMenu) {
            comp.putClientProperty("substancelaf.internal.widget.textEditContextMenu", hasEditContextMenu);
        }

        public static void setAutomaticDragAndDropSupportPresence(JTree tree, Boolean hasAutomaticDragAndDropSupport) {
            tree.putClientProperty("substancelaf.internal.widget.treeAutoDnDSupport", hasAutomaticDragAndDropSupport);
        }

        public static void setAutomaticScrollPresence(JScrollPane scrollPane, Boolean hasAutomaticScroll) {
            scrollPane.putClientProperty("substancelaf.internal.widget.autoScroll", hasAutomaticScroll);
        }

        public static void setButtonOpenSide(JComponent comp, SubstanceSlices.Side openSide) {
            comp.putClientProperty("substancelaf.internal.buttonOpenSide", (Object)openSide);
        }

        public static void setButtonOpenSides(JComponent comp, Set<SubstanceSlices.Side> openSides) {
            comp.putClientProperty("substancelaf.internal.buttonOpenSide", openSides);
        }

        public static void setButtonStraightSide(JComponent comp, SubstanceSlices.Side straightSide) {
            comp.putClientProperty("substancelaf.internal.buttonStraightSide", (Object)straightSide);
        }

        public static void setButtonStraightSides(JComponent comp, Set<SubstanceSlices.Side> straightSides) {
            comp.putClientProperty("substancelaf.internal.buttonStraightSide", straightSides);
        }

        public static void setToolbarButtonCornerRadius(AbstractButton button, float toolbarButtonCornerRadius) {
            button.putClientProperty("substancelaf.internal.toolbarButtonCornerRadius", Float.valueOf(toolbarButtonCornerRadius));
        }

        public static void setTabContentsModified(JComponent tabComponent, Boolean contentsModified) {
            tabComponent.putClientProperty("substancelaf.internal.contentsModified", contentsModified);
        }

        public static void setTabCloseButtonsVisible(JTabbedPane tabbedPane, Boolean tabCloseButtonsVisible) {
            tabbedPane.putClientProperty("substancelaf.internal.tabbedPaneHasCloseButtons", tabCloseButtonsVisible);
        }

        public static void setTabCloseButtonVisible(JComponent tabComponent, Boolean tabCloseButtonVisible) {
            tabComponent.putClientProperty("substancelaf.internal.tabbedPaneHasCloseButtons", tabCloseButtonVisible);
        }

        public static void setTabCloseCallback(JTabbedPane tabbedPane, TabCloseCallback tabCloseCallback) {
            tabbedPane.putClientProperty("substancelaf.internal.tabbedPaneHasCloseButtons", tabCloseCallback);
        }

        public static void setTabCloseCallback(JComponent tabComponent, TabCloseCallback tabCloseCallback) {
            tabComponent.putClientProperty("substancelaf.internal.tabbedPaneHasCloseButtons", tabCloseCallback);
        }

        public static void setRunModifiedAnimationOnTabCloseButton(JTabbedPane tabbedPane, Boolean runModifiedAnimationOnTabCloseButton) {
            tabbedPane.putClientProperty("substancelaf.internal.tabbedPaneCloseButtonsModifiedAnimation", runModifiedAnimationOnTabCloseButton);
        }

        public static void setRunModifiedAnimationOnTabCloseButton(JComponent tabComponent, Boolean runModifiedAnimationOnTabCloseButton) {
            tabComponent.putClientProperty("substancelaf.internal.tabbedPaneCloseButtonsModifiedAnimation", runModifiedAnimationOnTabCloseButton);
        }

        public static void setTabContentPaneBorderKind(JTabbedPane tabbedPane, SubstanceSlices.TabContentPaneBorderKind tabContentPaneBorderKind) {
            tabbedPane.putClientProperty("substancelaf.internal.tabbedPaneContentBorderKind", (Object)tabContentPaneBorderKind);
        }

        public static void setButtonShaper(JComponent comp, SubstanceButtonShaper buttonShaper) {
            comp.putClientProperty("substancelaf.internal.tabbedPaneContentBorderKind", buttonShaper);
        }

        public static void setNumberOfPasswordEchoesPerCharacter(JPasswordField passwordField, int echoCount) {
            passwordField.putClientProperty("substancelaf.internal.passwordEchoPerChar", echoCount);
        }

        public static void setComboBoxPrototypeCallback(JComboBox comboBox, ComboPopupPrototypeCallback comboPopupPrototypeCallback) {
            comboBox.putClientProperty("substancelaf.internal.comboPopupPrototype", comboPopupPrototypeCallback);
        }

        public static void setComboBoxPrototypeDisplayValue(JComboBox comboBox, Object comboPopupPrototypeDisplayValue) {
            comboBox.putClientProperty("substancelaf.internal.comboPopupPrototype", comboPopupPrototypeDisplayValue);
        }

        public static void setComboBoxPopupFlyoutOrientation(JComboBox comboBox, Integer comboPopupFlyoutOrientation) {
            comboBox.putClientProperty("substancelaf.internal.comboBoxPopupFlyoutOrientation", comboPopupFlyoutOrientation);
        }
    }

    public static final class GlobalScope {
        private static final String SUBSTANCE_FONT_POLICY_KEY = "substancelaf.fontPolicyKey";
        private static ResourceBundle labelBundle = null;
        private static ClassLoader labelBundleClassLoader;
        private static SubstanceSkin currentSkin;
        private static final Set<SkinChangeListener> skinChangeListeners;
        private static final Set<SubstanceSlices.LocaleChangeListener> localeChangeListeners;
        private static SubstanceIconPack iconPack;
        private static SubstanceSlices.ButtonOrder buttonBarButtonOrder;
        private static SubstanceSlices.HorizontalGravity buttonBarGravity;

        static boolean setSkin(SubstanceSkin newSkin, boolean toUpdateWindows) {
            if (!SwingUtilities.isEventDispatchThread()) {
                throw new IllegalStateException("This method must be called on the Event Dispatch Thread");
            }
            if (!newSkin.isValid()) {
                return false;
            }
            boolean isSubstance = UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel;
            if (!isSubstance) {
                class SkinDerivedLookAndFeel
                extends SubstanceLookAndFeel {
                    public SkinDerivedLookAndFeel(SubstanceSkin newSkin) {
                        super(newSkin);
                    }
                }
                SkinDerivedLookAndFeel derived = new SkinDerivedLookAndFeel(newSkin);
                try {
                    UIManager.setLookAndFeel(derived);
                }
                catch (UnsupportedLookAndFeelException ulafe) {
                    return false;
                }
                if (!(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel)) {
                    return false;
                }
                for (Window window : Window.getWindows()) {
                    SwingUtilities.updateComponentTreeUI(window);
                }
                return true;
            }
            try {
                if (!newSkin.isValid()) {
                    return false;
                }
                if (currentSkin != null && currentSkin.getWatermark() != null) {
                    currentSkin.getWatermark().dispose();
                }
                if (newSkin.getWatermark() != null && !newSkin.getWatermark().updateWatermarkImage(newSkin)) {
                    return false;
                }
                UIDefaults lafDefaults = UIManager.getLookAndFeelDefaults();
                UIDefaults defaults = lafDefaults;
                if (defaults != null) {
                    GlobalScope.initFontDefaults(lafDefaults, GlobalScope.getFontPolicy().getFontSet("Substance", null));
                    newSkin.addCustomEntriesToTable(lafDefaults);
                    SubstancePluginRepository.getInstance().processAllDefaultsEntriesComponentPlugins(lafDefaults, newSkin);
                }
                ResourceBundle substanceBundle = GlobalScope.getLabelBundle();
                Enumeration<String> keyEn = substanceBundle.getKeys();
                while (keyEn.hasMoreElements()) {
                    String key = keyEn.nextElement();
                    if (key.indexOf("FileChooser") == -1) continue;
                    String value = substanceBundle.getString(key);
                    UIManager.put(key, value);
                }
                if (isSubstance) {
                    LazyResettableHashMap.reset();
                }
                currentSkin = newSkin;
                if (toUpdateWindows) {
                    SubstanceCoreUtilities.updateActiveUi();
                }
                for (SkinChangeListener skinChangeListener : skinChangeListeners) {
                    skinChangeListener.skinChanged();
                }
                return true;
            }
            catch (NoClassDefFoundError ncdfe) {
                ncdfe.printStackTrace(System.out);
                return false;
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                return false;
            }
        }

        static void unsetSkin() {
            currentSkin = null;
        }

        public static boolean setSkin(SubstanceSkin newSkin) {
            return GlobalScope.setSkin(newSkin, true);
        }

        public static boolean setSkin(String skinClassName) {
            try {
                Class<?> skinClass = Class.forName(skinClassName);
                if (skinClass == null) {
                    return false;
                }
                Object obj2 = skinClass.newInstance();
                if (obj2 == null) {
                    return false;
                }
                if (!(obj2 instanceof SubstanceSkin)) {
                    return false;
                }
                return GlobalScope.setSkin((SubstanceSkin)obj2);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                return false;
            }
        }

        public static SubstanceSkin getCurrentSkin() {
            LookAndFeel current = UIManager.getLookAndFeel();
            if (current instanceof SubstanceLookAndFeel) {
                return currentSkin;
            }
            return null;
        }

        static void initFontDefaults(UIDefaults table) {
            FontSet substanceFontSet = GlobalScope.getFontPolicy().getFontSet("Substance", null);
            GlobalScope.initFontDefaults(table, substanceFontSet);
        }

        private static void initFontDefaults(UIDefaults table, FontSet fontSet) {
            FontUIResource controlFont = fontSet.getControlFont();
            FontUIResource menuFont = fontSet.getMenuFont();
            FontUIResource messageFont = fontSet.getMessageFont();
            FontUIResource toolTipFont = fontSet.getSmallFont();
            FontUIResource titleFont = fontSet.getTitleFont();
            FontUIResource windowFont = fontSet.getWindowTitleFont();
            Object[] defaults = new Object[]{"Button.font", controlFont, "CheckBox.font", controlFont, "ColorChooser.font", controlFont, "ComboBox.font", controlFont, "EditorPane.font", controlFont, "FormattedTextField.font", controlFont, "Label.font", controlFont, "List.font", controlFont, "Panel.font", controlFont, "PasswordField.font", controlFont, "ProgressBar.font", controlFont, "RadioButton.font", controlFont, "ScrollPane.font", controlFont, "Spinner.font", controlFont, "TabbedPane.font", controlFont, "Table.font", controlFont, "TableHeader.font", controlFont, "TextArea.font", controlFont, "TextField.font", controlFont, "TextPane.font", controlFont, "ToolBar.font", controlFont, "ToggleButton.font", controlFont, "Tree.font", controlFont, "Viewport.font", controlFont, "InternalFrame.titleFont", windowFont, "DesktopIcon.titleFont", windowFont, "OptionPane.font", messageFont, "OptionPane.messageFont", messageFont, "OptionPane.buttonFont", messageFont, "TitledBorder.font", titleFont, "ToolTip.font", toolTipFont, "CheckBoxMenuItem.font", menuFont, "CheckBoxMenuItem.acceleratorFont", menuFont, "Menu.font", menuFont, "Menu.acceleratorFont", menuFont, "MenuBar.font", menuFont, "MenuItem.font", menuFont, "MenuItem.acceleratorFont", menuFont, "PopupMenu.font", menuFont, "RadioButtonMenuItem.font", menuFont, "RadioButtonMenuItem.acceleratorFont", menuFont};
            table.putDefaults(defaults);
        }

        public static void registerSkinChangeListener(SkinChangeListener skinChangeListener) {
            skinChangeListeners.add(skinChangeListener);
        }

        public static void unregisterSkinChangeListener(SkinChangeListener skinChangeListener) {
            skinChangeListeners.remove(skinChangeListener);
        }

        public static Map<String, SkinInfo> getAllSkins() {
            TreeMap<String, SkinInfo> result2 = new TreeMap<String, SkinInfo>();
            for (SubstanceSkinPlugin skinPlugin : SubstancePluginRepository.getInstance().getSkinPlugins()) {
                for (SkinInfo skinInfo : skinPlugin.getSkins()) {
                    result2.put(skinInfo.getDisplayName(), skinInfo);
                }
            }
            return result2;
        }

        public static void registerComponentPlugin(SubstanceComponentPlugin componentPlugin) {
            SubstancePluginRepository.getInstance().registerComponentPlugin(componentPlugin);
        }

        public static void registerSkinPlugin(SubstanceSkinPlugin skinPlugin) {
            SubstancePluginRepository.getInstance().registerSkinPlugin(skinPlugin);
        }

        public static void registerWidget(String widgetClassName, Class<?> supportedClass, boolean isExact) {
            SubstanceWidgetRepository.getRepository().registerWidget(widgetClassName, supportedClass, isExact);
        }

        public static void setFontPolicy(FontPolicy fontPolicy) {
            UIManager.put(SUBSTANCE_FONT_POLICY_KEY, fontPolicy);
            SubstanceSizeUtils.setControlFontSize(-1);
            SubstanceSizeUtils.resetPointsToPixelsRatio(fontPolicy);
            GlobalScope.setSkin(GlobalScope.getCurrentSkin());
        }

        public static FontPolicy getFontPolicy() {
            FontPolicy policy = (FontPolicy)UIManager.get(SUBSTANCE_FONT_POLICY_KEY);
            if (policy != null) {
                return policy;
            }
            return SubstanceFontUtilities.getDefaultFontPolicy();
        }

        public static void registerTabCloseChangeListener(BaseTabCloseListener tabCloseListener) {
            TabCloseListenerManager.getInstance().registerListener(tabCloseListener);
        }

        public static void unregisterTabCloseChangeListener(BaseTabCloseListener tabCloseListener) {
            TabCloseListenerManager.getInstance().unregisterListener(tabCloseListener);
        }

        public static Set<BaseTabCloseListener> getAllTabCloseListeners() {
            return TabCloseListenerManager.getInstance().getListeners();
        }

        public static void setIconPack(SubstanceIconPack iconPack) {
            if (iconPack == null) {
                throw new IllegalArgumentException("Cannot pass null icon pack");
            }
            GlobalScope.iconPack = iconPack;
            LazyResettableHashMap.reset();
        }

        public static SubstanceIconPack getIconPack() {
            if (iconPack == null) {
                iconPack = new SubstanceDefaultIconPack();
            }
            return iconPack;
        }

        public static void allowAnimations(SubstanceSlices.AnimationFacet animationFacet) {
            AnimationConfigurationManager.getInstance().allowAnimations(animationFacet);
        }

        public static void allowAnimations(SubstanceSlices.AnimationFacet animationFacet, Class<?> clazz) {
            AnimationConfigurationManager.getInstance().allowAnimations(animationFacet, clazz);
        }

        public static void allowAnimations(SubstanceSlices.AnimationFacet animationFacet, Class<?>[] clazz) {
            AnimationConfigurationManager.getInstance().allowAnimations(animationFacet, clazz);
        }

        public static void disallowAnimations(SubstanceSlices.AnimationFacet animationFacet) {
            AnimationConfigurationManager.getInstance().disallowAnimations(animationFacet);
        }

        public static void disallowAnimations(SubstanceSlices.AnimationFacet animationFacet, Class<?> clazz) {
            AnimationConfigurationManager.getInstance().disallowAnimations(animationFacet, clazz);
        }

        public static void disallowAnimations(SubstanceSlices.AnimationFacet animationFacet, Class<?>[] clazz) {
            AnimationConfigurationManager.getInstance().disallowAnimations(animationFacet, clazz);
        }

        public static boolean isAnimationAllowed(SubstanceSlices.AnimationFacet animationFacet) {
            return AnimationConfigurationManager.getInstance().isAnimationAllowed(animationFacet, null);
        }

        public static void setTimelineDuration(long timelineDuration) {
            AnimationConfigurationManager.getInstance().setTimelineDuration(timelineDuration);
        }

        public static long getTimelineDuration() {
            return AnimationConfigurationManager.getInstance().getTimelineDuration();
        }

        public static void registerLocaleChangeListener(SubstanceSlices.LocaleChangeListener localeListener) {
            localeChangeListeners.add(localeListener);
        }

        public static void unregisterLocaleChangeListener(SubstanceSlices.LocaleChangeListener localeListener) {
            localeChangeListeners.remove(localeListener);
        }

        public static Set<SubstanceSlices.LocaleChangeListener> getLocaleChangeListeners() {
            return Collections.unmodifiableSet(localeChangeListeners);
        }

        public static synchronized ResourceBundle getLabelBundle() {
            if (labelBundle == null) {
                labelBundle = labelBundleClassLoader == null ? ResourceBundle.getBundle("org.pushingpixels.substance.internal.resources.Labels", Locale.getDefault()) : ResourceBundle.getBundle("org.pushingpixels.substance.internal.resources.Labels", Locale.getDefault(), labelBundleClassLoader);
                for (SubstanceSlices.LocaleChangeListener lcl : GlobalScope.getLocaleChangeListeners()) {
                    lcl.localeChanged();
                }
            }
            return labelBundle;
        }

        public static synchronized ResourceBundle getLabelBundle(Locale locale) {
            if (labelBundleClassLoader == null) {
                return ResourceBundle.getBundle("org.pushingpixels.substance.internal.resources.Labels", locale);
            }
            return ResourceBundle.getBundle("org.pushingpixels.substance.internal.resources.Labels", locale, labelBundleClassLoader);
        }

        public static synchronized void resetLabelBundle() {
            labelBundle = null;
        }

        public static void setLabelBundleClassLoader(ClassLoader labelBundleClassLoader) {
            GlobalScope.labelBundleClassLoader = labelBundleClassLoader;
        }

        public static ClassLoader getLabelBundleClassLoader() {
            return labelBundleClassLoader;
        }

        public static void setUseConstantThemesOnOptionPanes(Boolean useConstantThemesOnOptionPanes) {
            UIManager.put("substancelaf.internal.useThemedIconsOnOptionPanes", useConstantThemesOnOptionPanes);
            SwingUtilities.invokeLater(SubstanceCoreUtilities::updateActiveUi);
        }

        public static void setUseThemedDefaultIcons(Boolean useThemedDefaultIcons) {
            UIManager.put("substancelaf.internal.useThemedDefaultIcons", useThemedDefaultIcons);
        }

        public static SubstanceSlices.ButtonOrder getButtonBarOrder() {
            return buttonBarButtonOrder;
        }

        public static void setButtonBarOrder(SubstanceSlices.ButtonOrder buttonBarButtonOrder) {
            if (buttonBarButtonOrder == null) {
                throw new IllegalArgumentException("Cannot pass null. Did you mean PLATFORM or SWING_DEFAULT?");
            }
            GlobalScope.buttonBarButtonOrder = buttonBarButtonOrder;
            SwingUtilities.invokeLater(SubstanceCoreUtilities::updateActiveUi);
        }

        public static SubstanceSlices.HorizontalGravity getButtonBarGravity() {
            return buttonBarGravity;
        }

        public static void setButtonBarGravity(SubstanceSlices.HorizontalGravity buttonBarGravity) {
            if (buttonBarGravity == null) {
                throw new IllegalArgumentException("Cannot pass null. Did you mean PLATFORM or SWING_DEFAULT?");
            }
            GlobalScope.buttonBarGravity = buttonBarGravity;
            SwingUtilities.invokeLater(SubstanceCoreUtilities::updateActiveUi);
        }

        public static void configureTitleContentGravity(SubstanceSlices.HorizontalGravity titleTextHorizontalGravity, SubstanceSlices.HorizontalGravity titleControlButtonGroupHorizontalGravity, SubstanceSlices.TitleIconHorizontalGravity titleIconHorizontalGravity) {
            if (titleTextHorizontalGravity == null) {
                throw new IllegalArgumentException("Cannot pass null for text gravity. Did you mean PLATFORM or SWING_DEFAULT?");
            }
            if (titleControlButtonGroupHorizontalGravity == null) {
                throw new IllegalArgumentException("Cannot pass null for control button group horizontal gravity. Did you mean PLATFORM or SWING_DEFAULT?");
            }
            if (titleIconHorizontalGravity == null) {
                throw new IllegalArgumentException("Cannot pass null for icon horizontal gravity. Did you mean PLATFORM or SWING_DEFAULT?");
            }
            if (titleControlButtonGroupHorizontalGravity == SubstanceSlices.HorizontalGravity.CENTERED) {
                throw new IllegalArgumentException("Cannot pass CENTERED for control button group horizontal gravity. Did you mean PLATFORM or SWING_DEFAULT?");
            }
            UIManager.put("substancelaf.internal.titleTextHorizontalGravity", (Object)titleTextHorizontalGravity);
            UIManager.put("substancelaf.internal.titleControlButtonGroupHorizontalGravity", (Object)titleControlButtonGroupHorizontalGravity);
            UIManager.put("substancelaf.internal.titleIconHorizontalGravity", (Object)titleIconHorizontalGravity);
            SwingUtilities.invokeLater(SubstanceCoreUtilities::updateActiveUi);
        }

        public static SubstanceSlices.HorizontalGravity getTitleTextHorizontalGravity() {
            return SubstanceTitlePaneUtilities.getTitleTextHorizontalGravity();
        }

        public static SubstanceSlices.TitleIconHorizontalGravity getTitleIconHorizontalGravity() {
            return SubstanceTitlePaneUtilities.getTitleIconHorizontalGravity();
        }

        public static void setWidgetVisible(boolean visible, SubstanceSlices.SubstanceWidgetType ... substanceWidgets) {
            SubstanceWidgetManager.getInstance().register(null, visible, substanceWidgets);
            for (Window window : Window.getWindows()) {
                JRootPane root = SwingUtilities.getRootPane(window);
                SwingUtilities.updateComponentTreeUI(root);
            }
        }

        public static void setLockIconVisible(Boolean visible) {
            UIManager.put("substancelaf.internal.widget.hasLockIcon", visible);
        }

        public static void setComponentPreviewPainter(PreviewPainter previewPainter) {
            UIManager.put("substancelaf.internal.widget.componentPreviewPainter", previewPainter);
        }

        public static void setSelectTextOnFocus(Boolean selectTextOnFocus) {
            UIManager.put("substancelaf.internal.widget.textSelectAllOnFocus", selectTextOnFocus);
        }

        public static void setTextEditContextMenuPresence(Boolean hasEditContextMenu) {
            UIManager.put("substancelaf.internal.widget.textEditContextMenu", hasEditContextMenu);
        }

        public static void setAutomaticDragAndDropSupportPresence(Boolean hasAutomaticDragAndDropSupport) {
            UIManager.put("substancelaf.internal.widget.treeAutoDnDSupport", hasAutomaticDragAndDropSupport);
        }

        public static void setAutomaticScrollPresence(Boolean hasAutomaticScroll) {
            UIManager.put("substancelaf.internal.widget.autoScroll", hasAutomaticScroll);
        }

        public static void setWatermarkVisible(Boolean watermarkVisible) {
            UIManager.put("substancelaf.internal.watermarkVisible", watermarkVisible);
        }

        public static void setButtonIgnoreMinimumSize(Boolean buttonIgnoreMinimumSize) {
            UIManager.put("substancelaf.internal.buttonNoMinSize", buttonIgnoreMinimumSize);
        }

        public static void setButtonNeverPaintBackground(Boolean neverPaintButtonBackground) {
            UIManager.put("substancelaf.internal.buttonNeverPaintBackground", neverPaintButtonBackground);
        }

        public static void setFlatBackground(Boolean flatBackground) {
            UIManager.put("substancelaf.internal.FlatLook", flatBackground);
        }

        public static void setToolbarButtonCornerRadius(float toolbarButtonCornerRadius) {
            UIManager.put("substancelaf.internal.toolbarButtonCornerRadius", Float.valueOf(toolbarButtonCornerRadius));
        }

        public static void setExtraWidgetsPresence(Boolean extraWidgetsPresence) {
            UIManager.put("substancelaf.internal.showExtraWidgets", extraWidgetsPresence);
        }

        public static void setColorizationFactor(double colorizationFactor) {
            UIManager.put("substancelaf.internal.colorizationFactor", colorizationFactor);
        }

        public static void setTabCloseButtonsVisible(Boolean tabCloseButtonsVisible) {
            UIManager.put("substancelaf.internal.tabbedPaneHasCloseButtons", tabCloseButtonsVisible);
        }

        public static void setTabCloseCallback(TabCloseCallback tabCloseCallback) {
            UIManager.put("substancelaf.internal.tabbedPaneHasCloseButtons", tabCloseCallback);
        }

        public static void setRunModifiedAnimationOnTabCloseButton(Boolean runModifiedAnimationOnTabCloseButton) {
            UIManager.put("substancelaf.internal.tabbedPaneCloseButtonsModifiedAnimation", runModifiedAnimationOnTabCloseButton);
        }

        public static void setTabContentPaneBorderKind(SubstanceSlices.TabContentPaneBorderKind tabContentPaneBorderKind) {
            UIManager.put("substancelaf.internal.tabbedPaneContentBorderKind", (Object)tabContentPaneBorderKind);
        }

        public static void setNumberOfPasswordEchoesPerCharacter(int echoCount) {
            UIManager.put("substancelaf.internal.passwordEchoPerChar", echoCount);
        }

        public static void setMenuGutterFillKind(SubstanceSlices.MenuGutterFillKind menuGutterFillKind) {
            UIManager.put("substancelaf.internal.menuGutterFillKind", (Object)menuGutterFillKind);
        }

        public static void setTraceFilename(String traceFilename) {
            UIManager.put("substancelaf.internal.traceFile", traceFilename);
        }

        public static void setHeapStatusTraceFilename(String heapStatusTraceFilename) {
            UIManager.put("substancelaf.internal.heapStatusTraceFile", heapStatusTraceFilename);
        }

        public static void setFocusKind(SubstanceSlices.FocusKind focusKind) {
            UIManager.put("substancelaf.internal.focusKind", (Object)focusKind);
        }

        public static void setComboBoxPrototypeCallback(ComboPopupPrototypeCallback comboPopupPrototypeCallback) {
            UIManager.put("substancelaf.internal.comboPopupPrototype", comboPopupPrototypeCallback);
        }

        public static void setComboBoxPrototypeDisplayValue(Object comboPopupPrototypeDisplayValue) {
            UIManager.put("substancelaf.internal.comboPopupPrototype", comboPopupPrototypeDisplayValue);
        }

        public static void setComboBoxPopupFlyoutOrientation(int comboPopupFlyoutOrientation) {
            UIManager.put("substancelaf.internal.comboBoxPopupFlyoutOrientation", comboPopupFlyoutOrientation);
        }

        public static BufferedImage getBlankImage(int width, int height) {
            return SubstanceCoreUtilities.getBlankImage(width, height);
        }

        public static double getScaleFactor() {
            return UIUtil.getScaleFactor();
        }

        static {
            currentSkin = null;
            skinChangeListeners = new HashSet<SkinChangeListener>();
            localeChangeListeners = new HashSet<SubstanceSlices.LocaleChangeListener>();
            buttonBarButtonOrder = SubstanceSlices.ButtonOrder.PLATFORM;
            buttonBarGravity = SubstanceSlices.HorizontalGravity.PLATFORM;
        }
    }
}

