/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.UIDefaults;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.ColorSchemeTransform;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.SubstanceDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.api.painter.highlight.SubstanceHighlightPainter;
import org.pushingpixels.substance.api.painter.overlay.SubstanceOverlayPainter;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.api.trait.SubstanceTrait;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.internal.utils.SkinUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public abstract class SubstanceSkin
implements SubstanceTrait {
    protected Map<SubstanceSlices.DecorationAreaType, SubstanceColorSchemeBundle> colorSchemeBundleMap = new HashMap<SubstanceSlices.DecorationAreaType, SubstanceColorSchemeBundle>();
    protected Map<SubstanceSlices.DecorationAreaType, SubstanceColorScheme> backgroundColorSchemeMap = new HashMap<SubstanceSlices.DecorationAreaType, SubstanceColorScheme>();
    protected Map<SubstanceSlices.DecorationAreaType, List<SubstanceOverlayPainter>> overlayPaintersMap = new HashMap<SubstanceSlices.DecorationAreaType, List<SubstanceOverlayPainter>>();
    protected SubstanceWatermark watermark;
    protected SubstanceButtonShaper buttonShaper;
    protected SubstanceFillPainter fillPainter;
    protected SubstanceBorderPainter borderPainter;
    protected SubstanceBorderPainter highlightBorderPainter;
    protected SubstanceHighlightPainter highlightPainter;
    protected SubstanceDecorationPainter decorationPainter;
    protected Set<SubstanceSlices.DecorationAreaType> decoratedAreaSet = new HashSet<SubstanceSlices.DecorationAreaType>();
    protected double tabFadeStart;
    protected double tabFadeEnd;
    protected SubstanceColorScheme watermarkScheme;
    Set<ComponentState> statesWithAlpha;

    protected SubstanceSkin() {
        this.decoratedAreaSet.add(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE);
        this.decoratedAreaSet.add(SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE);
        this.tabFadeStart = 0.1;
        this.tabFadeEnd = 0.3;
        this.statesWithAlpha = new HashSet<ComponentState>();
    }

    public final SubstanceWatermark getWatermark() {
        return this.watermark;
    }

    public final SubstanceBorderPainter getBorderPainter() {
        return this.borderPainter;
    }

    public final SubstanceBorderPainter getHighlightBorderPainter() {
        return this.highlightBorderPainter;
    }

    public final SubstanceButtonShaper getButtonShaper() {
        return this.buttonShaper;
    }

    public final SubstanceFillPainter getFillPainter() {
        return this.fillPainter;
    }

    public final SubstanceHighlightPainter getHighlightPainter() {
        return this.highlightPainter;
    }

    public final SubstanceDecorationPainter getDecorationPainter() {
        return this.decorationPainter;
    }

    public void addCustomEntriesToTable(UIDefaults table) {
        if (table == null) {
            return;
        }
        SkinUtilities.addCustomEntriesToTable(table, this);
    }

    public final SubstanceColorScheme getColorScheme(Component comp, ComponentState componentState) {
        SubstanceColorScheme registered;
        if (this.colorSchemeBundleMap.size() > 1) {
            SubstanceSlices.DecorationAreaType decorationAreaType;
            SubstanceSlices.DecorationAreaType decorationAreaType2 = decorationAreaType = comp == null ? SubstanceSlices.DecorationAreaType.NONE : SubstanceCortex.ComponentOrParentChainScope.getDecorationType(comp);
            if (this.colorSchemeBundleMap.containsKey(decorationAreaType)) {
                SubstanceColorScheme registered2 = this.colorSchemeBundleMap.get(decorationAreaType).getColorScheme(componentState);
                if (registered2 == null) {
                    throw new IllegalStateException("Color scheme shouldn't be null here. Please report this issue");
                }
                return registered2;
            }
        }
        if ((registered = this.colorSchemeBundleMap.get(SubstanceSlices.DecorationAreaType.NONE).getColorScheme(componentState)) == null) {
            throw new IllegalStateException("Color scheme shouldn't be null here. Please report this issue");
        }
        return registered;
    }

    public final float getHighlightAlpha(Component comp, ComponentState componentState) {
        Float registered;
        SubstanceSlices.DecorationAreaType decorationAreaType;
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey(decorationAreaType = SubstanceCortex.ComponentOrParentChainScope.getDecorationType(comp)) && (double)(registered = Float.valueOf(this.colorSchemeBundleMap.get(decorationAreaType).getHighlightAlpha(comp, componentState))).floatValue() >= 0.0) {
            return registered.floatValue();
        }
        Float registered2 = Float.valueOf(this.colorSchemeBundleMap.get(SubstanceSlices.DecorationAreaType.NONE).getHighlightAlpha(comp, componentState));
        if ((double)registered2.floatValue() >= 0.0) {
            return registered2.floatValue();
        }
        boolean isRollover = componentState.isFacetActive(SubstanceSlices.ComponentStateFacet.ROLLOVER);
        boolean isSelected = componentState.isFacetActive(SubstanceSlices.ComponentStateFacet.SELECTION);
        boolean isArmed = componentState.isFacetActive(SubstanceSlices.ComponentStateFacet.ARM);
        if (isRollover && isSelected) {
            return 0.9f;
        }
        if (isRollover && isArmed) {
            return 0.8f;
        }
        if (isSelected) {
            return 0.7f;
        }
        if (isArmed) {
            return 0.6f;
        }
        if (isRollover) {
            return 0.4f;
        }
        return 0.0f;
    }

    public final float getAlpha(Component comp, ComponentState componentState) {
        Float registered;
        ComponentState fallback = componentState.getHardFallback();
        if (fallback == null && !this.statesWithAlpha.contains(componentState)) {
            return 1.0f;
        }
        if (this.colorSchemeBundleMap.size() > 1) {
            Float registered2;
            SubstanceSlices.DecorationAreaType decorationAreaType;
            SubstanceSlices.DecorationAreaType decorationAreaType2 = decorationAreaType = comp == null ? SubstanceSlices.DecorationAreaType.NONE : SubstanceCortex.ComponentOrParentChainScope.getDecorationType(comp);
            if (this.colorSchemeBundleMap.containsKey(decorationAreaType) && (double)(registered2 = Float.valueOf(this.colorSchemeBundleMap.get(decorationAreaType).getAlpha(comp, componentState))).floatValue() >= 0.0) {
                return registered2.floatValue();
            }
        }
        if ((double)(registered = Float.valueOf(this.colorSchemeBundleMap.get(SubstanceSlices.DecorationAreaType.NONE).getAlpha(comp, componentState))).floatValue() >= 0.0) {
            return registered.floatValue();
        }
        if (fallback == null) {
            return 1.0f;
        }
        return this.getAlpha(comp, fallback);
    }

    public void registerDecorationAreaSchemeBundle(SubstanceColorSchemeBundle bundle, SubstanceColorScheme backgroundColorScheme, SubstanceSlices.DecorationAreaType ... areaTypes) {
        if (bundle == null) {
            return;
        }
        if (backgroundColorScheme == null) {
            throw new IllegalArgumentException("Cannot pass null background color scheme");
        }
        for (SubstanceSlices.DecorationAreaType areaType : areaTypes) {
            this.decoratedAreaSet.add(areaType);
            this.colorSchemeBundleMap.put(areaType, bundle);
            this.backgroundColorSchemeMap.put(areaType, backgroundColorScheme);
        }
        this.statesWithAlpha.addAll(bundle.getStatesWithAlpha());
    }

    public void registerDecorationAreaSchemeBundle(SubstanceColorSchemeBundle bundle, SubstanceSlices.DecorationAreaType ... areaTypes) {
        this.registerDecorationAreaSchemeBundle(bundle, bundle.getEnabledColorScheme(), areaTypes);
    }

    public void registerAsDecorationArea(SubstanceColorScheme backgroundColorScheme, SubstanceSlices.DecorationAreaType ... areaTypes) {
        if (backgroundColorScheme == null) {
            throw new IllegalArgumentException("Cannot pass null background color scheme");
        }
        for (SubstanceSlices.DecorationAreaType areaType : areaTypes) {
            this.decoratedAreaSet.add(areaType);
            this.backgroundColorSchemeMap.put(areaType, backgroundColorScheme);
        }
    }

    public boolean isRegisteredAsDecorationArea(SubstanceSlices.DecorationAreaType decorationType) {
        return this.decoratedAreaSet.contains(decorationType);
    }

    public SubstanceColorScheme getWatermarkColorScheme() {
        if (this.watermarkScheme != null) {
            return this.watermarkScheme;
        }
        return this.colorSchemeBundleMap.get(SubstanceSlices.DecorationAreaType.NONE).getEnabledColorScheme();
    }

    public final SubstanceColorScheme getActiveColorScheme(SubstanceSlices.DecorationAreaType decorationAreaType) {
        if (this.colorSchemeBundleMap.containsKey(decorationAreaType)) {
            return this.colorSchemeBundleMap.get(decorationAreaType).getActiveColorScheme();
        }
        return this.colorSchemeBundleMap.get(SubstanceSlices.DecorationAreaType.NONE).getActiveColorScheme();
    }

    public final SubstanceColorScheme getEnabledColorScheme(SubstanceSlices.DecorationAreaType decorationAreaType) {
        if (this.colorSchemeBundleMap.containsKey(decorationAreaType)) {
            return this.colorSchemeBundleMap.get(decorationAreaType).getEnabledColorScheme();
        }
        return this.colorSchemeBundleMap.get(SubstanceSlices.DecorationAreaType.NONE).getEnabledColorScheme();
    }

    public final SubstanceColorScheme getDisabledColorScheme(SubstanceSlices.DecorationAreaType decorationAreaType) {
        if (this.colorSchemeBundleMap.containsKey(decorationAreaType)) {
            return this.colorSchemeBundleMap.get(decorationAreaType).getDisabledColorScheme();
        }
        return this.colorSchemeBundleMap.get(SubstanceSlices.DecorationAreaType.NONE).getDisabledColorScheme();
    }

    public final double getTabFadeStart() {
        return this.tabFadeStart;
    }

    public final double getTabFadeEnd() {
        return this.tabFadeEnd;
    }

    public void setTabFadeEnd(double tabFadeEnd) {
        if (tabFadeEnd < 0.0 || tabFadeEnd > 1.0) {
            throw new IllegalArgumentException("Value for tab fade end should be in 0.0-1.0 range");
        }
        this.tabFadeEnd = tabFadeEnd;
    }

    public void setTabFadeStart(double tabFadeStart) {
        if (tabFadeStart < 0.0 || tabFadeStart > 1.0) {
            throw new IllegalArgumentException("Value for tab fade start should be in 0.0-1.0 range");
        }
        this.tabFadeStart = tabFadeStart;
    }

    public void addOverlayPainter(SubstanceOverlayPainter overlayPainter, SubstanceSlices.DecorationAreaType ... areaTypes) {
        for (SubstanceSlices.DecorationAreaType areaType : areaTypes) {
            if (!this.overlayPaintersMap.containsKey(areaType)) {
                this.overlayPaintersMap.put(areaType, new ArrayList());
            }
            this.overlayPaintersMap.get(areaType).add(overlayPainter);
        }
    }

    public void removeOverlayPainter(SubstanceOverlayPainter overlayPainter, SubstanceSlices.DecorationAreaType ... areaTypes) {
        for (SubstanceSlices.DecorationAreaType areaType : areaTypes) {
            if (!this.overlayPaintersMap.containsKey(areaType)) {
                return;
            }
            this.overlayPaintersMap.get(areaType).remove(overlayPainter);
            if (this.overlayPaintersMap.get(areaType).size() != 0) continue;
            this.overlayPaintersMap.remove(areaType);
        }
    }

    public List<SubstanceOverlayPainter> getOverlayPainters(SubstanceSlices.DecorationAreaType decorationAreaType) {
        if (!this.overlayPaintersMap.containsKey(decorationAreaType)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.overlayPaintersMap.get(decorationAreaType));
    }

    public final SubstanceColorScheme getColorScheme(SubstanceSlices.DecorationAreaType decorationAreaType, SubstanceSlices.ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey(decorationAreaType)) {
            return this.colorSchemeBundleMap.get(decorationAreaType).getColorScheme(associationKind, componentState, true);
        }
        return this.colorSchemeBundleMap.get(SubstanceSlices.DecorationAreaType.NONE).getColorScheme(associationKind, componentState, true);
    }

    public final SubstanceColorScheme getColorScheme(Component comp, SubstanceSlices.ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        if (this.colorSchemeBundleMap.size() > 1) {
            SubstanceSlices.DecorationAreaType decorationAreaType;
            SubstanceSlices.DecorationAreaType decorationAreaType2 = decorationAreaType = comp == null ? SubstanceSlices.DecorationAreaType.NONE : SubstanceCortex.ComponentOrParentChainScope.getDecorationType(comp);
            if (this.colorSchemeBundleMap.containsKey(decorationAreaType)) {
                return this.colorSchemeBundleMap.get(decorationAreaType).getColorScheme(associationKind, componentState, true);
            }
        }
        return this.colorSchemeBundleMap.get(SubstanceSlices.DecorationAreaType.NONE).getColorScheme(associationKind, componentState, true);
    }

    public final SubstanceColorScheme getDirectColorScheme(Component comp, SubstanceSlices.ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        SubstanceSlices.DecorationAreaType decorationAreaType;
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey(decorationAreaType = SubstanceCortex.ComponentOrParentChainScope.getDecorationType(comp))) {
            return this.colorSchemeBundleMap.get(decorationAreaType).getColorScheme(associationKind, componentState, false);
        }
        return this.colorSchemeBundleMap.get(SubstanceSlices.DecorationAreaType.NONE).getColorScheme(associationKind, componentState, false);
    }

    public SubstanceSkin transform(ColorSchemeTransform transform2, final String name) {
        SubstanceSkin result2 = new SubstanceSkin(){

            @Override
            public String getDisplayName() {
                return name;
            }
        };
        result2.borderPainter = this.borderPainter;
        result2.buttonShaper = this.buttonShaper;
        result2.decorationPainter = this.decorationPainter;
        result2.fillPainter = this.fillPainter;
        result2.highlightPainter = this.highlightPainter;
        result2.highlightBorderPainter = this.highlightBorderPainter;
        result2.watermark = this.watermark;
        if (this.watermarkScheme != null) {
            result2.watermarkScheme = transform2.transform(this.watermarkScheme);
        }
        result2.tabFadeEnd = this.tabFadeEnd;
        result2.tabFadeStart = this.tabFadeStart;
        if (this.colorSchemeBundleMap != null) {
            result2.colorSchemeBundleMap = new HashMap<SubstanceSlices.DecorationAreaType, SubstanceColorSchemeBundle>();
            for (Map.Entry<SubstanceSlices.DecorationAreaType, SubstanceColorSchemeBundle> entry : this.colorSchemeBundleMap.entrySet()) {
                result2.colorSchemeBundleMap.put(entry.getKey(), entry.getValue().transform(transform2));
            }
        }
        if (this.decoratedAreaSet != null) {
            result2.decoratedAreaSet = new HashSet<SubstanceSlices.DecorationAreaType>(this.decoratedAreaSet);
        }
        if (this.backgroundColorSchemeMap != null) {
            result2.backgroundColorSchemeMap = new HashMap<SubstanceSlices.DecorationAreaType, SubstanceColorScheme>();
            for (Map.Entry<SubstanceSlices.DecorationAreaType, Object> entry : this.backgroundColorSchemeMap.entrySet()) {
                result2.backgroundColorSchemeMap.put(entry.getKey(), transform2.transform((SubstanceColorScheme)entry.getValue()));
            }
        }
        result2.overlayPaintersMap = new HashMap<SubstanceSlices.DecorationAreaType, List<SubstanceOverlayPainter>>(this.overlayPaintersMap);
        return result2;
    }

    public final SubstanceColorScheme getBackgroundColorScheme(SubstanceSlices.DecorationAreaType decorationAreaType) {
        SubstanceColorScheme registered;
        if (this.backgroundColorSchemeMap.containsKey(decorationAreaType)) {
            return this.backgroundColorSchemeMap.get(decorationAreaType);
        }
        if (this.colorSchemeBundleMap.containsKey(decorationAreaType) && (registered = this.colorSchemeBundleMap.get(decorationAreaType).getEnabledColorScheme()) != null) {
            return registered;
        }
        return this.backgroundColorSchemeMap.get(SubstanceSlices.DecorationAreaType.NONE);
    }

    public boolean isValid() {
        if (!this.colorSchemeBundleMap.containsKey(SubstanceSlices.DecorationAreaType.NONE)) {
            return false;
        }
        if (this.getButtonShaper() == null) {
            return false;
        }
        if (this.getFillPainter() == null) {
            return false;
        }
        if (this.getBorderPainter() == null) {
            return false;
        }
        if (this.getHighlightPainter() == null) {
            return false;
        }
        return this.getDecorationPainter() != null;
    }

    public static ColorSchemes getColorSchemes(URL url) {
        return SubstanceColorSchemeUtilities.getColorSchemes(url);
    }

    public static ColorSchemes getColorSchemes(String resourceName) {
        ClassLoader cl = SubstanceCoreUtilities.getClassLoaderForResources();
        return SubstanceColorSchemeUtilities.getColorSchemes(cl.getResource(resourceName));
    }

    public static class ColorSchemes {
        private List<SubstanceColorScheme> schemes = new ArrayList<SubstanceColorScheme>();

        public ColorSchemes() {
        }

        public ColorSchemes(List<SubstanceColorScheme> schemes) {
            this();
            this.schemes.addAll(schemes);
        }

        public int size() {
            return this.schemes.size();
        }

        public SubstanceColorScheme get(int index) {
            return this.schemes.get(index);
        }

        public SubstanceColorScheme get(String displayName) {
            for (SubstanceColorScheme scheme : this.schemes) {
                if (!scheme.getDisplayName().equals(displayName)) continue;
                return scheme;
            }
            return null;
        }

        private int indexOf(String displayName) {
            for (int i = 0; i < this.schemes.size(); ++i) {
                SubstanceColorScheme curr = this.schemes.get(i);
                if (!curr.getDisplayName().equals(displayName)) continue;
                return i;
            }
            return -1;
        }

        public void replace(String displayName, SubstanceColorScheme scheme) {
            int index = this.indexOf(displayName);
            if (index >= 0) {
                this.schemes.remove(index);
                this.schemes.add(index, scheme);
            }
        }

        public void delete(String displayName) {
            int index = this.indexOf(displayName);
            if (index >= 0) {
                this.schemes.remove(index);
            }
        }

        public void add(SubstanceColorScheme scheme) {
            this.schemes.add(scheme);
        }

        public void switchWithPrevious(String displayName) {
            int index = this.indexOf(displayName);
            if (index >= 0) {
                SubstanceColorScheme scheme = this.schemes.remove(index);
                this.schemes.add(index - 1, scheme);
            }
        }

        public void switchWithNext(String displayName) {
            int index = this.indexOf(displayName);
            if (index >= 0) {
                SubstanceColorScheme scheme = this.schemes.remove(index);
                this.schemes.add(index + 1, scheme);
            }
        }
    }
}

