/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.skin;

import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.colorscheme.LightGrayColorScheme;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.ClassicBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.FractionBasedDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.FractionBasedFillPainter;
import org.pushingpixels.substance.api.painter.highlight.ClassicHighlightPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomLineOverlayPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public class OfficeBlack2007Skin
extends SubstanceSkin {
    public static final String NAME = "Office Black 2007";

    public OfficeBlack2007Skin() {
        SubstanceSkin.ColorSchemes colorSchemes = SubstanceSkin.getColorSchemes("org/pushingpixels/substance/api/skin/office2007.colorschemes");
        SubstanceColorScheme activeScheme = colorSchemes.get("Office Silver Active");
        SubstanceColorScheme enabledScheme = colorSchemes.get("Office Black Enabled");
        SubstanceColorScheme disabledScheme = new LightGrayColorScheme().tint(0.05).named("Office Black Disabled");
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, enabledScheme, enabledScheme);
        defaultSchemeBundle.registerColorScheme(enabledScheme, 0.5f, ComponentState.DISABLED_UNSELECTED);
        SubstanceColorScheme rolloverScheme = colorSchemes.get("Office Silver Rollover");
        SubstanceColorScheme rolloverSelectedScheme = colorSchemes.get("Office Silver Rollover Selected");
        SubstanceColorScheme selectedScheme = colorSchemes.get("Office Silver Selected");
        SubstanceColorScheme pressedScheme = colorSchemes.get("Office Silver Pressed");
        SubstanceColorScheme pressedSelectedScheme = colorSchemes.get("Office Silver Pressed Selected");
        defaultSchemeBundle.registerColorScheme(rolloverScheme, ComponentState.ROLLOVER_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(rolloverSelectedScheme, ComponentState.ROLLOVER_SELECTED);
        defaultSchemeBundle.registerColorScheme(selectedScheme, ComponentState.SELECTED);
        defaultSchemeBundle.registerColorScheme(pressedScheme, ComponentState.PRESSED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(pressedSelectedScheme, ComponentState.PRESSED_SELECTED);
        defaultSchemeBundle.registerColorScheme(selectedScheme.tone(0.2f), 0.5f, ComponentState.DISABLED_SELECTED);
        defaultSchemeBundle.registerHighlightColorScheme(rolloverScheme, 0.8f, ComponentState.ROLLOVER_UNSELECTED);
        defaultSchemeBundle.registerHighlightColorScheme(selectedScheme, 0.8f, ComponentState.SELECTED);
        defaultSchemeBundle.registerHighlightColorScheme(rolloverSelectedScheme, 0.8f, ComponentState.ROLLOVER_SELECTED);
        defaultSchemeBundle.registerHighlightColorScheme(selectedScheme, 0.8f, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        SubstanceColorScheme borderEnabledScheme = colorSchemes.get("Office Silver Border Enabled");
        SubstanceColorScheme borderActiveScheme = colorSchemes.get("Office Silver Border Active");
        SubstanceColorScheme borderRolloverScheme = colorSchemes.get("Office Border Rollover");
        SubstanceColorScheme borderRolloverSelectedScheme = colorSchemes.get("Office Border Rollover Selected");
        SubstanceColorScheme borderSelectedScheme = colorSchemes.get("Office Border Selected");
        SubstanceColorScheme borderPressedScheme = colorSchemes.get("Office Border Pressed");
        defaultSchemeBundle.registerColorScheme(borderEnabledScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        defaultSchemeBundle.registerColorScheme(borderEnabledScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(borderActiveScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.DEFAULT);
        defaultSchemeBundle.registerColorScheme(borderRolloverScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ROLLOVER_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(borderRolloverSelectedScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ROLLOVER_SELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        defaultSchemeBundle.registerColorScheme(borderSelectedScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.SELECTED);
        defaultSchemeBundle.registerColorScheme(borderPressedScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.PRESSED_SELECTED, ComponentState.PRESSED_UNSELECTED);
        SubstanceColorScheme markEnabledScheme = colorSchemes.get("Office Black Mark Enabled");
        defaultSchemeBundle.registerColorScheme(markEnabledScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.ENABLED);
        defaultSchemeBundle.registerColorScheme(markEnabledScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(selectedScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.SELECTED);
        defaultSchemeBundle.registerColorScheme(pressedScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.PRESSED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(pressedSelectedScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.PRESSED_SELECTED);
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, SubstanceSlices.DecorationAreaType.NONE);
        SubstanceColorScheme tabSelectedScheme = colorSchemes.get("Office Silver Tab Selected");
        SubstanceColorScheme tabRolloverScheme = colorSchemes.get("Office Silver Tab Rollover");
        defaultSchemeBundle.registerColorScheme(tabSelectedScheme, SubstanceSlices.ColorSchemeAssociationKind.TAB, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED, ComponentState.PRESSED_SELECTED, ComponentState.PRESSED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(tabRolloverScheme, SubstanceSlices.ColorSchemeAssociationKind.TAB, ComponentState.ROLLOVER_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(borderEnabledScheme, SubstanceSlices.ColorSchemeAssociationKind.TAB_BORDER, ComponentState.SELECTED, ComponentState.ROLLOVER_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(rolloverSelectedScheme, SubstanceSlices.ColorSchemeAssociationKind.TAB_BORDER, ComponentState.ROLLOVER_SELECTED);
        SubstanceColorScheme separatorScheme = colorSchemes.get("Office Silver Separator");
        defaultSchemeBundle.registerColorScheme(separatorScheme, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, SubstanceSlices.DecorationAreaType.NONE);
        SubstanceColorScheme activeHeaderScheme = colorSchemes.get("Office Black Header Active");
        SubstanceColorScheme enabledHeaderScheme = colorSchemes.get("Office Black Header Enabled");
        SubstanceColorScheme disabledHeaderScheme = colorSchemes.get("Office Black Header Disabled");
        SubstanceColorSchemeBundle headerSchemeBundle = new SubstanceColorSchemeBundle(activeHeaderScheme, enabledHeaderScheme, disabledHeaderScheme);
        SubstanceColorScheme headerMarkEnabledScheme = colorSchemes.get("Office Black Header Mark Enabled");
        headerSchemeBundle.registerColorScheme(headerMarkEnabledScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.ENABLED);
        headerSchemeBundle.registerColorScheme(markEnabledScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        headerSchemeBundle.registerColorScheme(disabledHeaderScheme, 0.5f, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        headerSchemeBundle.registerHighlightColorScheme(activeScheme, 0.6f, ComponentState.ROLLOVER_UNSELECTED);
        headerSchemeBundle.registerHighlightColorScheme(activeScheme, 0.8f, ComponentState.SELECTED);
        headerSchemeBundle.registerHighlightColorScheme(activeScheme, 0.95f, ComponentState.ROLLOVER_SELECTED);
        headerSchemeBundle.registerHighlightColorScheme(activeScheme, 0.8f, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        this.registerDecorationAreaSchemeBundle(headerSchemeBundle, activeHeaderScheme, SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.HEADER, SubstanceSlices.DecorationAreaType.TOOLBAR);
        SubstanceColorScheme enabledFooterScheme = colorSchemes.get("Office Black Footer Enabled");
        SubstanceColorSchemeBundle footerSchemeBundle = new SubstanceColorSchemeBundle(activeHeaderScheme, enabledFooterScheme, disabledScheme);
        SubstanceColorScheme borderFooterEnabledScheme = colorSchemes.get("Office Black Footer Border Enabled");
        footerSchemeBundle.registerColorScheme(borderFooterEnabledScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        footerSchemeBundle.registerColorScheme(borderFooterEnabledScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.getActiveStates());
        footerSchemeBundle.registerColorScheme(rolloverScheme, ComponentState.ROLLOVER_UNSELECTED);
        footerSchemeBundle.registerColorScheme(rolloverSelectedScheme, ComponentState.ROLLOVER_SELECTED);
        footerSchemeBundle.registerColorScheme(selectedScheme, ComponentState.SELECTED);
        footerSchemeBundle.registerColorScheme(pressedScheme, ComponentState.PRESSED_UNSELECTED);
        footerSchemeBundle.registerColorScheme(pressedSelectedScheme, ComponentState.PRESSED_SELECTED);
        SubstanceColorScheme footerSeparatorScheme = colorSchemes.get("Office Black Footer Separator");
        footerSchemeBundle.registerColorScheme(footerSeparatorScheme, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        this.registerDecorationAreaSchemeBundle(footerSchemeBundle, activeHeaderScheme, SubstanceSlices.DecorationAreaType.FOOTER);
        this.watermarkScheme = colorSchemes.get("Office Black Watermark");
        this.registerAsDecorationArea(this.watermarkScheme, SubstanceSlices.DecorationAreaType.GENERAL);
        this.setTabFadeStart(0.6);
        this.setTabFadeEnd(0.9);
        this.addOverlayPainter(new BottomLineOverlayPainter(scheme -> SubstanceColorUtilities.getAlphaColor(scheme.getUltraDarkColor(), 192)), SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE);
        this.buttonShaper = new ClassicButtonShaper();
        this.watermark = null;
        this.fillPainter = new FractionBasedFillPainter(NAME, new float[]{0.0f, 0.49999f, 0.5f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.LIGHT, ColorSchemeSingleColorQuery.LIGHT, ColorSchemeSingleColorQuery.MID, ColorSchemeSingleColorQuery.LIGHT});
        this.borderPainter = new ClassicBorderPainter();
        this.decorationPainter = new FractionBasedDecorationPainter(NAME, new float[]{0.0f, 0.2499999f, 0.25f, 0.6f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.LIGHT, ColorSchemeSingleColorQuery.MID, ColorSchemeSingleColorQuery.DARK, ColorSchemeSingleColorQuery.DARK, ColorSchemeSingleColorQuery.MID}, SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.FOOTER);
        this.highlightPainter = new ClassicHighlightPainter();
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }
}

