/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.inputmaps;

import javax.swing.TransferHandler;
import org.pushingpixels.substance.api.inputmap.InputMapSet;
import org.pushingpixels.substance.api.inputmap.SubstanceInputMap;

public class BaseInputMapSet
implements InputMapSet {
    public static final String PRESSED = "pressed";
    public static final String RELEASED = "released";
    public static final String COPY = (String)TransferHandler.getCopyAction().getValue("Name");
    public static final String PASTE = (String)TransferHandler.getPasteAction().getValue("Name");
    public static final String CUT = (String)TransferHandler.getCutAction().getValue("Name");

    protected SubstanceInputMap getActionControlFocusInputMap() {
        SubstanceInputMap result2 = new SubstanceInputMap();
        result2.put("SPACE", PRESSED);
        result2.put("released SPACE", RELEASED);
        return result2;
    }

    @Override
    public SubstanceInputMap getButtonFocusInputMap() {
        return this.getActionControlFocusInputMap();
    }

    @Override
    public SubstanceInputMap getCheckBoxFocusInputMap() {
        return this.getActionControlFocusInputMap();
    }

    @Override
    public SubstanceInputMap getComboBoxAncestorInputMap() {
        SubstanceInputMap result2 = new SubstanceInputMap();
        result2.put("ESCAPE", "hidePopup");
        result2.put("PAGE_UP", "pageUpPassThrough");
        result2.put("PAGE_DOWN", "pageDownPassThrough");
        result2.put("HOME", "homePassThrough");
        result2.put("END", "endPassThrough");
        result2.put("DOWN", "selectNext");
        result2.put("KP_DOWN", "selectNext");
        result2.put("alt DOWN", "togglePopup");
        result2.put("alt KP_DOWN", "togglePopup");
        result2.put("alt UP", "togglePopup");
        result2.put("alt KP_UP", "togglePopup");
        result2.put("SPACE", "spacePopup");
        result2.put("ENTER", "enterPressed");
        result2.put("UP", "selectPrevious");
        result2.put("KP_UP", "selectPrevious");
        return result2;
    }

    @Override
    public SubstanceInputMap getDesktopAncestorInputMap() {
        SubstanceInputMap result2 = new SubstanceInputMap();
        result2.put("ctrl F5", DesktopPaneActions.RESTORE);
        result2.put("ctrl F4", DesktopPaneActions.CLOSE);
        result2.put("ctrl F7", DesktopPaneActions.MOVE);
        result2.put("ctrl F8", DesktopPaneActions.RESIZE);
        result2.put("RIGHT", DesktopPaneActions.RIGHT);
        result2.put("KP_RIGHT", DesktopPaneActions.RIGHT);
        result2.put("shift RIGHT", DesktopPaneActions.SHRINK_RIGHT);
        result2.put("shift KP_RIGHT", DesktopPaneActions.SHRINK_RIGHT);
        result2.put("LEFT", DesktopPaneActions.LEFT);
        result2.put("KP_LEFT", DesktopPaneActions.LEFT);
        result2.put("shift LEFT", DesktopPaneActions.SHRINK_LEFT);
        result2.put("shift KP_LEFT", DesktopPaneActions.SHRINK_LEFT);
        result2.put("UP", DesktopPaneActions.UP);
        result2.put("KP_UP", DesktopPaneActions.UP);
        result2.put("shift UP", DesktopPaneActions.SHRINK_UP);
        result2.put("shift KP_UP", DesktopPaneActions.SHRINK_UP);
        result2.put("DOWN", DesktopPaneActions.DOWN);
        result2.put("KP_DOWN", DesktopPaneActions.DOWN);
        result2.put("shift DOWN", DesktopPaneActions.SHRINK_DOWN);
        result2.put("shift KP_DOWN", DesktopPaneActions.SHRINK_DOWN);
        result2.put("ESCAPE", DesktopPaneActions.ESCAPE);
        result2.put("ctrl F9", DesktopPaneActions.MINIMIZE);
        result2.put("ctrl F10", DesktopPaneActions.MAXIMIZE);
        result2.put("ctrl F6", DesktopPaneActions.NEXT_FRAME);
        result2.put("ctrl TAB", DesktopPaneActions.NEXT_FRAME);
        result2.put("ctrl alt F6", DesktopPaneActions.NEXT_FRAME);
        result2.put("shift ctrl alt F6", DesktopPaneActions.PREVIOUS_FRAME);
        result2.put("ctrl F12", DesktopPaneActions.NAVIGATE_NEXT);
        result2.put("shift ctrl F12", DesktopPaneActions.NAVIGATE_PREVIOUS);
        return result2;
    }

    protected SubstanceInputMap getMultilineTextComponentFocusInputMap() {
        SubstanceInputMap result2 = new SubstanceInputMap();
        result2.put("ctrl C", "copy-to-clipboard");
        result2.put("ctrl V", "paste-from-clipboard");
        result2.put("ctrl X", "cut-to-clipboard");
        result2.put("COPY", "copy-to-clipboard");
        result2.put("PASTE", "paste-from-clipboard");
        result2.put("CUT", "cut-to-clipboard");
        result2.put("control INSERT", "copy-to-clipboard");
        result2.put("shift INSERT", "paste-from-clipboard");
        result2.put("shift DELETE", "cut-to-clipboard");
        result2.put("shift LEFT", "selection-backward");
        result2.put("shift KP_LEFT", "selection-backward");
        result2.put("shift RIGHT", "selection-forward");
        result2.put("shift KP_RIGHT", "selection-forward");
        result2.put("ctrl LEFT", "caret-previous-word");
        result2.put("ctrl KP_LEFT", "caret-previous-word");
        result2.put("ctrl RIGHT", "caret-next-word");
        result2.put("ctrl KP_RIGHT", "caret-next-word");
        result2.put("ctrl shift LEFT", "selection-previous-word");
        result2.put("ctrl shift KP_LEFT", "selection-previous-word");
        result2.put("ctrl shift RIGHT", "selection-next-word");
        result2.put("ctrl shift KP_RIGHT", "selection-next-word");
        result2.put("ctrl A", "select-all");
        result2.put("HOME", "caret-begin-line");
        result2.put("END", "caret-end-line");
        result2.put("shift HOME", "selection-begin-line");
        result2.put("shift END", "selection-end-line");
        result2.put("UP", "caret-up");
        result2.put("KP_UP", "caret-up");
        result2.put("DOWN", "caret-down");
        result2.put("KP_DOWN", "caret-down");
        result2.put("PAGE_UP", "page-up");
        result2.put("PAGE_DOWN", "page-down");
        result2.put("shift PAGE_UP", "selection-page-up");
        result2.put("shift PAGE_DOWN", "selection-page-down");
        result2.put("ctrl shift PAGE_UP", "selection-page-left");
        result2.put("ctrl shift PAGE_DOWN", "selection-page-right");
        result2.put("shift UP", "selection-up");
        result2.put("shift KP_UP", "selection-up");
        result2.put("shift DOWN", "selection-down");
        result2.put("shift KP_DOWN", "selection-down");
        result2.put("ctrl shift HOME", "selection-begin");
        result2.put("ctrl shift END", "selection-end");
        result2.put("ENTER", "insert-break");
        result2.put("BACK_SPACE", "delete-previous");
        result2.put("shift BACK_SPACE", "delete-previous");
        result2.put("ctrl H", "delete-previous");
        result2.put("DELETE", "delete-next");
        result2.put("ctrl DELETE", "delete-next-word");
        result2.put("ctrl BACK_SPACE", "delete-previous-word");
        result2.put("RIGHT", "caret-forward");
        result2.put("KP_RIGHT", "caret-forward");
        result2.put("LEFT", "caret-backward");
        result2.put("KP_LEFT", "caret-backward");
        result2.put("TAB", "insert-tab");
        result2.put("ctrl BACK_SLASH", "unselect");
        result2.put("ctrl HOME", "caret-begin");
        result2.put("ctrl END", "caret-end");
        result2.put("ctrl T", "next-link-action");
        result2.put("ctrl shift T", "previous-link-action");
        result2.put("ctrl SPACE", "activate-link-action");
        result2.put("control shift O", "toggle-componentOrientation");
        return result2;
    }

    @Override
    public SubstanceInputMap getEditorPaneFocusInputMap() {
        return this.getMultilineTextComponentFocusInputMap();
    }

    @Override
    public SubstanceInputMap getFileChooserAncestorInputMap() {
        SubstanceInputMap result2 = new SubstanceInputMap();
        result2.put("ESCAPE", "cancelSelection");
        result2.put("F2", "editFileName");
        result2.put("F5", "refresh");
        result2.put("BACK_SPACE", "Go Up");
        result2.put("ENTER", "approveSelection");
        result2.put("ctrl ENTER", "approveSelection");
        return result2;
    }

    @Override
    public SubstanceInputMap getFormattedTextFieldFocusInputMap() {
        SubstanceInputMap result2 = new SubstanceInputMap();
        result2.put("ctrl C", "copy-to-clipboard");
        result2.put("ctrl V", "paste-from-clipboard");
        result2.put("ctrl X", "cut-to-clipboard");
        result2.put("COPY", "copy-to-clipboard");
        result2.put("PASTE", "paste-from-clipboard");
        result2.put("CUT", "cut-to-clipboard");
        result2.put("control INSERT", "copy-to-clipboard");
        result2.put("shift INSERT", "paste-from-clipboard");
        result2.put("shift DELETE", "cut-to-clipboard");
        result2.put("shift LEFT", "selection-backward");
        result2.put("shift KP_LEFT", "selection-backward");
        result2.put("shift RIGHT", "selection-forward");
        result2.put("shift KP_RIGHT", "selection-forward");
        result2.put("ctrl LEFT", "caret-previous-word");
        result2.put("ctrl KP_LEFT", "caret-previous-word");
        result2.put("ctrl RIGHT", "caret-next-word");
        result2.put("ctrl KP_RIGHT", "caret-next-word");
        result2.put("ctrl shift LEFT", "selection-previous-word");
        result2.put("ctrl shift KP_LEFT", "selection-previous-word");
        result2.put("ctrl shift RIGHT", "selection-next-word");
        result2.put("ctrl shift KP_RIGHT", "selection-next-word");
        result2.put("ctrl A", "select-all");
        result2.put("HOME", "caret-begin-line");
        result2.put("END", "caret-end-line");
        result2.put("shift HOME", "selection-begin-line");
        result2.put("shift END", "selection-end-line");
        result2.put("BACK_SPACE", "delete-previous");
        result2.put("shift BACK_SPACE", "delete-previous");
        result2.put("ctrl H", "delete-previous");
        result2.put("DELETE", "delete-next");
        result2.put("ctrl DELETE", "delete-next-word");
        result2.put("ctrl BACK_SPACE", "delete-previous-word");
        result2.put("RIGHT", "caret-forward");
        result2.put("LEFT", "caret-backward");
        result2.put("KP_RIGHT", "caret-forward");
        result2.put("KP_LEFT", "caret-backward");
        result2.put("ENTER", "notify-field-accept");
        result2.put("ctrl BACK_SLASH", "unselect");
        result2.put("control shift O", "toggle-componentOrientation");
        result2.put("ESCAPE", "reset-field-edit");
        result2.put("UP", "increment");
        result2.put("KP_UP", "increment");
        result2.put("DOWN", "decrement");
        result2.put("KP_DOWN", "decrement");
        return result2;
    }

    @Override
    public SubstanceInputMap getListFocusInputMap() {
        SubstanceInputMap result2 = new SubstanceInputMap();
        result2.put("ctrl C", COPY);
        result2.put("ctrl V", PASTE);
        result2.put("ctrl X", CUT);
        result2.put("COPY", COPY);
        result2.put("PASTE", PASTE);
        result2.put("CUT", CUT);
        result2.put("control INSERT", COPY);
        result2.put("shift INSERT", PASTE);
        result2.put("shift DELETE", CUT);
        result2.put("UP", "selectPreviousRow");
        result2.put("KP_UP", "selectPreviousRow");
        result2.put("shift UP", "selectPreviousRowExtendSelection");
        result2.put("shift KP_UP", "selectPreviousRowExtendSelection");
        result2.put("ctrl shift UP", "selectPreviousRowExtendSelection");
        result2.put("ctrl shift KP_UP", "selectPreviousRowExtendSelection");
        result2.put("ctrl UP", "selectPreviousRowChangeLead");
        result2.put("ctrl KP_UP", "selectPreviousRowChangeLead");
        result2.put("DOWN", "selectNextRow");
        result2.put("KP_DOWN", "selectNextRow");
        result2.put("shift DOWN", "selectNextRowExtendSelection");
        result2.put("shift KP_DOWN", "selectNextRowExtendSelection");
        result2.put("ctrl shift DOWN", "selectNextRowExtendSelection");
        result2.put("ctrl shift KP_DOWN", "selectNextRowExtendSelection");
        result2.put("ctrl DOWN", "selectNextRowChangeLead");
        result2.put("ctrl KP_DOWN", "selectNextRowChangeLead");
        result2.put("LEFT", "selectPreviousColumn");
        result2.put("KP_LEFT", "selectPreviousColumn");
        result2.put("shift LEFT", "selectPreviousColumnExtendSelection");
        result2.put("shift KP_LEFT", "selectPreviousColumnExtendSelection");
        result2.put("ctrl shift LEFT", "selectPreviousColumnExtendSelection");
        result2.put("ctrl shift KP_LEFT", "selectPreviousColumnExtendSelection");
        result2.put("ctrl LEFT", "selectPreviousColumnChangeLead");
        result2.put("ctrl KP_LEFT", "selectPreviousColumnChangeLead");
        result2.put("RIGHT", "selectNextColumn");
        result2.put("KP_RIGHT", "selectNextColumn");
        result2.put("shift RIGHT", "selectNextColumnExtendSelection");
        result2.put("shift KP_RIGHT", "selectNextColumnExtendSelection");
        result2.put("ctrl shift RIGHT", "selectNextColumnExtendSelection");
        result2.put("ctrl shift KP_RIGHT", "selectNextColumnExtendSelection");
        result2.put("ctrl RIGHT", "selectNextColumnChangeLead");
        result2.put("ctrl KP_RIGHT", "selectNextColumnChangeLead");
        result2.put("HOME", "selectFirstRow");
        result2.put("shift HOME", "selectFirstRowExtendSelection");
        result2.put("ctrl shift HOME", "selectFirstRowExtendSelection");
        result2.put("ctrl HOME", "selectFirstRowChangeLead");
        result2.put("END", "selectLastRow");
        result2.put("shift END", "selectLastRowExtendSelection");
        result2.put("ctrl shift END", "selectLastRowExtendSelection");
        result2.put("ctrl END", "selectLastRowChangeLead");
        result2.put("PAGE_UP", "scrollUp");
        result2.put("shift PAGE_UP", "scrollUpExtendSelection");
        result2.put("ctrl shift PAGE_UP", "scrollUpExtendSelection");
        result2.put("ctrl PAGE_UP", "scrollUpChangeLead");
        result2.put("PAGE_DOWN", "scrollDown");
        result2.put("shift PAGE_DOWN", "scrollDownExtendSelection");
        result2.put("ctrl shift PAGE_DOWN", "scrollDownExtendSelection");
        result2.put("ctrl PAGE_DOWN", "scrollDownChangeLead");
        result2.put("ctrl A", "selectAll");
        result2.put("ctrl SLASH", "selectAll");
        result2.put("ctrl BACK_SLASH", "clearSelection");
        result2.put("SPACE", "addToSelection");
        result2.put("ctrl SPACE", "toggleAndAnchor");
        result2.put("shift SPACE", "extendTo");
        result2.put("ctrl shift SPACE", "moveSelectionTo");
        return result2;
    }

    @Override
    public SubstanceInputMap getPasswordFieldFocusInputMap() {
        SubstanceInputMap result2 = new SubstanceInputMap();
        result2.put("ctrl C", "copy-to-clipboard");
        result2.put("ctrl V", "paste-from-clipboard");
        result2.put("ctrl X", "cut-to-clipboard");
        result2.put("COPY", "copy-to-clipboard");
        result2.put("PASTE", "paste-from-clipboard");
        result2.put("CUT", "cut-to-clipboard");
        result2.put("control INSERT", "copy-to-clipboard");
        result2.put("shift INSERT", "paste-from-clipboard");
        result2.put("shift DELETE", "cut-to-clipboard");
        result2.put("shift LEFT", "selection-backward");
        result2.put("shift KP_LEFT", "selection-backward");
        result2.put("shift RIGHT", "selection-forward");
        result2.put("shift KP_RIGHT", "selection-forward");
        result2.put("ctrl LEFT", "caret-begin-line");
        result2.put("ctrl KP_LEFT", "caret-begin-line");
        result2.put("ctrl RIGHT", "caret-end-line");
        result2.put("ctrl KP_RIGHT", "caret-end-line");
        result2.put("ctrl shift LEFT", "selection-begin-line");
        result2.put("ctrl shift KP_LEFT", "selection-begin-line");
        result2.put("ctrl shift RIGHT", "selection-end-line");
        result2.put("ctrl shift KP_RIGHT", "selection-end-line");
        result2.put("ctrl A", "select-all");
        result2.put("HOME", "caret-begin-line");
        result2.put("END", "caret-end-line");
        result2.put("shift HOME", "selection-begin-line");
        result2.put("shift END", "selection-end-line");
        result2.put("BACK_SPACE", "delete-previous");
        result2.put("shift BACK_SPACE", "delete-previous");
        result2.put("ctrl H", "delete-previous");
        result2.put("DELETE", "delete-next");
        result2.put("RIGHT", "caret-forward");
        result2.put("LEFT", "caret-backward");
        result2.put("KP_RIGHT", "caret-forward");
        result2.put("KP_LEFT", "caret-backward");
        result2.put("ENTER", "notify-field-accept");
        result2.put("ctrl BACK_SLASH", "unselect");
        result2.put("control shift O", "toggle-componentOrientation");
        return result2;
    }

    @Override
    public SubstanceInputMap getRadioButtonFocusInputMap() {
        return this.getActionControlFocusInputMap();
    }

    @Override
    public SubstanceInputMap getRootPaneAncestorInputMap() {
        SubstanceInputMap result2 = new SubstanceInputMap();
        result2.put("shift F10", "postPopup");
        result2.put("CONTEXT_MENU", "postPopup");
        return result2;
    }

    @Override
    public SubstanceInputMap getScrollBarAncestorInputMap() {
        SubstanceInputMap result2 = new SubstanceInputMap();
        result2.put("RIGHT", "positiveUnitIncrement");
        result2.put("KP_RIGHT", "positiveUnitIncrement");
        result2.put("DOWN", "positiveUnitIncrement");
        result2.put("KP_DOWN", "positiveUnitIncrement");
        result2.put("PAGE_DOWN", "positiveBlockIncrement");
        result2.put("LEFT", "negativeUnitIncrement");
        result2.put("KP_LEFT", "negativeUnitIncrement");
        result2.put("UP", "negativeUnitIncrement");
        result2.put("KP_UP", "negativeUnitIncrement");
        result2.put("PAGE_UP", "negativeBlockIncrement");
        result2.put("HOME", "minScroll");
        result2.put("END", "maxScroll");
        return result2;
    }

    @Override
    public SubstanceInputMap getScrollPaneAncestorInputMap() {
        SubstanceInputMap result2 = new SubstanceInputMap();
        result2.put("RIGHT", "unitScrollRight");
        result2.put("KP_RIGHT", "unitScrollRight");
        result2.put("DOWN", "unitScrollDown");
        result2.put("KP_DOWN", "unitScrollDown");
        result2.put("LEFT", "unitScrollLeft");
        result2.put("KP_LEFT", "unitScrollLeft");
        result2.put("UP", "unitScrollUp");
        result2.put("KP_UP", "unitScrollUp");
        result2.put("PAGE_UP", "scrollUp");
        result2.put("PAGE_DOWN", "scrollDown");
        result2.put("ctrl PAGE_UP", "scrollLeft");
        result2.put("ctrl PAGE_DOWN", "scrollRight");
        result2.put("ctrl HOME", "scrollHome");
        result2.put("ctrl END", "scrollEnd");
        return result2;
    }

    @Override
    public SubstanceInputMap getSliderFocusInputMap() {
        SubstanceInputMap result2 = new SubstanceInputMap();
        result2.put("RIGHT", "positiveUnitIncrement");
        result2.put("KP_RIGHT", "positiveUnitIncrement");
        result2.put("DOWN", "negativeUnitIncrement");
        result2.put("KP_DOWN", "negativeUnitIncrement");
        result2.put("LEFT", "negativeUnitIncrement");
        result2.put("KP_LEFT", "negativeUnitIncrement");
        result2.put("UP", "positiveUnitIncrement");
        result2.put("KP_UP", "positiveUnitIncrement");
        result2.put("PAGE_DOWN", "negativeBlockIncrement");
        result2.put("ctrl PAGE_DOWN", "negativeBlockIncrement");
        result2.put("PAGE_UP", "positiveBlockIncrement");
        result2.put("ctrl PAGE_UP", "positiveBlockIncrement");
        result2.put("HOME", "minScroll");
        result2.put("END", "maxScroll");
        return result2;
    }

    @Override
    public SubstanceInputMap getSpinnerAncestorInputMap() {
        SubstanceInputMap result2 = new SubstanceInputMap();
        result2.put("UP", "increment");
        result2.put("KP_UP", "increment");
        result2.put("DOWN", "decrement");
        result2.put("KP_DOWN", "decrement");
        return result2;
    }

    @Override
    public SubstanceInputMap getSplitPaneAncestorInputMap() {
        SubstanceInputMap result2 = new SubstanceInputMap();
        result2.put("UP", "negativeIncrement");
        result2.put("DOWN", "positiveIncrement");
        result2.put("LEFT", "negativeIncrement");
        result2.put("RIGHT", "positiveIncrement");
        result2.put("KP_UP", "negativeIncrement");
        result2.put("KP_DOWN", "positiveIncrement");
        result2.put("KP_LEFT", "negativeIncrement");
        result2.put("KP_RIGHT", "positiveIncrement");
        result2.put("HOME", "selectMin");
        result2.put("END", "selectMax");
        result2.put("F8", "startResize");
        result2.put("F6", "toggleFocus");
        result2.put("ctrl TAB", "focusOutForward");
        result2.put("ctrl shift TAB", "focusOutBackward");
        return result2;
    }

    @Override
    public SubstanceInputMap getTabbedPaneAncestorInputMap() {
        SubstanceInputMap result2 = new SubstanceInputMap();
        result2.put("ctrl PAGE_DOWN", "navigatePageDown");
        result2.put("ctrl PAGE_UP", "navigatePageUp");
        result2.put("ctrl UP", "requestFocus");
        result2.put("ctrl KP_UP", "requestFocus");
        return result2;
    }

    @Override
    public SubstanceInputMap getTabbedPaneFocusInputMap() {
        SubstanceInputMap result2 = new SubstanceInputMap();
        result2.put("RIGHT", "navigateRight");
        result2.put("KP_RIGHT", "navigateRight");
        result2.put("LEFT", "navigateLeft");
        result2.put("KP_LEFT", "navigateLeft");
        result2.put("UP", "navigateUp");
        result2.put("KP_UP", "navigateUp");
        result2.put("DOWN", "navigateDown");
        result2.put("KP_DOWN", "navigateDown");
        result2.put("ctrl DOWN", "requestFocusForVisibleComponent");
        result2.put("ctrl KP_DOWN", "requestFocusForVisibleComponent");
        return result2;
    }

    @Override
    public SubstanceInputMap getTableAncestorInputMap() {
        SubstanceInputMap result2 = new SubstanceInputMap();
        result2.put("ctrl C", COPY);
        result2.put("ctrl V", PASTE);
        result2.put("ctrl X", CUT);
        result2.put("COPY", COPY);
        result2.put("PASTE", PASTE);
        result2.put("CUT", CUT);
        result2.put("control INSERT", COPY);
        result2.put("shift INSERT", PASTE);
        result2.put("shift DELETE", CUT);
        result2.put("RIGHT", "selectNextColumn");
        result2.put("KP_RIGHT", "selectNextColumn");
        result2.put("shift RIGHT", "selectNextColumnExtendSelection");
        result2.put("shift KP_RIGHT", "selectNextColumnExtendSelection");
        result2.put("ctrl shift RIGHT", "selectNextColumnExtendSelection");
        result2.put("ctrl shift KP_RIGHT", "selectNextColumnExtendSelection");
        result2.put("ctrl RIGHT", "selectNextColumnChangeLead");
        result2.put("ctrl KP_RIGHT", "selectNextColumnChangeLead");
        result2.put("LEFT", "selectPreviousColumn");
        result2.put("KP_LEFT", "selectPreviousColumn");
        result2.put("shift LEFT", "selectPreviousColumnExtendSelection");
        result2.put("shift KP_LEFT", "selectPreviousColumnExtendSelection");
        result2.put("ctrl shift LEFT", "selectPreviousColumnExtendSelection");
        result2.put("ctrl shift KP_LEFT", "selectPreviousColumnExtendSelection");
        result2.put("ctrl LEFT", "selectPreviousColumnChangeLead");
        result2.put("ctrl KP_LEFT", "selectPreviousColumnChangeLead");
        result2.put("DOWN", "selectNextRow");
        result2.put("KP_DOWN", "selectNextRow");
        result2.put("shift DOWN", "selectNextRowExtendSelection");
        result2.put("shift KP_DOWN", "selectNextRowExtendSelection");
        result2.put("ctrl shift DOWN", "selectNextRowExtendSelection");
        result2.put("ctrl shift KP_DOWN", "selectNextRowExtendSelection");
        result2.put("ctrl DOWN", "selectNextRowChangeLead");
        result2.put("ctrl KP_DOWN", "selectNextRowChangeLead");
        result2.put("UP", "selectPreviousRow");
        result2.put("KP_UP", "selectPreviousRow");
        result2.put("shift UP", "selectPreviousRowExtendSelection");
        result2.put("shift KP_UP", "selectPreviousRowExtendSelection");
        result2.put("ctrl shift UP", "selectPreviousRowExtendSelection");
        result2.put("ctrl shift KP_UP", "selectPreviousRowExtendSelection");
        result2.put("ctrl UP", "selectPreviousRowChangeLead");
        result2.put("ctrl KP_UP", "selectPreviousRowChangeLead");
        result2.put("HOME", "selectFirstColumn");
        result2.put("shift HOME", "selectFirstColumnExtendSelection");
        result2.put("ctrl shift HOME", "selectFirstRowExtendSelection");
        result2.put("ctrl HOME", "selectFirstRow");
        result2.put("END", "selectLastColumn");
        result2.put("shift END", "selectLastColumnExtendSelection");
        result2.put("ctrl shift END", "selectLastRowExtendSelection");
        result2.put("ctrl END", "selectLastRow");
        result2.put("PAGE_UP", "scrollUpChangeSelection");
        result2.put("shift PAGE_UP", "scrollUpExtendSelection");
        result2.put("ctrl shift PAGE_UP", "scrollLeftExtendSelection");
        result2.put("ctrl PAGE_UP", "scrollLeftChangeSelection");
        result2.put("PAGE_DOWN", "scrollDownChangeSelection");
        result2.put("shift PAGE_DOWN", "scrollDownExtendSelection");
        result2.put("ctrl shift PAGE_DOWN", "scrollRightExtendSelection");
        result2.put("ctrl PAGE_DOWN", "scrollRightChangeSelection");
        result2.put("TAB", "selectNextColumnCell");
        result2.put("shift TAB", "selectPreviousColumnCell");
        result2.put("ENTER", "selectNextRowCell");
        result2.put("shift ENTER", "selectPreviousRowCell");
        result2.put("ctrl A", "selectAll");
        result2.put("ctrl SLASH", "selectAll");
        result2.put("ctrl BACK_SLASH", "clearSelection");
        result2.put("ESCAPE", "cancel");
        result2.put("F2", "startEditing");
        result2.put("SPACE", "addToSelection");
        result2.put("ctrl SPACE", "toggleAndAnchor");
        result2.put("shift SPACE", "extendTo");
        result2.put("ctrl shift SPACE", "moveSelectionTo");
        result2.put("F8", "focusHeader");
        return result2;
    }

    @Override
    public SubstanceInputMap getTableHeaderAncestorInputMap() {
        SubstanceInputMap result2 = new SubstanceInputMap();
        result2.put("SPACE", "toggleSortOrder");
        result2.put("LEFT", "selectColumnToLeft");
        result2.put("KP_LEFT", "selectColumnToLeft");
        result2.put("RIGHT", "selectColumnToRight");
        result2.put("KP_RIGHT", "selectColumnToRight");
        result2.put("alt LEFT", "moveColumnLeft");
        result2.put("alt KP_LEFT", "moveColumnLeft");
        result2.put("alt RIGHT", "moveColumnRight");
        result2.put("alt KP_RIGHT", "moveColumnRight");
        result2.put("alt shift LEFT", "resizeLeft");
        result2.put("alt shift KP_LEFT", "resizeLeft");
        result2.put("alt shift RIGHT", "resizeRight");
        result2.put("alt shift KP_RIGHT", "resizeRight");
        result2.put("ESCAPE", "focusTable");
        return result2;
    }

    @Override
    public SubstanceInputMap getTextAreaFocusInputMap() {
        return this.getMultilineTextComponentFocusInputMap();
    }

    @Override
    public SubstanceInputMap getTextFieldFocusInputMap() {
        SubstanceInputMap result2 = new SubstanceInputMap();
        result2.put("ctrl C", "copy-to-clipboard");
        result2.put("ctrl V", "paste-from-clipboard");
        result2.put("ctrl X", "cut-to-clipboard");
        result2.put("COPY", "copy-to-clipboard");
        result2.put("PASTE", "paste-from-clipboard");
        result2.put("CUT", "cut-to-clipboard");
        result2.put("control INSERT", "copy-to-clipboard");
        result2.put("shift INSERT", "paste-from-clipboard");
        result2.put("shift DELETE", "cut-to-clipboard");
        result2.put("shift LEFT", "selection-backward");
        result2.put("shift KP_LEFT", "selection-backward");
        result2.put("shift RIGHT", "selection-forward");
        result2.put("shift KP_RIGHT", "selection-forward");
        result2.put("ctrl LEFT", "caret-previous-word");
        result2.put("ctrl KP_LEFT", "caret-previous-word");
        result2.put("ctrl RIGHT", "caret-next-word");
        result2.put("ctrl KP_RIGHT", "caret-next-word");
        result2.put("ctrl shift LEFT", "selection-previous-word");
        result2.put("ctrl shift KP_LEFT", "selection-previous-word");
        result2.put("ctrl shift RIGHT", "selection-next-word");
        result2.put("ctrl shift KP_RIGHT", "selection-next-word");
        result2.put("ctrl A", "select-all");
        result2.put("HOME", "caret-begin-line");
        result2.put("END", "caret-end-line");
        result2.put("shift HOME", "selection-begin-line");
        result2.put("shift END", "selection-end-line");
        result2.put("BACK_SPACE", "delete-previous");
        result2.put("shift BACK_SPACE", "delete-previous");
        result2.put("ctrl H", "delete-previous");
        result2.put("DELETE", "delete-next");
        result2.put("ctrl DELETE", "delete-next-word");
        result2.put("ctrl BACK_SPACE", "delete-previous-word");
        result2.put("RIGHT", "caret-forward");
        result2.put("LEFT", "caret-backward");
        result2.put("KP_RIGHT", "caret-forward");
        result2.put("KP_LEFT", "caret-backward");
        result2.put("ENTER", "notify-field-accept");
        result2.put("ctrl BACK_SLASH", "unselect");
        result2.put("control shift O", "toggle-componentOrientation");
        return result2;
    }

    @Override
    public SubstanceInputMap getTextPaneFocusInputMap() {
        return this.getMultilineTextComponentFocusInputMap();
    }

    @Override
    public SubstanceInputMap getToggleButtonFocusInputMap() {
        return this.getActionControlFocusInputMap();
    }

    @Override
    public SubstanceInputMap getToolBarAncestorInputMap() {
        SubstanceInputMap result2 = new SubstanceInputMap();
        result2.put("UP", "navigateUp");
        result2.put("KP_UP", "navigateUp");
        result2.put("DOWN", "navigateDown");
        result2.put("KP_DOWN", "navigateDown");
        result2.put("LEFT", "navigateLeft");
        result2.put("KP_LEFT", "navigateLeft");
        result2.put("RIGHT", "navigateRight");
        result2.put("KP_RIGHT", "navigateRight");
        return result2;
    }

    @Override
    public SubstanceInputMap getTreeAncestorInputMap() {
        SubstanceInputMap result2 = new SubstanceInputMap();
        result2.put("ESCAPE", "cancel");
        return result2;
    }

    @Override
    public SubstanceInputMap getTreeFocusInputMap() {
        SubstanceInputMap result2 = new SubstanceInputMap();
        result2.put("ADD", "expand");
        result2.put("SUBTRACT", "collapse");
        result2.put("ctrl C", COPY);
        result2.put("ctrl V", PASTE);
        result2.put("ctrl X", CUT);
        result2.put("COPY", COPY);
        result2.put("PASTE", PASTE);
        result2.put("CUT", CUT);
        result2.put("control INSERT", COPY);
        result2.put("shift INSERT", PASTE);
        result2.put("shift DELETE", CUT);
        result2.put("UP", "selectPrevious");
        result2.put("KP_UP", "selectPrevious");
        result2.put("shift UP", "selectPreviousExtendSelection");
        result2.put("shift KP_UP", "selectPreviousExtendSelection");
        result2.put("ctrl shift UP", "selectPreviousExtendSelection");
        result2.put("ctrl shift KP_UP", "selectPreviousExtendSelection");
        result2.put("ctrl UP", "selectPreviousChangeLead");
        result2.put("ctrl KP_UP", "selectPreviousChangeLead");
        result2.put("DOWN", "selectNext");
        result2.put("KP_DOWN", "selectNext");
        result2.put("shift DOWN", "selectNextExtendSelection");
        result2.put("shift KP_DOWN", "selectNextExtendSelection");
        result2.put("ctrl shift DOWN", "selectNextExtendSelection");
        result2.put("ctrl shift KP_DOWN", "selectNextExtendSelection");
        result2.put("ctrl DOWN", "selectNextChangeLead");
        result2.put("ctrl KP_DOWN", "selectNextChangeLead");
        result2.put("RIGHT", "selectChild");
        result2.put("KP_RIGHT", "selectChild");
        result2.put("LEFT", "selectParent");
        result2.put("KP_LEFT", "selectParent");
        result2.put("PAGE_UP", "scrollUpChangeSelection");
        result2.put("shift PAGE_UP", "scrollUpExtendSelection");
        result2.put("ctrl shift PAGE_UP", "scrollUpExtendSelection");
        result2.put("ctrl PAGE_UP", "scrollUpChangeLead");
        result2.put("PAGE_DOWN", "scrollDownChangeSelection");
        result2.put("shift PAGE_DOWN", "scrollDownExtendSelection");
        result2.put("ctrl shift PAGE_DOWN", "scrollDownExtendSelection");
        result2.put("ctrl PAGE_DOWN", "scrollDownChangeLead");
        result2.put("HOME", "selectFirst");
        result2.put("shift HOME", "selectFirstExtendSelection");
        result2.put("ctrl shift HOME", "selectFirstExtendSelection");
        result2.put("ctrl HOME", "selectFirstChangeLead");
        result2.put("END", "selectLast");
        result2.put("shift END", "selectLastExtendSelection");
        result2.put("ctrl shift END", "selectLastExtendSelection");
        result2.put("ctrl END", "selectLastChangeLead");
        result2.put("F2", "startEditing");
        result2.put("ctrl A", "selectAll");
        result2.put("ctrl SLASH", "selectAll");
        result2.put("ctrl BACK_SLASH", "clearSelection");
        result2.put("ctrl LEFT", "scrollLeft");
        result2.put("ctrl KP_LEFT", "scrollLeft");
        result2.put("ctrl RIGHT", "scrollRight");
        result2.put("ctrl KP_RIGHT", "scrollRight");
        result2.put("SPACE", "addToSelection");
        result2.put("ctrl SPACE", "toggleAndAnchor");
        result2.put("shift SPACE", "extendTo");
        result2.put("ctrl shift SPACE", "moveSelectionTo");
        return result2;
    }

    protected static class TreeActions {
        public static final String SELECT_PREVIOUS = "selectPrevious";
        public static final String SELECT_PREVIOUS_CHANGE_LEAD = "selectPreviousChangeLead";
        public static final String SELECT_PREVIOUS_EXTEND_SELECTION = "selectPreviousExtendSelection";
        public static final String SELECT_NEXT = "selectNext";
        public static final String SELECT_NEXT_CHANGE_LEAD = "selectNextChangeLead";
        public static final String SELECT_NEXT_EXTEND_SELECTION = "selectNextExtendSelection";
        public static final String SELECT_CHILD = "selectChild";
        public static final String SELECT_CHILD_CHANGE_LEAD = "selectChildChangeLead";
        public static final String SELECT_PARENT = "selectParent";
        public static final String SELECT_PARENT_CHANGE_LEAD = "selectParentChangeLead";
        public static final String SCROLL_UP_CHANGE_SELECTION = "scrollUpChangeSelection";
        public static final String SCROLL_UP_CHANGE_LEAD = "scrollUpChangeLead";
        public static final String SCROLL_UP_EXTEND_SELECTION = "scrollUpExtendSelection";
        public static final String SCROLL_DOWN_CHANGE_SELECTION = "scrollDownChangeSelection";
        public static final String SCROLL_DOWN_EXTEND_SELECTION = "scrollDownExtendSelection";
        public static final String SCROLL_DOWN_CHANGE_LEAD = "scrollDownChangeLead";
        public static final String SELECT_FIRST = "selectFirst";
        public static final String SELECT_FIRST_CHANGE_LEAD = "selectFirstChangeLead";
        public static final String SELECT_FIRST_EXTEND_SELECTION = "selectFirstExtendSelection";
        public static final String SELECT_LAST = "selectLast";
        public static final String SELECT_LAST_CHANGE_LEAD = "selectLastChangeLead";
        public static final String SELECT_LAST_EXTEND_SELECTION = "selectLastExtendSelection";
        public static final String TOGGLE = "toggle";
        public static final String CANCEL_EDITING = "cancel";
        public static final String START_EDITING = "startEditing";
        public static final String SELECT_ALL = "selectAll";
        public static final String CLEAR_SELECTION = "clearSelection";
        public static final String SCROLL_LEFT = "scrollLeft";
        public static final String SCROLL_RIGHT = "scrollRight";
        public static final String SCROLL_LEFT_EXTEND_SELECTION = "scrollLeftExtendSelection";
        public static final String SCROLL_RIGHT_EXTEND_SELECTION = "scrollRightExtendSelection";
        public static final String SCROLL_RIGHT_CHANGE_LEAD = "scrollRightChangeLead";
        public static final String SCROLL_LEFT_CHANGE_LEAD = "scrollLeftChangeLead";
        public static final String EXPAND = "expand";
        public static final String COLLAPSE = "collapse";
        public static final String MOVE_SELECTION_TO_PARENT = "moveSelectionToParent";
        public static final String ADD_TO_SELECTION = "addToSelection";
        public static final String TOGGLE_AND_ANCHOR = "toggleAndAnchor";
        public static final String EXTEND_TO = "extendTo";
        public static final String MOVE_SELECTION_TO = "moveSelectionTo";

        protected TreeActions() {
        }
    }

    protected static class ToolBarActions {
        public static final String NAVIGATE_RIGHT = "navigateRight";
        public static final String NAVIGATE_LEFT = "navigateLeft";
        public static final String NAVIGATE_UP = "navigateUp";
        public static final String NAVIGATE_DOWN = "navigateDown";

        protected ToolBarActions() {
        }
    }

    protected static class TableHeaderActions {
        public static final String TOGGLE_SORT_ORDER = "toggleSortOrder";
        public static final String SELECT_COLUMN_TO_LEFT = "selectColumnToLeft";
        public static final String SELECT_COLUMN_TO_RIGHT = "selectColumnToRight";
        public static final String MOVE_COLUMN_LEFT = "moveColumnLeft";
        public static final String MOVE_COLUMN_RIGHT = "moveColumnRight";
        public static final String RESIZE_LEFT = "resizeLeft";
        public static final String RESIZE_RIGHT = "resizeRight";
        public static final String FOCUS_TABLE = "focusTable";

        protected TableHeaderActions() {
        }
    }

    protected static class TableActions {
        public static final String CANCEL_EDITING = "cancel";
        public static final String SELECT_ALL = "selectAll";
        public static final String CLEAR_SELECTION = "clearSelection";
        public static final String START_EDITING = "startEditing";
        public static final String NEXT_ROW = "selectNextRow";
        public static final String NEXT_ROW_CELL = "selectNextRowCell";
        public static final String NEXT_ROW_EXTEND_SELECTION = "selectNextRowExtendSelection";
        public static final String NEXT_ROW_CHANGE_LEAD = "selectNextRowChangeLead";
        public static final String PREVIOUS_ROW = "selectPreviousRow";
        public static final String PREVIOUS_ROW_CELL = "selectPreviousRowCell";
        public static final String PREVIOUS_ROW_EXTEND_SELECTION = "selectPreviousRowExtendSelection";
        public static final String PREVIOUS_ROW_CHANGE_LEAD = "selectPreviousRowChangeLead";
        public static final String NEXT_COLUMN = "selectNextColumn";
        public static final String NEXT_COLUMN_CELL = "selectNextColumnCell";
        public static final String NEXT_COLUMN_EXTEND_SELECTION = "selectNextColumnExtendSelection";
        public static final String NEXT_COLUMN_CHANGE_LEAD = "selectNextColumnChangeLead";
        public static final String PREVIOUS_COLUMN = "selectPreviousColumn";
        public static final String PREVIOUS_COLUMN_CELL = "selectPreviousColumnCell";
        public static final String PREVIOUS_COLUMN_EXTEND_SELECTION = "selectPreviousColumnExtendSelection";
        public static final String PREVIOUS_COLUMN_CHANGE_LEAD = "selectPreviousColumnChangeLead";
        public static final String SCROLL_LEFT_CHANGE_SELECTION = "scrollLeftChangeSelection";
        public static final String SCROLL_LEFT_EXTEND_SELECTION = "scrollLeftExtendSelection";
        public static final String SCROLL_RIGHT_CHANGE_SELECTION = "scrollRightChangeSelection";
        public static final String SCROLL_RIGHT_EXTEND_SELECTION = "scrollRightExtendSelection";
        public static final String SCROLL_UP_CHANGE_SELECTION = "scrollUpChangeSelection";
        public static final String SCROLL_UP_EXTEND_SELECTION = "scrollUpExtendSelection";
        public static final String SCROLL_DOWN_CHANGE_SELECTION = "scrollDownChangeSelection";
        public static final String SCROLL_DOWN_EXTEND_SELECTION = "scrollDownExtendSelection";
        public static final String FIRST_COLUMN = "selectFirstColumn";
        public static final String FIRST_COLUMN_EXTEND_SELECTION = "selectFirstColumnExtendSelection";
        public static final String LAST_COLUMN = "selectLastColumn";
        public static final String LAST_COLUMN_EXTEND_SELECTION = "selectLastColumnExtendSelection";
        public static final String FIRST_ROW = "selectFirstRow";
        public static final String FIRST_ROW_EXTEND_SELECTION = "selectFirstRowExtendSelection";
        public static final String LAST_ROW = "selectLastRow";
        public static final String LAST_ROW_EXTEND_SELECTION = "selectLastRowExtendSelection";
        public static final String ADD_TO_SELECTION = "addToSelection";
        public static final String TOGGLE_AND_ANCHOR = "toggleAndAnchor";
        public static final String EXTEND_TO = "extendTo";
        public static final String MOVE_SELECTION_TO = "moveSelectionTo";
        public static final String FOCUS_HEADER = "focusHeader";

        protected TableActions() {
        }
    }

    protected static class TabbedPaneActions {
        public static final String NEXT = "navigateNext";
        public static final String PREVIOUS = "navigatePrevious";
        public static final String RIGHT = "navigateRight";
        public static final String LEFT = "navigateLeft";
        public static final String UP = "navigateUp";
        public static final String DOWN = "navigateDown";
        public static final String PAGE_UP = "navigatePageUp";
        public static final String PAGE_DOWN = "navigatePageDown";
        public static final String REQUEST_FOCUS = "requestFocus";
        public static final String REQUEST_FOCUS_FOR_VISIBLE = "requestFocusForVisibleComponent";
        public static final String SET_SELECTED = "setSelectedIndex";
        public static final String SELECT_FOCUSED = "selectTabWithFocus";
        public static final String SCROLL_FORWARD = "scrollTabsForwardAction";
        public static final String SCROLL_BACKWARD = "scrollTabsBackwardAction";

        protected TabbedPaneActions() {
        }
    }

    protected static class SplitPaneActions {
        public static final String NEGATIVE_INCREMENT = "negativeIncrement";
        public static final String POSITIVE_INCREMENT = "positiveIncrement";
        public static final String SELECT_MIN = "selectMin";
        public static final String SELECT_MAX = "selectMax";
        public static final String START_RESIZE = "startResize";
        public static final String TOGGLE_FOCUS = "toggleFocus";
        public static final String FOCUS_OUT_FORWARD = "focusOutForward";
        public static final String FOCUS_OUT_BACKWARD = "focusOutBackward";

        protected SplitPaneActions() {
        }
    }

    protected static class SliderActions {
        public static final String POSITIVE_UNIT_INCREMENT = "positiveUnitIncrement";
        public static final String POSITIVE_BLOCK_INCREMENT = "positiveBlockIncrement";
        public static final String NEGATIVE_UNIT_INCREMENT = "negativeUnitIncrement";
        public static final String NEGATIVE_BLOCK_INCREMENT = "negativeBlockIncrement";
        public static final String MIN_SCROLL_INCREMENT = "minScroll";
        public static final String MAX_SCROLL_INCREMENT = "maxScroll";

        protected SliderActions() {
        }
    }

    protected static class ScrollPaneActions {
        public static final String SCROLL_UP = "scrollUp";
        public static final String SCROLL_DOWN = "scrollDown";
        public static final String SCROLL_HOME = "scrollHome";
        public static final String SCROLL_END = "scrollEnd";
        public static final String UNIT_SCROLL_UP = "unitScrollUp";
        public static final String UNIT_SCROLL_DOWN = "unitScrollDown";
        public static final String SCROLL_LEFT = "scrollLeft";
        public static final String SCROLL_RIGHT = "scrollRight";
        public static final String UNIT_SCROLL_LEFT = "unitScrollLeft";
        public static final String UNIT_SCROLL_RIGHT = "unitScrollRight";

        protected ScrollPaneActions() {
        }
    }

    protected static class ScrollBarActions {
        public static final String POSITIVE_UNIT_INCREMENT = "positiveUnitIncrement";
        public static final String POSITIVE_BLOCK_INCREMENT = "positiveBlockIncrement";
        public static final String NEGATIVE_UNIT_INCREMENT = "negativeUnitIncrement";
        public static final String NEGATIVE_BLOCK_INCREMENT = "negativeBlockIncrement";
        public static final String MIN_SCROLL = "minScroll";
        public static final String MAX_SCROLL = "maxScroll";

        protected ScrollBarActions() {
        }
    }

    protected static class RootPaneActions {
        public static final String POST_POPUP = "postPopup";

        protected RootPaneActions() {
        }
    }

    protected static class ListActions {
        public static final String SELECT_PREVIOUS_COLUMN = "selectPreviousColumn";
        public static final String SELECT_PREVIOUS_COLUMN_EXTEND = "selectPreviousColumnExtendSelection";
        public static final String SELECT_PREVIOUS_COLUMN_CHANGE_LEAD = "selectPreviousColumnChangeLead";
        public static final String SELECT_NEXT_COLUMN = "selectNextColumn";
        public static final String SELECT_NEXT_COLUMN_EXTEND = "selectNextColumnExtendSelection";
        public static final String SELECT_NEXT_COLUMN_CHANGE_LEAD = "selectNextColumnChangeLead";
        public static final String SELECT_PREVIOUS_ROW = "selectPreviousRow";
        public static final String SELECT_PREVIOUS_ROW_EXTEND = "selectPreviousRowExtendSelection";
        public static final String SELECT_PREVIOUS_ROW_CHANGE_LEAD = "selectPreviousRowChangeLead";
        public static final String SELECT_NEXT_ROW = "selectNextRow";
        public static final String SELECT_NEXT_ROW_EXTEND = "selectNextRowExtendSelection";
        public static final String SELECT_NEXT_ROW_CHANGE_LEAD = "selectNextRowChangeLead";
        public static final String SELECT_FIRST_ROW = "selectFirstRow";
        public static final String SELECT_FIRST_ROW_EXTEND = "selectFirstRowExtendSelection";
        public static final String SELECT_FIRST_ROW_CHANGE_LEAD = "selectFirstRowChangeLead";
        public static final String SELECT_LAST_ROW = "selectLastRow";
        public static final String SELECT_LAST_ROW_EXTEND = "selectLastRowExtendSelection";
        public static final String SELECT_LAST_ROW_CHANGE_LEAD = "selectLastRowChangeLead";
        public static final String SCROLL_UP = "scrollUp";
        public static final String SCROLL_UP_EXTEND = "scrollUpExtendSelection";
        public static final String SCROLL_UP_CHANGE_LEAD = "scrollUpChangeLead";
        public static final String SCROLL_DOWN = "scrollDown";
        public static final String SCROLL_DOWN_EXTEND = "scrollDownExtendSelection";
        public static final String SCROLL_DOWN_CHANGE_LEAD = "scrollDownChangeLead";
        public static final String SELECT_ALL = "selectAll";
        public static final String CLEAR_SELECTION = "clearSelection";
        public static final String ADD_TO_SELECTION = "addToSelection";
        public static final String TOGGLE_AND_ANCHOR = "toggleAndAnchor";
        public static final String EXTEND_TO = "extendTo";
        public static final String MOVE_SELECTION_TO = "moveSelectionTo";

        protected ListActions() {
        }
    }

    protected static class FileChooserActions {
        public static final String APPROVE_SELECTION = "approveSelection";
        public static final String CANCEL_SELECTION = "cancelSelection";
        public static final String EDIT_FILE_NAME = "editFileName";
        public static final String REFRESH = "refresh";
        public static final String GO_UP = "Go Up";

        protected FileChooserActions() {
        }
    }

    protected static class TextComponentActions {
        public static final String SELECTION_PAGE_UP = "selection-page-up";
        public static final String SELECTION_PAGE_DOWN = "selection-page-down";
        public static final String SELECTION_PAGE_LEFT = "selection-page-left";
        public static final String SELECTION_PAGE_RIGHT = "selection-page-right";
        public static final String UNSELECT = "unselect";
        public static final String TOGGLE_COMPONENT_ORIENTATION = "toggle-componentOrientation";
        public static final String NEXT_LINK = "next-link-action";
        public static final String PREVIOUS_LINK = "previous-link-action";
        public static final String ACTIVATE_LINK = "activate-link-action";
        public static final String RESET_FIELD_EDIT = "reset-field-edit";
        public static final String INCREMENT = "increment";
        public static final String DECREMENT = "decrement";

        protected TextComponentActions() {
        }
    }

    protected static class DesktopPaneActions {
        public static String CLOSE = "close";
        public static String ESCAPE = "escape";
        public static String MAXIMIZE = "maximize";
        public static String MINIMIZE = "minimize";
        public static String MOVE = "move";
        public static String RESIZE = "resize";
        public static String RESTORE = "restore";
        public static String LEFT = "left";
        public static String RIGHT = "right";
        public static String UP = "up";
        public static String DOWN = "down";
        public static String SHRINK_LEFT = "shrinkLeft";
        public static String SHRINK_RIGHT = "shrinkRight";
        public static String SHRINK_UP = "shrinkUp";
        public static String SHRINK_DOWN = "shrinkDown";
        public static String NEXT_FRAME = "selectNextFrame";
        public static String PREVIOUS_FRAME = "selectPreviousFrame";
        public static String NAVIGATE_NEXT = "navigateNext";
        public static String NAVIGATE_PREVIOUS = "navigatePrevious";

        protected DesktopPaneActions() {
        }
    }

    protected static class ComboActions {
        public static final String HIDE = "hidePopup";
        public static final String DOWN = "selectNext";
        public static final String DOWN_2 = "selectNext2";
        public static final String TOGGLE = "togglePopup";
        public static final String TOGGLE_2 = "spacePopup";
        public static final String UP = "selectPrevious";
        public static final String UP_2 = "selectPrevious2";
        public static final String ENTER = "enterPressed";
        public static final String PAGE_DOWN = "pageDownPassThrough";
        public static final String PAGE_UP = "pageUpPassThrough";
        public static final String HOME = "homePassThrough";
        public static final String END = "endPassThrough";

        protected ComboActions() {
        }
    }
}

