/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SteelBlueColorScheme;
import org.pushingpixels.substance.api.colorscheme.SunsetColorScheme;
import org.pushingpixels.substance.api.icon.SubstanceIconPack;
import org.pushingpixels.substance.internal.AnimationConfigurationManager;
import org.pushingpixels.substance.internal.animation.IconGlowTracker;
import org.pushingpixels.substance.internal.contrib.intellij.UIUtil;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.icon.GlowingIcon;

public class SubstanceOptionPaneUI
extends BasicOptionPaneUI {
    private static final int ICON_SIZE = 20;
    private OptionPaneLabel substanceIconLabel;
    private IconGlowTracker iconGlowTracker;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceOptionPaneUI();
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        BackgroundPaintingUtils.updateIfOpaque(g2, c);
    }

    @Override
    protected void addIcon(Container top) {
        Icon sideIcon = this.optionPane == null ? null : this.optionPane.getIcon();
        int messageType = this.optionPane.getMessageType();
        if (sideIcon == null && this.optionPane != null) {
            sideIcon = this.getIconForType(messageType);
        }
        if (sideIcon != null) {
            this.substanceIconLabel = new OptionPaneLabel();
            this.iconGlowTracker = new IconGlowTracker(this.substanceIconLabel);
            GlowingIcon glowingIcon = new GlowingIcon(sideIcon, this.iconGlowTracker);
            glowingIcon.setDampeningFactor(10.0f);
            this.substanceIconLabel.setIcon(glowingIcon);
            this.substanceIconLabel.setBorder(new EmptyBorder(0, 8, 0, 8));
            this.substanceIconLabel.setName("OptionPane.iconLabel");
            this.substanceIconLabel.setVerticalAlignment(1);
            top.add((Component)this.substanceIconLabel, "Before");
        }
    }

    @Override
    protected Icon getIconForType(int messageType) {
        SubstanceIconPack iconPack = SubstanceCortex.GlobalScope.getIconPack();
        int size = (int)(20.0 * UIUtil.getScaleFactor());
        switch (messageType) {
            case 0: {
                return iconPack.getOptionPaneErrorIcon(size, new SunsetColorScheme());
            }
            case 1: {
                return iconPack.getOptionPaneInformationIcon(size, new SteelBlueColorScheme());
            }
            case 2: {
                return iconPack.getOptionPaneWarningIcon(size, new SunsetColorScheme());
            }
            case 3: {
                return iconPack.getOptionPaneQuestionIcon(size, new SteelBlueColorScheme());
            }
        }
        return null;
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        if (this.substanceIconLabel != null && !this.iconGlowTracker.isPlaying()) {
            this.iconGlowTracker.play(3);
        }
    }

    @Override
    protected Container createButtonArea() {
        JPanel bottom = new JPanel();
        bottom.setName("OptionPane.buttonArea");
        bottom.setLayout(new SubstanceFooterLayout(SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(bottom), 8, 4, 1, true), SubstanceCortex.GlobalScope.getButtonBarOrder().isDefaultButtonLeading()));
        this.addButtonComponents(bottom, this.getButtons(), this.getInitialValueIndex());
        return bottom;
    }

    static {
        AnimationConfigurationManager.getInstance().allowAnimations(SubstanceSlices.AnimationFacet.ICON_GLOW, OptionPaneLabel.class);
    }

    private static class SubstanceFooterLayout
    extends BasicOptionPaneUI.ButtonAreaLayout {
        private int padding;
        private boolean isDefaultButtonLeading;

        public SubstanceFooterLayout(int padding, boolean isDefaultButtonLeading) {
            super(true, padding);
            this.padding = padding;
            this.isDefaultButtonLeading = isDefaultButtonLeading;
        }

        @Override
        public void addLayoutComponent(String string2, Component comp) {
        }

        private Dimension getMaxButtonSize(Container container) {
            Component[] children2 = container.getComponents();
            Dimension result2 = new Dimension(0, 0);
            for (Component child : children2) {
                Dimension pref = child.getPreferredSize();
                result2.width = Math.max(result2.width, pref.width);
                result2.height = Math.max(result2.height, pref.height);
            }
            return result2;
        }

        @Override
        public void layoutContainer(Container container) {
            Component[] children2 = container.getComponents();
            if (children2 != null && children2.length > 0) {
                int x;
                int numChildren = children2.length;
                Insets insets = container.getInsets();
                Dimension maxDimension = this.getMaxButtonSize(container);
                int totalButtonWidth = maxDimension.width * numChildren + this.padding * (numChildren - 1);
                boolean isLeftToRight = container.getComponentOrientation().isLeftToRight();
                int buttonAlignment = SubstanceCoreUtilities.getButtonBarGravity(container);
                switch (buttonAlignment) {
                    case 2: {
                        x = insets.left;
                        break;
                    }
                    case 0: {
                        x = (container.getWidth() - insets.left - insets.right - totalButtonWidth) / 2;
                        break;
                    }
                    default: {
                        x = container.getWidth() - insets.right - totalButtonWidth;
                    }
                }
                boolean iterateForward = isLeftToRight == this.isDefaultButtonLeading;
                for (int counter = 0; counter < numChildren; ++counter) {
                    int index = iterateForward ? counter : numChildren - counter - 1;
                    children2[index].setBounds(x, insets.top, maxDimension.width, maxDimension.height);
                    x += children2[index].getWidth() + this.padding;
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            if (container == null) {
                return new Dimension(0, 0);
            }
            Component[] children2 = container.getComponents();
            if (children2 == null || children2.length == 0) {
                return new Dimension(0, 0);
            }
            int numChildren = children2.length;
            Insets insets = container.getInsets();
            Dimension maxDimension = this.getMaxButtonSize(container);
            return new Dimension(insets.left + insets.right + maxDimension.width * numChildren + this.padding * (numChildren - 1), insets.top + insets.bottom + maxDimension.height);
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }
    }

    protected static class OptionPaneLabel
    extends JLabel {
        protected OptionPaneLabel() {
        }
    }
}

