/*
 * Decompiled with CFR 0.152.
 */
package org.reflections8.serializers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.reflections8.Reflections;
import org.reflections8.ReflectionsException;
import org.reflections8.Store;
import org.reflections8.serializers.Serializer;
import org.reflections8.util.ConfigurationBuilder;
import org.reflections8.util.Utils;

public class XmlSerializer
implements Serializer {
    @Override
    public Reflections read(InputStream inputStream2) {
        Reflections reflections8;
        try {
            Constructor constructor = Reflections.class.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            reflections8 = (Reflections)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            reflections8 = new Reflections(new ConfigurationBuilder());
        }
        try {
            Document document = new SAXReader().read(inputStream2);
            for (Object e1 : document.getRootElement().elements()) {
                Element index = (Element)e1;
                for (Object e2 : index.elements()) {
                    Element entry = (Element)e2;
                    Element key = entry.element("key");
                    Element values2 = entry.element("values");
                    for (Object o3 : values2.elements()) {
                        Element value = (Element)o3;
                        reflections8.getStore().getOrCreate(index.getName()).putSingle(key.getText(), value.getText());
                    }
                }
            }
        }
        catch (DocumentException e) {
            throw new ReflectionsException("could not read.", e);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not read. Make sure relevant dependencies exist on classpath.", e);
        }
        return reflections8;
    }

    @Override
    public File save(Reflections reflections, String filename) {
        File file = Utils.prepareFile(filename);
        try {
            Document document = this.createDocument(reflections);
            XMLWriter xmlWriter = new XMLWriter((OutputStream)new FileOutputStream(file), OutputFormat.createPrettyPrint());
            xmlWriter.write(document);
            xmlWriter.close();
        }
        catch (IOException e) {
            throw new ReflectionsException("could not save to file " + filename, e);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not save to file " + filename + ". Make sure relevant dependencies exist on classpath.", e);
        }
        return file;
    }

    @Override
    public String toString(Reflections reflections) {
        Document document = this.createDocument(reflections);
        try {
            StringWriter writer = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)writer, OutputFormat.createPrettyPrint());
            xmlWriter.write(document);
            xmlWriter.close();
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    private Document createDocument(Reflections reflections8) {
        Store map2 = reflections8.getStore();
        Document document = DocumentFactory.getInstance().createDocument();
        Element root = document.addElement("Reflections");
        for (String indexName : map2.keySet()) {
            Element indexElement = root.addElement(indexName);
            for (String key : map2.get(indexName).keySet()) {
                Element entryElement = indexElement.addElement("entry");
                entryElement.addElement("key").setText(key);
                Element valuesElement = entryElement.addElement("values");
                for (String value : (Set)map2.get(indexName).get(key)) {
                    valuesElement.addElement("value").setText(value);
                }
            }
        }
        return document;
    }
}

